import * as _heroui_theme from '@heroui/theme';
import { AccordionGroupVariantProps } from '@heroui/theme';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { MultipleSelection, SelectionBehavior } from '@react-types/shared';
import { AriaAccordionProps } from '@react-types/accordion';
import { ReactRef } from '@heroui/react-utils';
import react__default, { Key } from 'react';
import { TreeState } from '@react-stately/tree';
import { DividerProps } from '@heroui/divider';
import { AccordionItemProps } from './accordion-item.js';
import './use-accordion-item.js';
import 'framer-motion';
import './base/accordion-item-base.js';
import '@heroui/aria-utils';
import 'tailwind-variants';

interface Props extends HTMLHeroUIProps<"div"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLDivElement | null>;
    /**
     * Whether to display a divider at the bottom of the each accordion item.
     *
     * @default true
     */
    showDivider?: boolean;
    /**
     * The divider props.
     */
    dividerProps?: Partial<DividerProps>;
    /**
     * The accordion selection behavior.
     * @default "toggle"
     */
    selectionBehavior?: SelectionBehavior;
    /**
     * Whether to keep the accordion content mounted when collapsed.
     * @default false
     */
    keepContentMounted?: boolean;
    /**
     * The accordion items classNames.
     */
    itemClasses?: AccordionItemProps["classNames"];
}
type UseAccordionProps<T extends object = {}> = Props & AccordionGroupVariantProps & Pick<AccordionItemProps, "isCompact" | "isDisabled" | "hideIndicator" | "disableAnimation" | "disableIndicatorAnimation" | "motionProps"> & AriaAccordionProps<T> & MultipleSelection;
type ValuesType<T extends object = {}> = {
    state: TreeState<T>;
    focusedKey?: Key | null;
    isCompact?: AccordionItemProps["isCompact"];
    isDisabled?: AccordionItemProps["isDisabled"];
    hideIndicator?: AccordionItemProps["hideIndicator"];
    disableAnimation?: AccordionItemProps["disableAnimation"];
    keepContentMounted?: Props["keepContentMounted"];
    disableIndicatorAnimation?: AccordionItemProps["disableAnimation"];
    motionProps?: AccordionItemProps["motionProps"];
};
declare function useAccordion<T extends object>(props: UseAccordionProps<T>): {
    Component: _heroui_system.As<any>;
    values: ValuesType<T>;
    state: TreeState<T>;
    focusedKey: react__default.Key | null;
    getBaseProps: PropGetter;
    isSplitted: boolean;
    classNames: string;
    showDivider: boolean;
    dividerProps: Partial<DividerProps>;
    disableAnimation: boolean;
    handleFocusChanged: (isFocused: boolean, key: Key | null) => void;
    itemClasses: _heroui_theme.SlotsToClasses<"base" | "title" | "content" | "heading" | "startContent" | "indicator" | "titleWrapper" | "subtitle" | "trigger"> | undefined;
};
type UseAccordionReturn = ReturnType<typeof useAccordion>;

export { type UseAccordionProps, type UseAccordionReturn, type ValuesType, useAccordion };
