"use client";
import {
  usePopoverContext
} from "./chunk-CGIRYUEE.mjs";

// src/popover-content.tsx
import { useMemo, useRef } from "react";
import { DismissButton } from "@react-aria/overlays";
import { TRANSITION_VARIANTS } from "@heroui/framer-utils";
import { m, LazyMotion } from "framer-motion";
import { getTransformOrigins } from "@heroui/aria-utils";
import { useDialog } from "@react-aria/dialog";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var domAnimation = () => import("@heroui/dom-animation").then((res) => res.default);
var PopoverContent = (props) => {
  const { as, children, className, ...otherProps } = props;
  const {
    Component: OverlayComponent,
    placement,
    backdrop,
    motionProps,
    disableAnimation,
    getPopoverProps,
    getDialogProps,
    getBackdropProps,
    getContentProps,
    isNonModal,
    onClose
  } = usePopoverContext();
  const dialogRef = useRef(null);
  const { dialogProps: ariaDialogProps, titleProps } = useDialog({}, dialogRef);
  const dialogProps = getDialogProps({
    ref: dialogRef,
    ...ariaDialogProps,
    ...otherProps
  });
  const Component = as || OverlayComponent || "div";
  const content = /* @__PURE__ */ jsxs(Fragment, { children: [
    !isNonModal && /* @__PURE__ */ jsx(DismissButton, { onDismiss: onClose }),
    /* @__PURE__ */ jsx(Component, { ...dialogProps, children: /* @__PURE__ */ jsx("div", { ...getContentProps({ className }), children: typeof children === "function" ? children(titleProps) : children }) }),
    /* @__PURE__ */ jsx(DismissButton, { onDismiss: onClose })
  ] });
  const backdropContent = useMemo(() => {
    if (backdrop === "transparent") {
      return null;
    }
    if (disableAnimation) {
      return /* @__PURE__ */ jsx("div", { ...getBackdropProps() });
    }
    return /* @__PURE__ */ jsx(LazyMotion, { features: domAnimation, children: /* @__PURE__ */ jsx(
      m.div,
      {
        animate: "enter",
        exit: "exit",
        initial: "exit",
        variants: TRANSITION_VARIANTS.fade,
        ...getBackdropProps()
      }
    ) });
  }, [backdrop, disableAnimation, getBackdropProps]);
  const style = placement ? getTransformOrigins(placement === "center" ? "top" : placement) : void 0;
  const contents = /* @__PURE__ */ jsx(Fragment, { children: disableAnimation ? content : /* @__PURE__ */ jsx(LazyMotion, { features: domAnimation, children: /* @__PURE__ */ jsx(
    m.div,
    {
      animate: "enter",
      exit: "exit",
      initial: "initial",
      style,
      variants: TRANSITION_VARIANTS.scaleSpringOpacity,
      ...motionProps,
      children: content
    }
  ) }) });
  return /* @__PURE__ */ jsxs("div", { ...getPopoverProps(), children: [
    backdropContent,
    contents
  ] });
};
PopoverContent.displayName = "HeroUI.PopoverContent";
var popover_content_default = PopoverContent;

export {
  popover_content_default
};
