"use client";

// src/use-table.ts
import { useCallback } from "react";
import { useTableState } from "@react-stately/table";
import { useTable as useReactAriaTable } from "@react-aria/table";
import { mapPropsVariants, useProviderContext } from "@heroui/system";
import { table } from "@heroui/theme";
import { useDOMRef, filterDOMProps } from "@heroui/react-utils";
import { mergeProps } from "@react-aria/utils";
import { clsx, objectToDeps } from "@heroui/shared-utils";
import { useMemo } from "react";
function useTable(originalProps) {
  var _a;
  const globalContext = useProviderContext();
  const [props, variantProps] = mapPropsVariants(originalProps, table.variantKeys);
  const {
    ref,
    as,
    baseRef,
    children,
    className,
    classNames,
    removeWrapper = false,
    disableAnimation = (_a = globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _a : false,
    isKeyboardNavigationDisabled = false,
    selectionMode = "none",
    topContentPlacement = "inside",
    bottomContentPlacement = "inside",
    selectionBehavior = selectionMode === "none" ? null : "toggle",
    disabledBehavior = "selection",
    showSelectionCheckboxes = selectionMode === "multiple" && selectionBehavior !== "replace",
    BaseComponent = "div",
    checkboxesProps,
    topContent,
    bottomContent,
    onRowAction,
    onCellAction,
    ...otherProps
  } = props;
  const Component = as || "table";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = useDOMRef(ref);
  const domBaseRef = useDOMRef(baseRef);
  const state = useTableState({
    ...originalProps,
    children,
    showSelectionCheckboxes
  });
  if (isKeyboardNavigationDisabled && !state.isKeyboardNavigationDisabled) {
    state.setKeyboardNavigationDisabled(true);
  }
  const { collection } = state;
  const { layout, ...otherOriginalProps } = originalProps;
  const { gridProps } = useReactAriaTable({ ...otherOriginalProps }, state, domRef);
  const isSelectable = selectionMode !== "none";
  const isMultiSelectable = selectionMode === "multiple";
  const slots = useMemo(
    () => table({
      ...variantProps,
      isSelectable,
      isMultiSelectable
    }),
    [objectToDeps(variantProps), isSelectable, isMultiSelectable]
  );
  const baseStyles = clsx(classNames == null ? void 0 : classNames.base, className);
  const values = useMemo(
    () => {
      var _a2;
      return {
        state,
        slots,
        isSelectable,
        collection,
        classNames,
        color: originalProps == null ? void 0 : originalProps.color,
        disableAnimation,
        checkboxesProps,
        isHeaderSticky: (_a2 = originalProps == null ? void 0 : originalProps.isHeaderSticky) != null ? _a2 : false,
        selectionMode,
        selectionBehavior,
        disabledBehavior,
        showSelectionCheckboxes,
        onRowAction,
        onCellAction
      };
    },
    [
      slots,
      state,
      collection,
      isSelectable,
      classNames,
      selectionMode,
      selectionBehavior,
      checkboxesProps,
      disabledBehavior,
      disableAnimation,
      showSelectionCheckboxes,
      originalProps == null ? void 0 : originalProps.color,
      originalProps == null ? void 0 : originalProps.isHeaderSticky,
      onRowAction,
      onCellAction
    ]
  );
  const getBaseProps = useCallback(
    (props2) => ({
      ...props2,
      ref: domBaseRef,
      className: slots.base({ class: clsx(baseStyles, props2 == null ? void 0 : props2.className) })
    }),
    [baseStyles, slots]
  );
  const getWrapperProps = useCallback(
    (props2) => ({
      ...props2,
      ref: domBaseRef,
      className: slots.wrapper({ class: clsx(classNames == null ? void 0 : classNames.wrapper, props2 == null ? void 0 : props2.className) })
    }),
    [classNames == null ? void 0 : classNames.wrapper, slots]
  );
  const getTableProps = useCallback(
    (props2) => ({
      ...mergeProps(
        gridProps,
        filterDOMProps(otherProps, {
          enabled: shouldFilterDOMProps
        }),
        props2
      ),
      // avoid typeahead debounce wait for input / textarea
      // so that typing with space won't be blocked
      onKeyDownCapture: void 0,
      ref: domRef,
      className: slots.table({ class: clsx(classNames == null ? void 0 : classNames.table, props2 == null ? void 0 : props2.className) })
    }),
    [classNames == null ? void 0 : classNames.table, shouldFilterDOMProps, slots, gridProps, otherProps]
  );
  return {
    BaseComponent,
    Component,
    children,
    state,
    collection,
    values,
    topContent,
    bottomContent,
    removeWrapper,
    topContentPlacement,
    bottomContentPlacement,
    getBaseProps,
    getWrapperProps,
    getTableProps
  };
}

export {
  useTable
};
