"use client";
import {
  tab_panel_default
} from "./chunk-7ARJTFQR.mjs";
import {
  tab_default
} from "./chunk-BM6MJNZ5.mjs";
import {
  useTabs
} from "./chunk-BLIEYGZ2.mjs";

// src/tabs.tsx
import { useId } from "react";
import { LayoutGroup } from "framer-motion";
import { forwardRef } from "@heroui/system";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var Tabs = forwardRef(function Tabs2(props, ref) {
  const {
    Component,
    values,
    state,
    destroyInactiveTabPanel,
    getBaseProps,
    getTabListProps,
    getWrapperProps
  } = useTabs({
    ...props,
    ref
  });
  const layoutId = useId();
  const layoutGroupEnabled = !props.disableAnimation && !props.disableCursorAnimation;
  const tabsProps = {
    state,
    listRef: values.listRef,
    slots: values.slots,
    classNames: values.classNames,
    isDisabled: values.isDisabled,
    motionProps: values.motionProps,
    disableAnimation: values.disableAnimation,
    shouldSelectOnPressUp: values.shouldSelectOnPressUp,
    disableCursorAnimation: values.disableCursorAnimation
  };
  const tabs = [...state.collection].map((item) => /* @__PURE__ */ jsx(tab_default, { item, ...tabsProps, ...item.props }, item.key));
  const renderTabs = /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("div", { ...getBaseProps(), children: /* @__PURE__ */ jsx(Component, { ...getTabListProps(), children: layoutGroupEnabled ? /* @__PURE__ */ jsx(LayoutGroup, { id: layoutId, children: tabs }) : tabs }) }),
    [...state.collection].map((item) => {
      return /* @__PURE__ */ jsx(
        tab_panel_default,
        {
          classNames: values.classNames,
          destroyInactiveTabPanel,
          slots: values.slots,
          state: values.state,
          tabKey: item.key
        },
        item.key
      );
    })
  ] });
  if ("placement" in props || "isVertical" in props) {
    return /* @__PURE__ */ jsx("div", { ...getWrapperProps(), children: renderTabs });
  }
  return renderTabs;
});
var tabs_default = Tabs;

export {
  tabs_default
};
