import * as react_jsx_runtime from 'react/jsx-runtime';
import { CalendarState, RangeCalendarState } from '@react-stately/calendar';
import { CalendarReturnType, SlotsToClasses, CalendarSlots } from '@heroui/theme';
import { CalendarDate } from '@internationalized/date';
import { AriaCalendarCellProps } from '@react-aria/calendar';
import { HTMLHeroUIProps } from '@heroui/system';

interface CalendarCellProps extends HTMLHeroUIProps<"td">, AriaCalendarCellProps {
    state: CalendarState | RangeCalendarState;
    isPickerVisible?: boolean;
    slots?: CalendarReturnType;
    classNames?: SlotsToClasses<CalendarSlots>;
    currentMonth: CalendarDate;
    firstDayOfWeek?: "sun" | "mon" | "tue" | "wed" | "thu" | "fri" | "sat";
}
declare function CalendarCell(originalProps: CalendarCellProps): react_jsx_runtime.JSX.Element;

export { CalendarCell, type CalendarCellProps };
