"use client";
import {
  CardProvider
} from "./chunk-XHGGCEVJ.mjs";
import {
  useCard
} from "./chunk-NVHFBF4D.mjs";

// src/card.tsx
import { forwardRef } from "@heroui/system";
import { Ripple } from "@heroui/ripple";
import { jsx, jsxs } from "react/jsx-runtime";
var Card = forwardRef((props, ref) => {
  const {
    children,
    context,
    Component,
    isPressable,
    disableAnimation,
    disableRipple,
    getCardProps,
    getRippleProps
  } = useCard({ ...props, ref });
  return /* @__PURE__ */ jsxs(Component, { ...getCardProps(), children: [
    /* @__PURE__ */ jsx(CardProvider, { value: context, children }),
    isPressable && !disableAnimation && !disableRipple && /* @__PURE__ */ jsx(Ripple, { ...getRippleProps() })
  ] });
});
Card.displayName = "HeroUI.Card";
var card_default = Card;

export {
  card_default
};
