import * as react from 'react';
import { MouseEventHandler } from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { AriaLinkProps } from '@react-types/link';
import { LinkVariantProps } from '@heroui/theme';
import { ReactRef } from '@heroui/react-utils';

interface Props extends HTMLHeroUIProps<"a">, LinkVariantProps {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLAnchorElement | null>;
    /**
     * Whether the link is external.
     * @default false
     */
    isExternal?: boolean;
    /**
     * Whether to show the icon when the link is external.
     * @default false
     */
    showAnchorIcon?: boolean;
    /**
     * The icon to display right after the link.
     * @default <LinkIcon />
     */
    anchorIcon?: React.ReactNode;
    /**
     * The native link click event handler.
     * use `onPress` instead.
     * @deprecated
     */
    onClick?: MouseEventHandler<HTMLAnchorElement>;
}
type UseLinkProps = Props & AriaLinkProps;
declare function useLink(originalProps: UseLinkProps): {
    Component: _heroui_system.As<any>;
    children: react.ReactNode;
    anchorIcon: react.ReactNode;
    showAnchorIcon: boolean;
    getLinkProps: PropGetter;
};
type UseLinkReturn = ReturnType<typeof useLink>;

export { type UseLinkProps, type UseLinkReturn, useLink };
