/*
 * Decompiled with CFR 0.152.
 */
package fr.imators.shop.gui;

import fr.imators.shop.ImatorsShop;
import fr.imators.shop.gui.ShopGUI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ItemCreationGUI
implements Listener {
    private static Map<Player, ItemCreationGUI> activeItemGUIs = new HashMap<Player, ItemCreationGUI>();
    private static Map<Player, String> waitingForInput = new HashMap<Player, String>();
    private static Map<Player, Material> playerMaterials = new HashMap<Player, Material>();
    private static Map<Player, String> playerItemNames = new HashMap<Player, String>();
    private static Map<Player, Double> playerPrices = new HashMap<Player, Double>();
    private static Map<Player, Integer> playerStocks = new HashMap<Player, Integer>();
    private int shopId;
    private Player player;

    public ItemCreationGUI(int shopId) {
        this.shopId = shopId;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ImatorsShop.getInstance());
    }

    public void open(Player player) {
        this.player = player;
        activeItemGUIs.put(player, this);
        Material selectedMaterial = playerMaterials.get(player);
        String itemName = playerItemNames.get(player);
        Double price = playerPrices.get(player);
        Integer stock = playerStocks.get(player);
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)(String.valueOf(ChatColor.BLUE) + "Cr\u00e9er un article"));
        ItemStack materialItem = new ItemStack(selectedMaterial != null ? selectedMaterial : Material.STONE);
        ItemMeta materialMeta = materialItem.getItemMeta();
        materialMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Mat\u00e9riau");
        materialMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Mat\u00e9riau actuel:", selectedMaterial != null ? String.valueOf(ChatColor.GREEN) + selectedMaterial.name() : String.valueOf(ChatColor.RED) + "Non d\u00e9fini", "", String.valueOf(ChatColor.YELLOW) + "Tiens l'item et clique ici"));
        materialItem.setItemMeta(materialMeta);
        ItemStack nameItem = new ItemStack(Material.NAME_TAG);
        ItemMeta nameMeta = nameItem.getItemMeta();
        nameMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Nom de l'article");
        nameMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Nom actuel:", itemName != null ? String.valueOf(ChatColor.GREEN) + itemName : String.valueOf(ChatColor.RED) + "Non d\u00e9fini", "", String.valueOf(ChatColor.YELLOW) + "Clique pour d\u00e9finir"));
        nameItem.setItemMeta(nameMeta);
        ItemStack priceItem = new ItemStack(Material.GOLD_INGOT);
        ItemMeta priceMeta = priceItem.getItemMeta();
        priceMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Prix");
        priceMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Prix actuel:", price != null ? String.valueOf(ChatColor.GREEN) + String.valueOf(price) + " FCoins" : String.valueOf(ChatColor.RED) + "Non d\u00e9fini", "", String.valueOf(ChatColor.YELLOW) + "Clique pour d\u00e9finir"));
        priceItem.setItemMeta(priceMeta);
        ItemStack stockItem = new ItemStack(Material.CHEST);
        ItemMeta stockMeta = stockItem.getItemMeta();
        stockMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Stock");
        stockMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Stock actuel:", stock != null ? String.valueOf(ChatColor.GREEN) + String.valueOf(stock) : String.valueOf(ChatColor.RED) + "Non d\u00e9fini", "", String.valueOf(ChatColor.YELLOW) + "Clique pour recalculer", String.valueOf(ChatColor.GRAY) + "(bas\u00e9 sur ton inventaire)"));
        stockItem.setItemMeta(stockMeta);
        ItemStack createItem = new ItemStack(Material.EMERALD);
        ItemMeta createMeta = createItem.getItemMeta();
        createMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Cr\u00e9er l'article");
        createMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Clique pour cr\u00e9er", this.isComplete(player) ? String.valueOf(ChatColor.GREEN) + "Pr\u00eat !" : String.valueOf(ChatColor.RED) + "Incomplet"));
        createItem.setItemMeta(createMeta);
        ItemStack cancelItem = new ItemStack(Material.BARRIER);
        ItemMeta cancelMeta = cancelItem.getItemMeta();
        cancelMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Annuler");
        cancelItem.setItemMeta(cancelMeta);
        inv.setItem(10, materialItem);
        inv.setItem(12, nameItem);
        inv.setItem(14, priceItem);
        inv.setItem(16, stockItem);
        inv.setItem(22, createItem);
        inv.setItem(26, cancelItem);
        player.openInventory(inv);
    }

    private boolean isComplete(Player player) {
        return playerMaterials.get(player) != null && playerItemNames.get(player) != null && playerPrices.get(player) != null && playerStocks.get(player) != null;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        block28: {
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            if (!activeItemGUIs.containsKey(player)) {
                return;
            }
            if (!event.getView().getTitle().equals(String.valueOf(ChatColor.BLUE) + "Cr\u00e9er un article")) {
                return;
            }
            event.setCancelled(true);
            if (event.getCurrentItem() == null) {
                return;
            }
            ItemCreationGUI gui = activeItemGUIs.get(player);
            if (event.getSlot() == 10) {
                ItemStack handItem = player.getItemInHand();
                if (handItem != null && handItem.getType() != Material.AIR) {
                    playerMaterials.put(player, handItem.getType());
                    int availableStock = 0;
                    for (ItemStack item : player.getInventory().getContents()) {
                        if (item == null || item.getType() != handItem.getType()) continue;
                        availableStock += item.getAmount();
                    }
                    playerStocks.put(player, availableStock);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Mat\u00e9riau d\u00e9fini : " + handItem.getType().name());
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Stock automatique : " + availableStock + " (bas\u00e9 sur ton inventaire)");
                    gui.open(player);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Tiens un item dans ta main !");
                }
            } else if (event.getCurrentItem().getType() == Material.NAME_TAG) {
                player.closeInventory();
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u00c9cris le nom de l'article dans le chat :");
                waitingForInput.put(player, "name");
            } else if (event.getCurrentItem().getType() == Material.GOLD_INGOT) {
                player.closeInventory();
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u00c9cris le prix de l'article dans le chat :");
                waitingForInput.put(player, "price");
            } else if (event.getCurrentItem().getType() == Material.CHEST) {
                Material selectedMat = playerMaterials.get(player);
                if (selectedMat != null) {
                    int availableStock = 0;
                    for (ItemStack item : player.getInventory().getContents()) {
                        if (item == null || item.getType() != selectedMat) continue;
                        availableStock += item.getAmount();
                    }
                    playerStocks.put(player, availableStock);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Stock mis \u00e0 jour : " + availableStock + " (bas\u00e9 sur ton inventaire)");
                    gui.open(player);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "S\u00e9lectionne d'abord un mat\u00e9riau !");
                }
            } else if (event.getCurrentItem().getType() == Material.EMERALD) {
                if (!this.isComplete(player)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Tu dois remplir tous les champs !");
                    return;
                }
                try {
                    boolean success = ImatorsShop.getInstance().getShopManager().addShopItem(gui.shopId, playerMaterials.get(player).name(), playerItemNames.get(player), playerPrices.get(player), playerStocks.get(player));
                    if (success) {
                        int stockAmount = playerStocks.get(player);
                        Material material = playerMaterials.get(player);
                        int removed = 0;
                        for (int i = 0; i < player.getInventory().getSize() && removed < stockAmount; ++i) {
                            ItemStack item = player.getInventory().getItem(i);
                            if (item == null || item.getType() != material) continue;
                            int toRemove = Math.min(item.getAmount(), stockAmount - removed);
                            if (toRemove >= item.getAmount()) {
                                player.getInventory().setItem(i, null);
                            } else {
                                item.setAmount(item.getAmount() - toRemove);
                            }
                            removed += toRemove;
                        }
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Article cr\u00e9\u00e9 avec succ\u00e8s !");
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + String.valueOf(removed) + " items retir\u00e9s de ton inventaire !");
                        player.closeInventory();
                        activeItemGUIs.remove(player);
                        playerMaterials.remove(player);
                        playerItemNames.remove(player);
                        playerPrices.remove(player);
                        playerStocks.remove(player);
                        Bukkit.getScheduler().runTaskLater((Plugin)ImatorsShop.getInstance(), () -> new ShopGUI(gui.shopId).open(player), 1L);
                        break block28;
                    }
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Erreur lors de la cr\u00e9ation !");
                }
                catch (Exception e) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Erreur: " + e.getMessage());
                    e.printStackTrace();
                }
            } else if (event.getCurrentItem().getType() == Material.BARRIER) {
                player.closeInventory();
                activeItemGUIs.remove(player);
                playerMaterials.remove(player);
                playerItemNames.remove(player);
                playerPrices.remove(player);
                playerStocks.remove(player);
                new ShopGUI(gui.shopId).open(player);
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!waitingForInput.containsKey(player)) {
            return;
        }
        if (!activeItemGUIs.containsKey(player)) {
            return;
        }
        event.setCancelled(true);
        String inputType = waitingForInput.get(player);
        ItemCreationGUI gui = activeItemGUIs.get(player);
        String input = event.getMessage().trim();
        try {
            switch (inputType) {
                case "name": {
                    if (input.length() > 30) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Le nom est trop long (max 30 caract\u00e8res) !");
                        return;
                    }
                    playerItemNames.put(player, input);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Nom d\u00e9fini : " + input);
                    break;
                }
                case "price": {
                    double priceValue = Double.parseDouble(input);
                    if (priceValue < 0.0) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Le prix ne peut pas \u00eatre n\u00e9gatif !");
                        return;
                    }
                    playerPrices.put(player, priceValue);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Prix d\u00e9fini : " + priceValue + " FCoins");
                    break;
                }
                case "stock": {
                    int stockValue = Integer.parseInt(input);
                    if (stockValue < -1) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Le stock ne peut pas \u00eatre inf\u00e9rieur \u00e0 -1 !");
                        return;
                    }
                    playerStocks.put(player, stockValue);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Stock d\u00e9fini : " + (stockValue == -1 ? "Illimit\u00e9" : String.valueOf(stockValue)));
                }
            }
            waitingForInput.remove(player);
            Bukkit.getScheduler().runTask((Plugin)ImatorsShop.getInstance(), () -> gui.open(player));
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Valeur invalide !");
        }
    }
}

