/*
 * Decompiled with CFR 0.152.
 */
package fr.imators.shop.managers;

import fr.imators.shop.ImatorsShop;
import fr.imators.shop.models.Shop;
import fr.imators.shop.models.ShopItem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class ShopManager {
    public boolean createShop(Location location, String ownerUuid, String shopName) {
        try {
            ResultSet rs;
            Connection conn = ImatorsShop.getInstance().getDatabaseManager().getConnection();
            PreparedStatement stmt = conn.prepareStatement("INSERT INTO shops (location_world, location_x, location_y, location_z, owner_uuid, shop_name) VALUES (?, ?, ?, ?, ?, ?)", 1);
            stmt.setString(1, location.getWorld().getName());
            stmt.setInt(2, location.getBlockX());
            stmt.setInt(3, location.getBlockY());
            stmt.setInt(4, location.getBlockZ());
            stmt.setString(5, ownerUuid);
            stmt.setString(6, shopName);
            int result = stmt.executeUpdate();
            if (result > 0 && (rs = stmt.getGeneratedKeys()).next()) {
                this.updateSign(location, shopName);
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean addShopItem(int shopId, String material, String itemName, double price, int stock) {
        try {
            Connection conn = ImatorsShop.getInstance().getDatabaseManager().getConnection();
            PreparedStatement stmt = conn.prepareStatement("INSERT INTO shop_items (shop_id, item_material, item_name, price, stock) VALUES (?, ?, ?, ?, ?)");
            stmt.setInt(1, shopId);
            stmt.setString(2, material);
            stmt.setString(3, itemName);
            stmt.setDouble(4, price);
            stmt.setInt(5, stock);
            return stmt.executeUpdate() > 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getShopIdByLocation(Location location) {
        try {
            Connection conn = ImatorsShop.getInstance().getDatabaseManager().getConnection();
            PreparedStatement stmt = conn.prepareStatement("SELECT id FROM shops WHERE location_world = ? AND location_x = ? AND location_y = ? AND location_z = ?");
            stmt.setString(1, location.getWorld().getName());
            stmt.setInt(2, location.getBlockX());
            stmt.setInt(3, location.getBlockY());
            stmt.setInt(4, location.getBlockZ());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                return rs.getInt("id");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public Shop getShop(int shopId) {
        try {
            Connection conn = ImatorsShop.getInstance().getDatabaseManager().getConnection();
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM shops WHERE id = ?");
            stmt.setInt(1, shopId);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                return new Shop(rs.getInt("id"), rs.getString("shop_name"), rs.getString("owner_uuid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<ShopItem> getShopItems(int shopId) {
        ArrayList<ShopItem> items = new ArrayList<ShopItem>();
        try {
            Connection conn = ImatorsShop.getInstance().getDatabaseManager().getConnection();
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM shop_items WHERE shop_id = ?");
            stmt.setInt(1, shopId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                items.add(new ShopItem(rs.getInt("id"), rs.getInt("shop_id"), rs.getString("item_material"), rs.getString("item_name"), rs.getDouble("price"), rs.getInt("stock")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return items;
    }

    public boolean purchaseItem(int itemId, int buyerUserId, String buyerName) {
        try {
            Connection conn = ImatorsShop.getInstance().getDatabaseManager().getConnection();
            PreparedStatement itemStmt = conn.prepareStatement("SELECT si.*, s.owner_uuid FROM shop_items si JOIN shops s ON si.shop_id = s.id WHERE si.id = ?");
            itemStmt.setInt(1, itemId);
            ResultSet rs = itemStmt.executeQuery();
            if (!rs.next()) {
                return false;
            }
            double price = rs.getDouble("price");
            int stock = rs.getInt("stock");
            String itemName = rs.getString("item_name");
            String ownerUuid = rs.getString("owner_uuid");
            if (stock <= 0 && stock != -1) {
                return false;
            }
            int ownerUserId = ImatorsShop.getInstance().getDatabaseManager().getLinkedUserId(ownerUuid);
            if (ownerUserId == -1) {
                return false;
            }
            boolean transactionSuccess = ImatorsShop.getInstance().getDatabaseManager().addTransaction(buyerUserId, ownerUserId, price, "Achat: " + itemName, buyerName, "Boutique");
            if (transactionSuccess && stock != -1) {
                PreparedStatement updateStmt = conn.prepareStatement("UPDATE shop_items SET stock = stock - 1 WHERE id = ?");
                updateStmt.setInt(1, itemId);
                updateStmt.executeUpdate();
            }
            return transactionSuccess;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void updateSign(Location location, String shopName) {
        Block block = location.getBlock();
        if (block.getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            sign.setLine(0, String.valueOf(ChatColor.DARK_BLUE) + "[SHOP]");
            sign.setLine(1, String.valueOf(ChatColor.GREEN) + shopName);
            sign.setLine(2, String.valueOf(ChatColor.YELLOW) + "Boutique");
            sign.setLine(3, String.valueOf(ChatColor.GRAY) + "Clic droit !");
            sign.update();
        }
    }
}

