<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators Product</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
            height: 100vh;
            overflow: hidden;
        }

        .main-container {
            display: grid;
            grid-template-rows: 1fr auto;
            height: 100vh;
        }

        .content-area {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .grid-background {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                radial-gradient(circle at 50% 50%, rgba(255, 255, 255, 0.15) 1px, transparent 1px);
            background-size: 30px 30px;
            opacity: 0.3;
            z-index: -1;
        }

        .highlight {
            color: #FFFFFF;
            position: relative;
            display: inline-block;
        }

        .highlight::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 8px;
            bottom: 5px;
            left: 0;
            background-color: rgba(255, 255, 255, 0.15);
            z-index: -1;
        }

        .feature-item {
            border-left: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }

        .feature-item:hover {
            border-left: 1px solid rgba(255, 255, 255, 0.3);
        }

        .product-tab {
            border-bottom: 2px solid transparent;
            transition: all 0.3s ease;
        }

        .product-tab.active {
            border-bottom: 2px solid #FFFFFF;
        }

        .product-tab:hover:not(.active) {
            border-bottom: 2px solid rgba(255, 255, 255, 0.3);
        }

        .demo-button {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }

        .demo-button:hover {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .api-box {
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        @media (max-width: 768px) {
            .main-container {
                overflow-y: auto;
            }
            
            .product-tabs {
                flex-wrap: wrap;
            }
            
            .product-tab {
                width: 50%;
                text-align: center;
            }
        }
    </style>
</head>
<body>
    <div class="grid-background"></div>
    <div class="main-container">
        <div class="content-area p-4 overflow-y-auto">
            <div class="max-w-5xl mx-auto">
                <!-- Logo and Main Text -->
                <div class="mb-10 md:mb-16">
                    <div class="flex items-center mb-8">
                        <img src="traffic_logo.png" alt="Imators Product" class="rounded-md w-12 h-12 mr-4">
                        <h1 class="text-2xl font-light">TrafficLight</h1>
                    </div>
                    <h2 class="text-4xl md:text-4xl font-light leading-tight mb-6">
                        A solution to see<br> what your city hasn't added.
                    </h2>
                    <p class="text-zinc-400 text-xl max-w-2xl">
                    With TrafficLight, you can get detailed, live traffic information, thanks to the addition of the community and a cutting-edge system.
                    </p>
                </div>
                
                <!-- Product Tabs -->
                <div class="mb-8">
                    <div class="product-tabs flex mb-8 border-b border-zinc-800">
                        <div class="product-tab active px-6 py-3 cursor-pointer" onclick="changeTab('features')">
                            <i class="fa fa-cube mr-2"></i> Features
                        </div>
                        <div class="product-tab px-6 py-3 cursor-pointer" onclick="changeTab('api')">
                            <i class="fa fa-code mr-2"></i> API
                        </div>
                    </div>
                    
                    <!-- Features Tab Content -->
                    <div id="features" class="tab-content">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-10">
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-bolt text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Faster, all the time.</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">The system operates 24/7 with no stops or interruptions.</p>
                            </div>
                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-shield-halved text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Constant update security</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">Updating and constant monitoring of traffic lights</p>
                            </div>

                            
                            <div class="feature-item pl-4">
                                <div class="flex items-center mb-3">
                                    <i class="fa fa-mobile-screen text-zinc-300 mr-3"></i>
                                    <h3 class="text-lg font-medium">Mobile Ready</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">Optimised user experience on all devices.</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- API Tab Content -->
                    <div id="api" class="tab-content hidden">
                        <div class="flex flex-col items-center justify-center py-16 text-center">
                            <i class="fa fa-code-branch text-4xl mb-4 text-zinc-400"></i>
                            <h3 class="text-2xl font-light mb-3">API Integration</h3>
                            <p class="text-zinc-400 mb-2 max-w-lg">Our complete RESTful API is currently in development.</p>
                            <div class="text-xl font-medium text-white mt-4 mb-6">Coming soon</div>
                            <div class="api-box p-4 rounded-md mb-4 max-w-lg">
                                <p class="text-sm text-zinc-400">Stay tuned for powerful integration options that will allow you to connect TrafficLight with your existing applications.</p>
                            </div>
                            <button class="mt-4 px-6 py-2 border border-zinc-700 rounded-md text-zinc-400 hover:text-white hover:border-zinc-500 transition-colors">
                                <i class="fa fa-bell mr-2"></i>
                                Get notified when available
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="flex justify-center">
                    <button class="demo-button px-8 py-4 rounded-md text-lg hover:text-white transition-colors">
                        <i class="fa fa-play-circle mr-2"></i>
                        <a href="/traffic">Go to the application</a>
                    </button>
                </div>
            </div>
        </div>
        
        <div class="w-full py-6 px-6 border-t border-zinc-800 flex flex-col md:flex-row justify-between items-center">
            <div class="text-sm text-zinc-500 mb-4 md:mb-0">
                © 2025 Imators LLC. All rights reserved.
            </div>
            <div class="flex space-x-6">
                <a href="https://imators.com/support" class="text-zinc-500 hover:text-white">
                    <i class="fa-solid fa-headset"></i>
                </a>
                <a href="https://imators.com/contact-us" class="text-zinc-500 hover:text-white">
                    <i class="fa fa-envelope"></i>
                </a>
            </div>
        </div>
    </div>

    <script>
    function changeTab(tabId) {
        // Hide all tab contents
        document.querySelectorAll('.tab-content').forEach(tab => {
            tab.classList.add('hidden');
        });
        
        // Remove active class from all tabs
        document.querySelectorAll('.product-tab').forEach(tab => {
            tab.classList.remove('active');
        });
        
        // Show selected tab content
        document.getElementById(tabId).classList.remove('hidden');
        
        // Add active class to clicked tab
        event.currentTarget.classList.add('active');
    }
    </script>
</body>
</html>