<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
    <style type="text/css">
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
        .bg-image {
            background-image: url('IMG_7530.JPG');
            background-size: cover;
            background-position: center;
            filter: brightness(0.6);
        }
        .faq-item {
            margin-bottom: 1rem;
        }
        .faq-question {
            cursor: pointer;
            padding: 1rem 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100%;
            text-align: left;
            background: transparent;
            border: none;
            border-bottom: 1px solid #333;
            color: #fff;
        }
        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease-out;
            padding: 0 1rem;
            opacity: 0;
            transform: translateY(-10px);
        }
        .faq-answer.active {
            max-height: 300px;
            opacity: 1;
            transform: translateY(0);
            transition: all 0.3s ease-in;
            padding: 1rem;
        }
        .contact-email-banner {
            background: linear-gradient(90deg, #3B82F6 0%, #2563EB 100%);
            color: white;
            padding: 0.75rem 1rem;
            text-align: center;
            font-weight: 500;
            margin-bottom: 0;
        }
        .contact-email-link {
            color: white;
            font-weight: 600;
            text-decoration: underline;
            transition: opacity 0.2s ease;
        }
        .contact-email-link:hover {
            opacity: 0.9;
        }
    </style>
</head>
<body class="flex flex-col min-h-screen bg-black text-gray-400">
    <?php include 'src/header.php'; ?>
    
    <!-- Email Banner -->


    <header class="relative h-80">
        <div class="bg-image absolute inset-0"></div>
        <div class="absolute inset-0 bg-gradient-to-b from-transparent to-black"></div>
        <div class="container mx-auto px-4 h-full flex items-end pb-12 relative z-10">
            <h1 class="text-5xl font-light text-white tracking-wide">Support</h1>
        </div>
    </header>

    <main class="flex-grow container mx-auto px-4 py-16">
        <div class="max-w-4xl mx-auto space-y-16">
            <div class="text-center space-y-6">
                <h2 class="text-3xl text-white font-light">Nous sommes là pour vous aider</h2>
                <p class="text-lg max-w-2xl mx-auto">
                Notre équipe d'assistance est disponible 24 heures sur 24 et 7 jours sur 7 pour répondre à toutes vos questions.
                Il vous suffit de nous contacter par courrier électronique pour obtenir de l'aide.
                </p>
            </div>

            <!-- FAQ Section
            <section class="space-y-8">
                <h2 class="text-3xl text-white font-light text-center">Questions fréquemment posées</h2>
                <div class="space-y-4 max-w-2xl mx-auto">
                    <div class="faq-item">
                        <button class="faq-question">
                            <span>Comment puis-je suivre ma demande d'assistance ?</span>
                            <svg class="w-5 h-5 transform transition-transform duration-200" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div class="faq-answer">
                            <p>Une fois votre demande envoyée à notre équipe, vous recevrez un courriel de confirmation avec un numéro de suivi. Utilisez-le pour suivre l'état d'avancement de votre demande.</p>
                        </div>
                    </div>

                    <div class="faq-item">
                        <button class="faq-question">
                            <span>Quel est le délai de réponse habituel ?</span>
                            <svg class="w-5 h-5 transform transition-transform duration-200" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div class="faq-answer">
                            <p>Notre équipe répond généralement à toutes les demandes dans les 24 heures, et souvent bien plus tôt. Nous donnons la priorité aux questions urgentes et nous nous efforçons de fournir l'assistance la plus rapide possible.</p>
                        </div>
                    </div>

                    <div class="faq-item">
                        <button class="faq-question">
                            <span>Quelles informations dois-je inclure dans ma demande ?</span>
                            <svg class="w-5 h-5 transform transition-transform duration-200" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div class="faq-answer">
                            <p>Pour nous aider à mieux vous assister, veuillez inclure : les détails de votre compte, une description claire de votre problème, et toute capture d'écran ou message d'erreur pertinent, le cas échéant.</p>
                        </div>
                    </div>
                </div>
            </section>  -->

		<div class="text-center space-y-4">
                <h2 class="text-3xl text-white font-light">Support pour nos clients</h2>
                <p class="text-lg">
                Les clients disposant d'un compte Imators peuvent <a href="https://idsma.imators.com" class="underline text-white">envoyer des demandes au service d'assistance par l'intermédiaire de leur espace ticket.</a>
                </p>
            </div>


            <!-- Contact Direct -->
            <div class="text-center space-y-4">
                <h2 class="text-3xl text-white font-light">Contact commercial et professionnel</h2>
                <p class="text-lg">
                Notre équipe est disponible à <a href="mailto:contact@imators.com" class="text-blue-500 hover:text-blue-400 font-medium">contact@imators.com</a>
                </p>
            </div>
        </div>
    </main>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Suivez-nous</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/itsimators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <img src="https://uxwing.com/wp-content/themes/uxwing/download/brands-and-social-media/instagram-white-icon.png" alt="Instagram" class="w-6 h-6 mr-2">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Découvrir</h5>
                <a href="/fr/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                Politique de confidentialité
                </a>
                <a href="/fr/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                Conditions d'utilisation
                </a>
                <a href="/fr/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                Accueil
                </a>
                <a href="/fr/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                À propos de nous
                </a>
                <a href="/fr/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                Nous contacter
                </a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Réalité possible</h5>
                <p class="text-sm">
                Toutes les images, les vidéos et le contenu de ce site sont la propriété d'Imators.
                </p>
            </div>
        </div>
    
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">
                &copy; 2024 Imators. Tous droits réservés.
            </p>
            <p class="text-xs">
            Imators est une société à responsabilité limitée (LLC). Tous nos produits, qu'ils soient technologiquement physiques ou simplement en ligne, sont soumis à nos règles, auxquelles vous pouvez accéder.
            </p>
        </div>
    </footer>

    <script>
        // FAQ functionality
        document.querySelectorAll('.faq-question').forEach(question => {
            question.addEventListener('click', () => {
                const answer = question.nextElementSibling;
                const arrow = question.querySelector('svg');
                const isActive = answer.classList.contains('active');

                // Close all answers
                document.querySelectorAll('.faq-answer').forEach(a => {
                    a.classList.remove('active');
                });
                document.querySelectorAll('.faq-question svg').forEach(svg => {
                    svg.style.transform = 'rotate(0deg)';
                });

                // Toggle clicked answer
                if (!isActive) {
                    answer.classList.add('active');
                    arrow.style.transform = 'rotate(180deg)';
                }
            });
        });
    </script>
</body>
</html>