<?php
$transparent_header = true;

require_once 'db.php';

$sql = "SELECT id, title, content, image_url, DATE_FORMAT(date_created, '%d/%m/%Y') AS formatted_date, 
               author FROM news_blog ORDER BY date_created DESC LIMIT 6";
$stmt = $conn->prepare($sql);
$stmt->execute();
$news = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="imators-verification" content="verified">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script defer src="https://cloud.umami.is/script.js" data-website-id="b467e8c1-b13e-4744-80ac-d625ad1403b4"></script>
    
    
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-MNDDTWSM');</script>
    <title>Imators</title>
    <meta name="description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">

    <meta property="og:url" content="https://imators.com">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Imators">
    <meta property="og:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:domain" content="imators.com">
    <meta name="twitter:url" content="https://imators.com">
    <meta name="twitter:title" content="Imators">
    <meta name="twitter:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&family=Space+Grotesk:wght@300;400;500;600;700&family=Fredoka:wght@300..700&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <style>
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000;
            overflow-x: hidden;
        }
        
        .section {
            position: relative;
            width: 100%;
            min-height: 85vh;
            overflow: hidden;
        }

        .mini-section {
            position: relative;
            width: 100%;
            min-height: 60vh;
            overflow: hidden;
        }
        
        .section-divider {
            height: 1px;
            width: 100%;
            background: rgba(255, 255, 255, 0.1);
        }
        
        .fredoka {
            font-family: "Fredoka", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
            font-variation-settings: "wdth" 100;
        }

        .Montserrat {
            font-family: "Montserrat", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
        }
		        
        .gemance {
            font-family: "Princess Sofia", cursive;
            font-weight: 400;
            font-style: normal;
        }

        .header {
            z-index: 1000;
        }

        .zajidhiadj {
            z-index: 1001;
            position: relative;
        }
        
        .grid-bg {
            background: linear-gradient(90deg,rgba(255,255,255,.1) 1px,transparent 0), 
                        linear-gradient(rgba(255,255,255,.1) 1px,transparent 0);
            background-size: 40px 40px;
        }
        
        .premium-section {
            position: relative;
            width: 100%;
            min-height: 60vh;
            background-color: #fff;
            overflow: hidden;
        }
        
        .transparent-button {
            opacity: 0;
            transition: opacity 0.5s ease;
        }
        
        .transparent-button.visible {
            opacity: 1;
        }
        
        .premium-grid {
            background: linear-gradient(90deg,rgba(0,0,0,.03) 1px,transparent 0), 
                      linear-gradient(rgba(0,0,0,.03) 1px,transparent 0);
            background-size: 30px 30px;
        }

        .hero-stacked-section {
            position: relative;
            height: 100vh;
            width: 100%;
            display: flex;
            flex-direction: column;
            justify-content: center;
            overflow: hidden;
        }

        .title-container {
            max-width: 1024px;
            margin-left: 8%;
            margin-right: 8%;
            padding-top: 120px;
            z-index: 10;
        }
        
        .title-line {
            display: block;
            overflow: hidden;
            margin-bottom: 10px;
            width: 100%;
        }
        
        .title-word {
            display: inline-block;
            margin-right: 10px;
            font-size: 5rem;
            font-weight: bold;
            line-height: 1.1;
            opacity: 0;
            transform: translateY(50px);
            color: #ffffff;
        }

        .modern-cookie-box {
            position: fixed;
            bottom: 2rem;
            left: 2rem;
            right: 2rem;
            max-width: 400px;
            margin: 0 auto;
            background: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 24px;
            padding: 2rem;
            color: white;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
            z-index: 1000;
            opacity: 0;
            transform: translateY(100px) scale(0.9);
            transition: all 0.6s cubic-bezier(0.34, 1.56, 0.64, 1);
        }

        .modern-cookie-box.show {
            opacity: 1;
            transform: translateY(0) scale(1);
        }

        .cookie-icon {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1rem;
            font-size: 1.5rem;
        }

        .cookie-button {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 0.75rem 1.5rem;
            border-radius: 12px;
            color: white;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            width: 100%;
            margin-top: 1rem;
        }

        .cookie-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
        }

        @media (max-width: 1200px) {
            .title-word {
                font-size: 4.5rem;
            }
        }
        
        @media (max-width: 768px) {
            .title-container {
                margin-left: 5%;
                margin-right: 5%;
                padding-top: 80px;
            }
            
            .title-word {
                font-size: 3.8rem;
            }

            .modern-cookie-box {
                left: 1rem;
                right: 1rem;
                padding: 1.5rem;
            }
        }
        
        @media (max-width: 480px) {
            .title-word {
                font-size: 3.5rem;
                margin-right: 6px;
            }
            
            .title-line {
                margin-bottom: 12px;
            }
            
            .title-container {
                margin-left: 4%;
                margin-right: 4%;
                padding-top: 60px;
                width: 92%;
            }
            
            .long-word {
                display: block;
                margin-bottom: 5px;
            }
        }
    </style>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(function() {
                document.getElementById('redirect-button').classList.add('visible');
            }, 5000);
        });
    </script>
</head>
<body class="bg-black">
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MNDDTWSM"
    height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    
    <?php include 'src/header.php'; ?>
    

    <style>
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .fade-in-image {
            animation: fadeInUp 1s ease-out;
        }
        
        .fade-in-title {
            animation: fadeInUp 1s ease-out 0.3s both;
        }
        
        .fade-in-description {
            animation: fadeInUp 1s ease-out 0.6s both;
        }
        
        .fade-in-date {
            animation: fadeInUp 1s ease-out 0.9s both;
        }
        
        .fade-in-button {
            animation: fadeInUp 1s ease-out 1.2s both;
        }
    </style>

<section class="relative w-full h-screen overflow-hidden flex items-center">
  <img src="IMG_8743.jpg" alt="Fond" class="absolute inset-0 w-full h-full object-cover filter brightness-75">
  
  <div class="relative z-10 w-full h-full flex flex-col justify-between px-6 py-12 md:px-16">
    
    <div class="mt-20 self-start md:self-center md:text-right md:ml-auto">
      <ul class="flex flex-col gap-4 text-white">
        <li><a href="#" class="text-sm md:text-base hover:underline transition-all">For everyday</a></li>
        <li><a href="#" class="text-sm md:text-base hover:underline transition-all">For the business</a></li>
        <li><a href="#" class="text-sm md:text-base hover:underline transition-all">For the professionnel</a></li>
      </ul>
    </div>
    
    <div class="mb-12 self-start text-white max-w-sm">
      <div class="w-12 h-px bg-white mb-6"></div>
      <h1 class="text-3xl md:text-5xl font-extralight mb-5">Every moment,<br> marked by you.</h1>
      <p class="text-sm md:text-base font-light mb-8">Our online and physical product collection is designed so that every detail of your daily life reaches the perfection you deserve</p>
      <a href="/about-us" class="rounded-full inline-block px-6 py-2 border border-white hover:bg-white hover:text-black transition-all">About the enterprise</a>
    </div>
    
  </div>
  
</section>

<div class="stacked-container">

  <section class="hero-stacked-section" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
    <div class="title-container">
      <h1>
        <span class="title-line">
          <span class="title-word">Discover</span>
          <span class="title-word">our</span>
        </span>
        <span class="title-line">
          <span class="title-word">premium</span>
        </span>
        <span class="title-line">
          <span class="title-word">collection</span>
        </span>
      </h1>
    </div>
  </section>

  <section class="hero-stacked-section" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
    <div class="title-container">
      <h1>
        <span class="title-line">
          <span class="title-word">Technology</span>
        </span>
        <span class="title-line">
          <span class="title-word">that</span>
          <span class="title-word">adapts</span>
        </span>
        <span class="title-line">
          <span class="title-word">to</span>
          <span class="title-word">you</span>
        </span>
      </h1>
    </div>
  </section>

  <section class="hero-stacked-section" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
    <div class="title-container">
      <h1>
        <span class="title-line">
          <span class="title-word">Innovation</span>
        </span>
        <span class="title-line">
          <span class="title-word">without</span>
        </span>
        <span class="title-line">
          <span class="title-word">compromise</span>
        </span>
      </h1>
    </div>
  </section>

  <section class="hero-stacked-section" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
    <div class="title-container">
      <h1>
        <span class="title-line">
          <span class="title-word">Your</span>
          <span class="title-word">digital</span>
        </span>
        <span class="title-line">
          <span class="title-word">future</span>
        </span>
        <span class="title-line">
          <span class="title-word">starts</span>
          <span class="title-word">here</span>
        </span>
      </h1>
    </div>
  </section>

  <section class="hero-stacked-section" style="background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);">
    <div class="title-container">
      <h1>
        <span class="title-line">
          <span class="title-word">Welcome</span>
          <span class="title-word">to</span>
        </span>
        <span class="title-line">
          <span class="title-word">tomorrow</span>
        </span>
      </h1>
    </div>
  </section>

</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const lights = document.getElementById('lights');
    const logoContainer = document.getElementById('logo-container');
    const title = document.getElementById('title');
    const description = document.getElementById('description');
    const buttonsContainer = document.getElementById('buttons-container');
    
    setTimeout(() => {
        if(lights) {
            lights.style.opacity = '1';
            lights.style.transition = 'opacity 1.5s ease';
        }
    }, 800);
    
    const animateElement = (element, delay) => {
        if(element) {
            setTimeout(() => {
                element.style.opacity = '1';
                element.style.transform = 'translateY(0)';
                element.style.transition = 'opacity 0.8s ease, transform 0.8s ease';
            }, delay);
        }
    };
    
    animateElement(logoContainer, 1000);
    animateElement(title, 1500);
    animateElement(description, 2000);
    animateElement(buttonsContainer, 2500);
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    gsap.registerPlugin(ScrollTrigger);
    
    const sections = document.querySelectorAll('.hero-stacked-section');
    
    sections.forEach((section, i) => {
        const isLast = i === sections.length - 1;
        
        if (!isLast) {
            gsap.set(section, { zIndex: sections.length - i });
        }
        
        const st = ScrollTrigger.create({
            trigger: section,
            start: "top top",
            end: "+=100%",
            pin: !isLast,
            pinSpacing: false,
            snap: {
                snapTo: "labels",
                duration: 0.8,
                delay: 0.1,
                ease: "power2.inOut"
            },
            onEnter: () => {
                const titleWords = section.querySelectorAll('.title-word');
                titleWords.forEach((word, index) => {
                    gsap.fromTo(word, 
                        { 
                            opacity: 0,
                            y: 50 
                        },
                        {
                            opacity: 1,
                            y: 0,
                            duration: 0.6,
                            delay: index * 0.1,
                            ease: "power2.out"
                        }
                    );
                });
            }
        });
        
        if (!isLast) {
            gsap.to(section, {
                y: -100,
                scale: 0.95,
                scrollTrigger: {
                    trigger: section,
                    start: "top top",
                    end: "bottom top",
                    scrub: 1,
                    ease: "none"
                }
            });
        }
    });
});
</script>

<footer><div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Need Help?</h5>
        <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
        <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Refund Policy
        </a>
        <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Legal Notice
        </a>
        <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-3 border-t border-gray-800">
    <p class="text-sm">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs mt-2">
        <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
    </p>
    <p class="text-xs">
        Imators is a registered LLC. All our products are subject to our terms.
    </p>
</div></footer>

<div class="modern-cookie-box" id="cookieBox">
    <div class="cookie-icon">
        🍪
    </div>
    <h3 class="text-lg font-semibold mb-2">Nous utilisons des cookies</h3>
    <p class="text-sm text-gray-300 leading-relaxed mb-1">
        Notre site utilise uniquement les cookies essentiels nécessaires au bon fonctionnement du site. Aucune information n'est transmise à des tiers.
    </p>
    <p class="text-xs text-gray-400 mb-4">
        Pour en savoir plus sur les informations essentielles collectées, 
        <a href="./terms-of-use" class="text-blue-400 hover:text-blue-300 underline">consultez nos conditions d'utilisation</a>.
    </p>
    <button class="cookie-button" onclick="acceptCookies()">
        Accepter et continuer
    </button>
</div>

<script>
  function acceptCookies() {
    const cookieBox = document.getElementById('cookieBox');
    cookieBox.style.transform = 'translateY(100px) scale(0.9)';
    cookieBox.style.opacity = '0';
    
    setTimeout(() => {
      cookieBox.style.display = 'none';
      localStorage.setItem('cookiesAccepted', 'true');
    }, 600);
  }

  window.onload = function() {
    const cookieBox = document.getElementById('cookieBox');
    
    if (localStorage.getItem('cookiesAccepted') === 'true') {
      cookieBox.style.display = 'none';
    } else {
      setTimeout(() => {
        cookieBox.classList.add('show');
      }, 2000);
    }
  }
</script>
</body>
</html>