<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Header - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #FFFFFF;
            background-color: #000000;
        }

        .header {
            background-color: rgba(0, 0, 0, 0.95);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1002;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: fixed;
            width: 100%;
            top: 0;
            height: 70px;
        }

        @media (min-width: 1024px) {
            .header {
                height: 90px;
            }
        }

        .header-transparent {
            background-color: transparent;
            border-bottom: none;
        }

        .header-transparent.scrolled {
            background-color: rgba(0, 0, 0, 0.95);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .desktop-menu {
            display: none;
        }

        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
            }

            .desktop-menu-item {
                position: relative;
                padding: 1rem;
                cursor: pointer;
                color: #FFFFFF;
                font-weight: 350;
                transition: all 0.3s ease;
                border-radius: 12px;
            }

            .desktop-menu-item:hover {
                color: rgba(255, 255, 255, 0.7);
                background: rgba(255, 255, 255, 0.1);
            }
        }

        .desktop-submenu {
            position: absolute;
            top: calc(100% + 10px);
            left: 50%;
            transform: translateX(-50%) translateY(10px);
            background-color: #000000;
            min-width: 280px;
            border-radius: 16px;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.1);
            padding: 16px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.5);
            z-index: 1000;
        }

        .desktop-menu-item:hover .desktop-submenu {
            opacity: 1;
            visibility: visible;
            transform: translateX(-50%) translateY(0);
        }

        .submenu-link {
            display: flex;
            align-items: center;
            padding: 12px;
            transition: all 0.2s ease;
            border-radius: 10px;
            margin-bottom: 6px;
        }

        .submenu-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        .submenu-icon {
            width: 36px;
            height: 36px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            margin-right: 12px;
            background-color: rgba(255, 255, 255, 0.08);
        }

        .submenu-text {
            flex: 1;
        }

        .submenu-title {
            font-weight: 500;
            margin-bottom: 2px;
        }

        .submenu-desc {
            font-size: 0.75rem;
            opacity: 0.7;
        }

        .submenu-stories {
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            margin-top: 10px;
            padding-top: 16px;
        }

        .stories-title {
            font-size: 0.9rem;
            font-weight: 600;
            margin-bottom: 12px;
        }

        .stories-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
        }

        .story-item {
            aspect-ratio: 1/1;
            border-radius: 10px;
            overflow: hidden;
            position: relative;
            background-size: cover;
            background-position: center;
            transition: all 0.3s ease;
        }

        .story-item:hover {
            transform: scale(1.05);
        }

        .story-content {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 12px 10px;
            background: linear-gradient(transparent, rgba(0, 0, 0, 0.8));
        }

        .story-title {
            font-size: 0.85rem;
            font-weight: 600;
            margin-bottom: 2px;
        }

        .story-desc {
            font-size: 0.7rem;
            opacity: 0.8;
        }

        .mobile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            z-index: 1000;
        }

        .mobile-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000000;
            transform: translateY(-100%);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1001;
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
        }

        .mobile-menu.active {
            transform: translateY(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .mobile-title {
            font-size: 1.2rem;
            font-weight: 600;
        }

        .mobile-nav {
            padding: 20px;
        }

        .mobile-section {
            margin-bottom: 30px;
        }

        .section-title {
            font-size: 0.85rem;
            text-transform: uppercase;
            opacity: 0.6;
            margin-bottom: 15px;
            font-weight: 500;
            letter-spacing: 0.5px;
        }

        .mobile-links {
            display: grid;
            grid-template-columns: repeat(1, 1fr);
            gap: 12px;
        }

        .mobile-link {
            display: flex;
            align-items: center;
            padding: 16px;
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.08);
            border-radius: 14px;
            transition: all 0.2s ease;
        }

        .mobile-link:active {
            background: rgba(255, 255, 255, 0.08);
            transform: scale(0.98);
        }

        .mobile-icon {
            width: 42px;
            height: 42px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 10px;
            margin-right: 14px;
        }

        .mobile-content {
            flex: 1;
        }

        .mobile-name {
            font-weight: 500;
            margin-bottom: 4px;
        }

        .mobile-description {
            font-size: 0.8rem;
            opacity: 0.7;
        }

        .stories-slider {
            display: flex;
            gap: 15px;
            padding: 15px 20px;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
            scrollbar-width: none; 
        }

        .stories-slider::-webkit-scrollbar {
            display: none;
        }

        .story-card {
            flex: 0 0 auto;
            width: 110px;
            border-radius: 14px;
            overflow: hidden;
            position: relative;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }

        .story-card-inner {
            position: relative;
            width: 100%;
            aspect-ratio: 9/16;
            background-size: cover;
            background-position: center;
        }

        .story-card-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 10px;
            background: linear-gradient(transparent, rgba(0, 0, 0, 0.7));
        }

        .story-card-title {
            font-size: 0.9rem;
            font-weight: 600;
            margin-bottom: 2px;
        }

        .story-indicator {
            display: flex;
            gap: 2px;
            margin-top: 5px;
        }

        .indicator-dot {
            width: 14px;
            height: 3px;
            background: rgba(255, 255, 255, 0.5);
            border-radius: 2px;
        }

        .indicator-dot.active {
            background: #ffffff;
        }

        .hamburger {
            width: 40px;
            height: 40px;
            position: relative;
            cursor: pointer;
            z-index: 1003;
            display: none;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        @media (max-width: 1023px) {
            .hamburger {
                display: flex;
            }
        }

        .hamburger span {
            display: block;
            position: absolute;
            height: 2px;
            width: 20px;
            background: #FFFFFF;
            border-radius: 2px;
            opacity: 1;
            left: 10px;
            transition: transform 0.3s ease-in-out;
        }

        .hamburger span:nth-child(1) {
            top: 14px;
            transform-origin: center;
        }

        .hamburger span:nth-child(2) {
            top: 24px;
            transform-origin: center;
        }

        .hamburger.active span:nth-child(1) {
            transform: translateY(5px) rotate(45deg);
        }

        .hamburger.active span:nth-child(2) {
            transform: translateY(-5px) rotate(-45deg);
        }

        .imators-account-btn {
            display: inline-flex;
            align-items: center;
            padding: 0.5rem 1rem;
            font-weight: 500;
            color: #000000;
            background-color: #FFFFFF;
            border-radius: 12px;
            transition: all 0.2s ease;
        }

        .imators-account-btn:hover {
            opacity: 0.9;
        }

        .header-content {
            height: 100%;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo-container {
            display: flex;
            align-items: center;
        }

        .logo-container img {
            height: 28px;
            transition: all 0.3s ease;
        }

        @media (min-width: 1024px) {
            .logo-container img {
                height: 36px;
            }
        }
    </style>
</head>
<body class="h-full">
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 header-content">
            <div class="logo-container">
                <a href="/" class="flex items-center">
                    <img src="https://cdn.imators.com/logo.png" alt="Logo Imators">
                </a>
            </div>

            <div class="desktop-menu items-center space-x-6">
                <div class="desktop-menu-item font-light">
                    Products
                    <div class="desktop-submenu">
                        <a href="https://academ.my" class="submenu-link">
                            <div class="submenu-icon" style="color: #8B5CF6;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" />
                                </svg>
                            </div>
                            <div class="submenu-text">
                                <div class="submenu-title">Academ</div>
                                <div class="submenu-desc">Say goodbye to homework overflow</div>
                            </div>
                        </a>
                        <a href="/progm" class="submenu-link">
                            <div class="submenu-icon" style="color: #F59E0B;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                                </svg>
                            </div>
                            <div class="submenu-text">
                                <div class="submenu-title">Progm</div>
                                <div class="submenu-desc">Program management simplified</div>
                            </div>
                        </a>
                        <a href="https://ohmypanel.com" class="submenu-link">
                            <div class="submenu-icon" style="color: #10B981;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                                </svg>
                            </div>
                            <div class="submenu-text">
                                <div class="submenu-title">OhMyPanel</div>
                                <div class="submenu-desc">Quick & easy shopping</div>
                            </div>
                        </a>
                        <a href="https://owtfitt.com" class="submenu-link">
                            <div class="submenu-icon" style="color: #EF4444;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                </svg>
                            </div>
                            <div class="submenu-text">
                                <div class="submenu-title">Owtfitt</div>
                                <div class="submenu-desc">Premium fashion outfits</div>
                            </div>
                        </a>
                        <a href="https://imators.systems/traffic" class="submenu-link">
                            <div class="submenu-icon" style="color: #3B82F6;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4" />
                                </svg>
                            </div>
                            <div class="submenu-text">
                                <div class="submenu-title">TrafficLight</div>
                                <div class="submenu-desc">Intelligent traffic management</div>
                            </div>
                        </a>
                        
                        <div class="submenu-stories">
                            <h4 class="stories-title">Stories</h4>
                            <div class="stories-grid">
                                <div class="story-item" style="background-image: url('https://cdn.imators.com/story1.jpg')">
                                    <div class="story-content">
                                        <h5 class="story-title">Academ Success</h5>
                                        <p class="story-desc">See how Academ transforms education</p>
                                    </div>
                                </div>
                                <div class="story-item" style="background-image: url('https://cdn.imators.com/story2.jpg')">
                                    <div class="story-content">
                                        <h5 class="story-title">TrafficLight</h5>
                                        <p class="story-desc">Smart traffic solutions</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    Developer Tools
                    <div class="desktop-submenu">
                        <a href="https://imators.systems" class="submenu-link">
                            <div class="submenu-icon" style="color: #7C3AED;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4" />
                                </svg>
                            </div>
                            <div class="submenu-text">
                                <div class="submenu-title">Imators Systems</div>
                                <div class="submenu-desc">Enterprise-grade systems</div>
                            </div>
                        </a>
                        <a href="https://developer.imators.com" class="submenu-link">
                            <div class="submenu-icon" style="color: #2563EB;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                </svg>
                            </div>
                            <div class="submenu-text">
                                <div class="submenu-title">Imators Developer</div>
                                <div class="submenu-desc">Developer resources & APIs</div>
                            </div>
                        </a>
                        <a href="https://imators.systems/traffic" class="submenu-link">
                            <div class="submenu-icon" style="color: #3B82F6;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4" />
                                </svg>
                            </div>
                            <div class="submenu-text">
                                <div class="submenu-title">TrafficLight</div>
                                <div class="submenu-desc">Traffic management API</div>
                            </div>
                        </a>
                        
                        <div class="submenu-stories">
                            <h4 class="stories-title">Stories</h4>
                            <div class="stories-grid">
                                <div class="story-item" style="background-image: url('https://cdn.imators.com/dev1.jpg')">
                                    <div class="story-content">
                                        <h5 class="story-title">Developer Journey</h5>
                                        <p class="story-desc">Building with Imators tools</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    Company
                    <div class="desktop-submenu">
                        <a href="/support" class="submenu-link">
                            <div class="submenu-icon" style="color: #10B981;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                                </svg>
                            </div>
                            <div class="submenu-text">
                                <div class="submenu-title">Support</div>
                                <div class="submenu-desc">Get help with our products</div>
                            </div>
                        </a>
                        <a href="/contact-us" class="submenu-link">
                            <div class="submenu-icon" style="color: #EF4444;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                            </div>
                            <div class="submenu-text">
                                <div class="submenu-title">Contact us</div>
                                <div class="submenu-desc">Reach out to our team</div>
                            </div>
                        </a>
                        <a href="/about-us" class="submenu-link">
                            <div class="submenu-icon" style="color: #F59E0B;">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                </svg>
                            </div>
                            <div class="submenu-text">
                                <div class="submenu-title">About Imators</div>
                                <div class="submenu-desc">Our mission and vision</div>
                            </div>
                        </a>
                        
                        <div class="submenu-stories">
                            <h4 class="stories-title">Stories</h4>
                            <div class="stories-grid">
                                <div class="story-item" style="background-image: url('https://cdn.imators.com/company1.jpg')">
                                    <div class="story-content">
                                        <h5 class="story-title">Our Journey</h5>
                                        <p class="story-desc">The story of Imators</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="imators-account-btn lg:flex hidden">
                    Imators Account
                </a>
                <button id="hamburger" class="hamburger">
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>
    </header>
    
    <div class="mobile-overlay"></div>

    <div class="mobile-menu">
        <div class="mobile-header">
            <div class="mobile-title">Explore Imators</div>
        </div>

        <div class="stories-slider">
            <div class="story-card">
                <div class="story-card-inner" style="background-color: #8B5CF6;">
                    <div class="story-card-overlay">
                        <div class="story-card-title">Academ</div>
                        <div class="story-indicator">
                            <div class="indicator-dot active"></div>
                            <div class="indicator-dot"></div>
                            <div class="indicator-dot"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="story-card">
                <div class="story-card-inner" style="background-color: #10B981;">
                    <div class="story-card-overlay">
                        <div class="story-card-title">OhMyPanel</div>
                        <div class="story-indicator">
                            <div class="indicator-dot active"></div>
                            <div class="indicator-dot"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="story-card">
                <div class="story-card-inner" style="background-color: #3B82F6;">
                    <div class="story-card-overlay">
                        <div class="story-card-title">TrafficLight</div>
                        <div class="story-indicator">
                            <div class="indicator-dot active"></div>
                            <div class="indicator-dot"></div>
                            <div class="indicator-dot"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="story-card">
                <div class="story-card-inner" style="background-color: #EF4444;">
                    <div class="story-card-overlay">
                        <div class="story-card-title">Owtfitt</div>
                        <div class="story-indicator">
                            <div class="indicator-dot active"></div>
                            <div class="indicator-dot"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="story-card">
                <div class="story-card-inner" style="background-color: #F59E0B;">
                    <div class="story-card-overlay">
                        <div class="story-card-title">Progm</div>
                        <div class="story-indicator">
                            <div class="indicator-dot active"></div>
                            <div class="indicator-dot"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
  
        <div class="mobile-nav">
            <div class="mobile-section">
                <h3 class="section-title">Products</h3>
                <div class="mobile-links">
                    <a href="https://academ.my" class="mobile-link">
                        <div class="mobile-icon" style="background-color: rgba(139, 92, 246, 0.15); color: #8B5CF6;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" />
                            </svg>
                        </div>
                        <div class="mobile-content">
                            <div class="mobile-name">Academ</div>
                            <div class="mobile-description">Say goodbye to homework overflow</div>
                        </div>
                    </a>
                    <a href="/progm" class="mobile-link">
                        <div class="mobile-icon" style="background-color: rgba(245, 158, 11, 0.15); color: #F59E0B;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                            </svg>
                        </div>
                        <div class="mobile-content">
                            <div class="mobile-name">Progm</div>
                            <div class="mobile-description">Program management simplified</div>
                        </div>
                    </a>
                    <a href="https://ohmypanel.com" class="mobile-link">
                        <div class="mobile-icon" style="background-color: rgba(16, 185, 129, 0.15); color: #10B981;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                            </svg>
                        </div>
                        <div class="mobile-content">
                            <div class="mobile-name">OhMyPanel</div>
                            <div class="mobile-description">Quick & easy shopping</div>
                        </div>
                    </a>
                    <a href="https://owtfitt.com" class="mobile-link">
                        <div class="mobile-icon" style="background-color: rgba(239, 68, 68, 0.15); color: #EF4444;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                            </svg>
                        </div>
                        <div class="mobile-content">
                            <div class="mobile-name">Owtfitt</div>
                            <div class="mobile-description">Premium fashion outfits</div>
                        </div>
                    </a>
                    <a href="https://imators.systems/traffic" class="mobile-link">
                        <div class="mobile-icon" style="background-color: rgba(59, 130, 246, 0.15); color: #3B82F6;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4" />
                            </svg>
                        </div>
                        <div class="mobile-content">
                            <div class="mobile-name">TrafficLight</div>
                            <div class="mobile-description">Intelligent traffic management</div>
                        </div>
                    </a>
                </div>
            </div>
            
            <div class="mobile-section">
                <h3 class="section-title">Developer Tools</h3>
                <div class="mobile-links">
                    <a href="https://imators.systems" class="mobile-link">
                        <div class="mobile-icon" style="background-color: rgba(124, 58, 237, 0.15); color: #7C3AED;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4" />
                            </svg>
                        </div>
                        <div class="mobile-content">
                            <div class="mobile-name">Imators Systems</div>
                            <div class="mobile-description">Enterprise-grade systems</div>
                        </div>
                    </a>
                    <a href="https://developer.imators.com" class="mobile-link">
                        <div class="mobile-icon" style="background-color: rgba(37, 99, 235, 0.15); color: #2563EB;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                        </div>
                        <div class="mobile-content">
                            <div class="mobile-name">Imators Developer</div>
                            <div class="mobile-description">Developer resources & APIs</div>
                        </div>
                    </a>
                    <a href="https://imators.systems/traffic" class="mobile-link">
                        <div class="mobile-icon" style="background-color: rgba(59, 130, 246, 0.15); color: #3B82F6;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4" />
                            </svg>
                        </div>
                        <div class="mobile-content">
                            <div class="mobile-name">TrafficLight API</div>
                            <div class="mobile-description">Traffic management API</div>
                        </div>
                    </a>
                </div>
            </div>
            
            <div class="mobile-section">
                <h3 class="section-title">Company</h3>
                <div class="mobile-links">
                    <a href="/support" class="mobile-link">
                        <div class="mobile-icon" style="background-color: rgba(16, 185, 129, 0.15); color: #10B981;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                            </svg>
                        </div>
                        <div class="mobile-content">
                            <div class="mobile-name">Support</div>
                            <div class="mobile-description">Get help with our products</div>
                        </div>
                    </a>
                    <a href="/contact-us" class="mobile-link">
                        <div class="mobile-icon" style="background-color: rgba(239, 68, 68, 0.15); color: #EF4444;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                            </svg>
                        </div>
                        <div class="mobile-content">
                            <div class="mobile-name">Contact us</div>
                            <div class="mobile-description">Reach out to our team</div>
                        </div>
                    </a>
                    <a href="/about-us" class="mobile-link">
                        <div class="mobile-icon" style="background-color: rgba(245, 158, 11, 0.15); color: #F59E0B;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                            </svg>
                        </div>
                        <div class="mobile-content">
                            <div class="mobile-name">About Imators</div>
                            <div class="mobile-description">Our mission and vision</div>
                        </div>
                    </a>
                </div>
            </div>
            
            <div class="mobile-section">
                <a href="https://idsma.imators.com" class="mobile-link">
                    <div class="mobile-icon" style="background-color: rgba(139, 92, 246, 0.15); color: #8B5CF6;">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                        </svg>
                    </div>
                    <div class="mobile-content">
                        <div class="mobile-name">Imators Account</div>
                        <div class="mobile-description">Manage your account and access benefits</div>
                    </div>
                </a>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.getElementById('hamburger');
            const mobileMenu = document.querySelector('.mobile-menu');
            const mobileOverlay = document.querySelector('.mobile-overlay');
            const header = document.querySelector('.header');
            const storyCards = document.querySelectorAll('.story-card');
            const storyItems = document.querySelectorAll('.story-item');
            
            let lastScrollTop = 0;
            let scrollTimeout;

            function openMenu() {
                document.body.style.overflow = 'hidden';
                mobileOverlay.classList.add('active');
                mobileMenu.classList.add('active');
                hamburger.classList.add('active');
            }

            function closeMenu() {
                document.body.style.overflow = '';
                mobileOverlay.classList.remove('active');
                mobileMenu.classList.remove('active');
                hamburger.classList.remove('active');
            }

            hamburger.addEventListener('click', () => {
                mobileMenu.classList.contains('active') ? closeMenu() : openMenu();
            });

            mobileOverlay.addEventListener('click', closeMenu);

            window.addEventListener('scroll', () => {
                clearTimeout(scrollTimeout);
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                if (header.classList.contains('header-transparent')) {
                    if (scrollTop > 0) {
                        header.classList.add('scrolled');
                    } else {
                        header.classList.remove('scrolled');
                    }
                }

                if (!mobileMenu.classList.contains('active') && Math.abs(scrollTop - lastScrollTop) > 50) {
                    header.style.transform = scrollTop > lastScrollTop && scrollTop > header.offsetHeight ? 
                        'translateY(-100%)' : 'translateY(0)';
                    lastScrollTop = scrollTop;
                }

                scrollTimeout = setTimeout(() => {
                    header.style.transform = 'translateY(0)';
                }, 1000);
            });

            let touchStartY = 0;
            mobileMenu.addEventListener('touchstart', (e) => {
                touchStartY = e.touches[0].clientY;
            }, { passive: true });

            mobileMenu.addEventListener('touchmove', (e) => {
                const touchEndY = e.touches[0].clientY;
                const deltaY = touchEndY - touchStartY;

                if (deltaY > 70) {
                    closeMenu();
                    touchStartY = 0;
                }
            }, { passive: true });

            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape') {
                    if (mobileMenu.classList.contains('active')) {
                        closeMenu();
                    }
                }
            });

            storyCards.forEach(card => {
                card.addEventListener('click', () => {
                    // Here you could add story viewing functionality
                    // For now, we'll just redirect to a product
                    const title = card.querySelector('.story-card-title').textContent.trim();
                    switch(title) {
                        case 'Academ':
                            window.location.href = 'https://academ.my';
                            break;
                        case 'OhMyPanel':
                            window.location.href = 'https://ohmypanel.com';
                            break;
                        case 'TrafficLight':
                            window.location.href = 'https://imators.systems/traffic';
                            break;
                        case 'Owtfitt':
                            window.location.href = 'https://owtfitt.com';
                            break;
                        case 'Progm':
                            window.location.href = '/progm';
                            break;
                        default:
                            break;
                    }
                });
            });

            storyItems.forEach(item => {
                item.addEventListener('click', () => {
                    // Story viewing functionality for desktop
                    window.location.href = '#story-detail';
                });
            });
        });
    </script>
</body>
</html>