<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Header - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #FFFFFF;
            background-color: #000000;
            margin: 0;
            padding: 0;
        }

        .header {
            background-color: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1002;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: fixed;
            width: 100%;
            top: 0;
            height: 70px;
        }

        @media (min-width: 1024px) {
            .header {
                height: 90px;
            }
        }

        .header-transparent {
            background-color: transparent;
            backdrop-filter: none;
            border-bottom: none;
        }

        .header-transparent.scrolled {
            background-color: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .header-content {
            height: 100%;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo-container {
            display: flex;
            align-items: center;
        }

        .logo-container img {
            height: 28px;
            transition: all 0.3s ease;
        }

        @media (min-width: 1024px) {
            .logo-container img {
                height: 36px;
            }
        }

        /* Desktop Navigation */
        .desktop-menu {
            display: none;
        }

        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
            }

            .desktop-menu-item {
                position: relative;
                padding: 1rem;
                cursor: pointer;
                color: #FFFFFF;
                font-weight: 350;
                transition: all 0.3s ease;
                border-radius: 12px;
            }

            .desktop-menu-item:hover {
                color: rgba(255, 255, 255, 0.7);
                background: rgba(255, 255, 255, 0.1);
            }
        }

        /* Desktop Overlay Menu */
        .desktop-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background: rgba(0, 0, 0, 0.7);
            backdrop-filter: blur(15px);
            z-index: 2000;
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s ease;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .desktop-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .overlay-container {
            max-width: 1200px;
            width: 90%;
            background: rgba(15, 15, 15, 0.9);
            border-radius: 24px;
            overflow: hidden;
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.3);
            border: 1px solid rgba(255, 255, 255, 0.1);
            display: flex;
            flex-direction: column;
            max-height: 85vh;
        }

        .overlay-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px 30px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .overlay-title {
            font-size: 1.5rem;
            font-weight: 600;
        }

        .overlay-close {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: background 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .overlay-close:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .overlay-content {
            display: flex;
            padding: 30px;
            overflow-y: auto;
            flex: 1;
        }

        .overlay-links {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 15px;
            flex: 1;
        }

        .overlay-link {
            padding: 16px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 16px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            display: flex;
            flex-direction: column;
            transition: all 0.3s ease;
        }

        .overlay-link:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: translateY(-3px);
            border-color: rgba(255, 255, 255, 0.2);
        }

        .overlay-link-title {
            font-weight: 600;
            margin-bottom: 4px;
        }

        .overlay-link-desc {
            font-size: 0.85rem;
            opacity: 0.7;
        }

        .overlay-stories {
            width: 350px;
            flex-shrink: 0;
            margin-left: 30px;
            border-left: 1px solid rgba(255, 255, 255, 0.1);
            padding-left: 30px;
        }

        .overlay-stories-title {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .story-items {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .story-item {
            height: 200px;
            border-radius: 20px;
            overflow: hidden;
            position: relative;
            background-size: cover;
            background-position: center;
            transition: transform 0.3s ease;
            cursor: pointer;
        }

        .story-item:hover {
            transform: scale(1.02);
        }

        .story-content {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 20px;
            background: linear-gradient(transparent, rgba(0, 0, 0, 0.9));
        }

        .story-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .story-desc {
            font-size: 0.9rem;
            opacity: 0.8;
        }

        /* Mobile Menu */
        .hamburger {
            display: none;
            width: 40px;
            height: 40px;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            position: relative;
            cursor: pointer;
            z-index: 1003;
            transition: background 0.3s ease;
        }

        @media (max-width: 1023px) {
            .hamburger {
                display: flex;
            }
        }

        .hamburger span {
            display: block;
            position: absolute;
            height: 2px;
            width: 20px;
            background: #FFFFFF;
            border-radius: 2px;
            opacity: 1;
            transition: transform 0.3s ease;
        }

        .hamburger span:nth-child(1) {
            top: 14px;
        }

        .hamburger span:nth-child(2) {
            top: 24px;
        }

        .hamburger.active span:nth-child(1) {
            transform: translateY(5px) rotate(45deg);
        }

        .hamburger.active span:nth-child(2) {
            transform: translateY(-5px) rotate(-45deg);
        }

        .mobile-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(5px);
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .mobile-backdrop.active {
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000000;
            z-index: 1001;
            transform: translateY(-100%);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
        }

        .mobile-menu.active {
            transform: translateY(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
        }

        .mobile-title {
            font-size: 1.25rem;
            font-weight: 600;
        }

        /* Mobile Stories Grid */
        .mobile-stories {
            padding: 20px;
        }

        .stories-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .story-card {
            aspect-ratio: 1/1;
            border-radius: 20px;
            overflow: hidden;
            position: relative;
            box-shadow: 0 10px 15px -5px rgba(0, 0, 0, 0.3);
        }

        .story-card-inner {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            padding: 15px;
            background: linear-gradient(transparent 40%, rgba(0, 0, 0, 0.9));
        }

        .story-card-title {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 4px;
        }

        .story-card-desc {
            font-size: 0.75rem;
            opacity: 0.8;
            margin-bottom: 10px;
        }

        .story-card-link {
            display: inline-block;
            padding: 5px 12px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50px;
            font-size: 0.7rem;
            font-weight: 500;
            transition: background 0.3s ease;
        }

        .story-card-link:active {
            background: rgba(255, 255, 255, 0.3);
        }

        .mobile-nav-items {
            padding: 20px;
        }

        .mobile-nav-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 16px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            margin-bottom: 12px;
            font-weight: 500;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        .mobile-nav-item:active {
            background: rgba(255, 255, 255, 0.1);
        }

        .mobile-submenu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000000;
            z-index: 1002;
            transform: translateX(100%);
            transition: all 0.3s ease;
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
        }

        .mobile-submenu.active {
            transform: translateX(0);
            opacity: 1;
            visibility: visible;
        }

        .submenu-header {
            display: flex;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            gap: 15px;
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
        }

        .back-button {
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            cursor: pointer;
        }

        .submenu-links {
            padding: 20px;
        }

        .submenu-link {
            display: block;
            padding: 16px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            margin-bottom: 12px;
            transition: background 0.3s ease;
        }

        .submenu-link:active {
            background: rgba(255, 255, 255, 0.1);
        }

        .imators-account-btn {
            display: inline-flex;
            align-items: center;
            padding: 0.5rem 1rem;
            font-weight: 500;
            color: #000000;
            background-color: #FFFFFF;
            border-radius: 12px;
            transition: all 0.2s ease;
            display: none;
        }

        @media (min-width: 1024px) {
            .imators-account-btn {
                display: flex;
            }
        }

        .imators-account-btn:hover {
            opacity: 0.9;
        }
    </style>
</head>
<body class="h-full">
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 header-content">
            <div class="logo-container">
                <a href="/" class="flex items-center">
                    <img src="https://cdn.imators.com/logo.png" alt="Logo Imators">
                </a>
            </div>

            <div class="desktop-menu items-center space-x-6">
                <div class="desktop-menu-item font-light" data-overlay="products-overlay">
                    Products
                </div>
                <div class="desktop-menu-item" data-overlay="dev-tools-overlay">
                    Developer Tools
                </div>
                <div class="desktop-menu-item" data-overlay="company-overlay">
                    Company
                </div>
            </div>

            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="imators-account-btn">
                    Imators Account
                </a>
                <button id="hamburger" class="hamburger">
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>
    </header>
    
    <!-- Desktop Overlays -->
    <div class="desktop-overlay" id="products-overlay">
        <div class="overlay-container">
            <div class="overlay-header">
                <h3 class="overlay-title">Products</h3>
                <button class="overlay-close">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M18 6L6 18M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <div class="overlay-content">
                <div class="overlay-links">
                    <a href="https://academ.my" class="overlay-link">
                        <div class="overlay-link-title">Academ</div>
                        <div class="overlay-link-desc">Say goodbye to homework overflow</div>
                    </a>
                    <a href="/progm" class="overlay-link">
                        <div class="overlay-link-title">Progm</div>
                        <div class="overlay-link-desc">Program management simplified</div>
                    </a>
                    <a href="https://ohmypanel.com" class="overlay-link">
                        <div class="overlay-link-title">OhMyPanel</div>
                        <div class="overlay-link-desc">Quick & easy shopping</div>
                    </a>
                    <a href="https://owtfitt.com" class="overlay-link">
                        <div class="overlay-link-title">Owtfitt</div>
                        <div class="overlay-link-desc">Premium fashion outfits</div>
                    </a>
                    <a href="https://imators.systems/traffic" class="overlay-link">
                        <div class="overlay-link-title">TrafficLight</div>
                        <div class="overlay-link-desc">Intelligent traffic management</div>
                    </a>
                </div>
                
                <div class="overlay-stories">
                    <h4 class="overlay-stories-title">Stories</h4>
                    <div class="story-items">
                        <div class="story-item" style="background-image: url('https://cdn.imators.com/story1.jpg')">
                            <div class="story-content">
                                <h5 class="story-title">Academ Success</h5>
                                <p class="story-desc">See how Academ transforms education</p>
                            </div>
                        </div>
                        <div class="story-item" style="background-image: url('https://cdn.imators.com/story2.jpg')">
                            <div class="story-content">
                                <h5 class="story-title">TrafficLight Impact</h5>
                                <p class="story-desc">Smart traffic solutions in action</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="desktop-overlay" id="dev-tools-overlay">
        <div class="overlay-container">
            <div class="overlay-header">
                <h3 class="overlay-title">Developer Tools</h3>
                <button class="overlay-close">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M18 6L6 18M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <div class="overlay-content">
                <div class="overlay-links">
                    <a href="https://imators.systems" class="overlay-link">
                        <div class="overlay-link-title">Imators Systems</div>
                        <div class="overlay-link-desc">Enterprise-grade systems</div>
                    </a>
                    <a href="https://developer.imators.com" class="overlay-link">
                        <div class="overlay-link-title">Imators Developer</div>
                        <div class="overlay-link-desc">Developer resources & APIs</div>
                    </a>
                    <a href="https://imators.systems/traffic" class="overlay-link">
                        <div class="overlay-link-title">TrafficLight</div>
                        <div class="overlay-link-desc">Traffic management API</div>
                    </a>
                </div>
                
                <div class="overlay-stories">
                    <h4 class="overlay-stories-title">Stories</h4>
                    <div class="story-items">
                        <div class="story-item" style="background-image: url('https://cdn.imators.com/dev1.jpg')">
                            <div class="story-content">
                                <h5 class="story-title">Developer Journey</h5>
                                <p class="story-desc">Building with Imators tools</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="desktop-overlay" id="company-overlay">
        <div class="overlay-container">
            <div class="overlay-header">
                <h3 class="overlay-title">Company</h3>
                <button class="overlay-close">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M18 6L6 18M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <div class="overlay-content">
                <div class="overlay-links">
                    <a href="/support" class="overlay-link">
                        <div class="overlay-link-title">Support</div>
                        <div class="overlay-link-desc">Get help with our products</div>
                    </a>
                    <a href="/contact-us" class="overlay-link">
                        <div class="overlay-link-title">Contact us</div>
                        <div class="overlay-link-desc">Reach out to our team</div>
                    </a>
                    <a href="/about-us" class="overlay-link">
                        <div class="overlay-link-title">About Imators</div>
                        <div class="overlay-link-desc">Our mission and vision</div>
                    </a>
                </div>
                
                <div class="overlay-stories">
                    <h4 class="overlay-stories-title">Stories</h4>
                    <div class="story-items">
                        <div class="story-item" style="background-image: url('https://cdn.imators.com/company1.jpg')">
                            <div class="story-content">
                                <h5 class="story-title">Our Journey</h5>
                                <p class="story-desc">The story of Imators</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div class="mobile-backdrop"></div>

    <div class="mobile-menu">
        <div class="mobile-header">
            <div class="mobile-title">Nice to see you.</div>
        </div>

        <div class="mobile-stories">
            <div class="stories-grid">
                <div class="story-card" style="background-color: #8B5CF6;">
                    <div class="story-card-inner">
                        <h3 class="story-card-title">Academ</h3>
                        <p class="story-card-desc">Say goodbye to homework overflow</p>
                        <a href="https://academ.my" class="story-card-link">Learn more</a>
                    </div>
                </div>
                <div class="story-card" style="background-color: #FBBF24;">
                    <div class="story-card-inner">
                        <h3 class="story-card-title">OhMyPanel</h3>
                        <p class="story-card-desc">Quick & easy shopping</p>
                        <a href="https://ohmypanel.com" class="story-card-link">Learn more</a>
                    </div>
                </div>
                <div class="story-card" style="background-color: #404040;">
                    <div class="story-card-inner">
                        <h3 class="story-card-title">Imators Account</h3>
                        <p class="story-card-desc">Global benefits</p>
                        <a href="https://idsma.imators.com" class="story-card-link">Explorer</a>
                    </div>
                </div>
                <div class="story-card" style="background-color: #3B82F6;">
                    <div class="story-card-inner">
                        <h3 class="story-card-title">Support</h3>
                        <p class="story-card-desc">Fast & efficient help</p>
                        <a href="/contact-us" class="story-card-link">Help me</a>
                    </div>
                </div>
                <div class="story-card" style="background-color: #059669;">
                    <div class="story-card-inner">
                        <h3 class="story-card-title">TrafficLight</h3>
                        <p class="story-card-desc">Traffic management</p>
                        <a href="https://imators.systems/traffic" class="story-card-link">Discover</a>
                    </div>
                </div>
                <div class="story-card" style="background-color: #DC2626;">
                    <div class="story-card-inner">
                        <h3 class="story-card-title">Progm</h3>
                        <p class="story-card-desc">Program management</p>
                        <a href="/progm" class="story-card-link">Explore</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="mobile-nav-items">
            <div class="mobile-nav-item" data-submenu="products">
                <span>Products</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-nav-item" data-submenu="dev-tools">
                <span>Developer Tools</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-nav-item" data-submenu="company">
                <span>Company</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
        </div>
    </div>

    <!-- Mobile Submenus -->
    <div class="mobile-submenu" id="products-submenu">
        <div class="submenu-header">
            <button class="back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="mobile-title">Products</span>
        </div>
        <div class="submenu-links">
            <a href="https://academ.my" class="submenu-link">Academ</a>
            <a href="/progm" class="submenu-link">Progm</a>
            <a href="https://ohmypanel.com" class="submenu-link">OhMyPanel</a>
            <a href="https://owtfitt.com" class="submenu-link">Owtfitt</a>
            <a href="https://imators.systems/traffic" class="submenu-link">TrafficLight</a>
        </div>
    </div>

    <div class="mobile-submenu" id="dev-tools-submenu">
        <div class="submenu-header">
            <button class="back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="mobile-title">Developer Tools</span>
        </div>
        <div class="submenu-links">
            <a href="https://imators.systems" class="submenu-link">Imators Systems</a>
            <a href="https://developer.imators.com" class="submenu-link">Imators Developer</a>
            <a href="https://imators.systems/traffic" class="submenu-link">TrafficLight</a>
        </div>
    </div>

    <div class="mobile-submenu" id="company-submenu">
        <div class="submenu-header">
            <button class="back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="mobile-title">Company</span>
        </div>
        <div class="submenu-links">
            <a href="/support" class="submenu-link">Support</a>
            <a href="/contact-us" class="submenu-link">Contact us</a>
            <a href="/about-us" class="submenu-link">About Imators</a>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Elements
            const header = document.querySelector('.header');
            const hamburger = document.getElementById('hamburger');
            const mobileMenu = document.querySelector('.mobile-menu');
            const mobileBackdrop = document.querySelector('.mobile-backdrop');
            const mobileNavItems = document.querySelectorAll('.mobile-nav-item');
            const mobileSubmenus = document.querySelectorAll('.mobile-submenu');
            const backButtons = document.querySelectorAll('.back-button');
            const desktopMenuItems = document.querySelectorAll('.desktop-menu-item');
            const desktopOverlays = document.querySelectorAll('.desktop-overlay');
            const overlayCloseButtons = document.querySelectorAll('.overlay-close');
            
            // Variables
            let lastScrollTop = 0;
            let scrollTimeout;
            let activeOverlay = null;
            let isTransitioning = false;

            // Header scroll effect
            window.addEventListener('scroll', function() {
                clearTimeout(scrollTimeout);
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                // Add scrolled class for transparent header
                if (header.classList.contains('header-transparent')) {
                    if (scrollTop > 0) {
                        header.classList.add('scrolled');
                    } else {
                        header.classList.remove('scrolled');
                    }
                }
                
                // Hide/show header on scroll
                if (!mobileMenu.classList.contains('active') && 
                    !activeOverlay && 
                    Math.abs(scrollTop - lastScrollTop) > 50) {
                    header.style.transform = scrollTop > lastScrollTop && scrollTop > header.offsetHeight ? 
                        'translateY(-100%)' : 'translateY(0)';
                    lastScrollTop = scrollTop;
                }
                
                // Show header after scroll stops
                scrollTimeout = setTimeout(() => {
                    header.style.transform = 'translateY(0)';
                }, 1000);
            });

            // Mobile Menu Toggle
            hamburger.addEventListener('click', function() {
                if (mobileMenu.classList.contains('active')) {
                    closeAllMobile();
                } else {
                    openMobileMenu();
                }
            });

            // Mobile backdrop click
            mobileBackdrop.addEventListener('click', closeAllMobile);

            // Mobile submenu navigation
            mobileNavItems.forEach(item => {
                item.addEventListener('click', function() {
                    if (isTransitioning) return;
                    isTransitioning = true;
                    
                    const submenuId = this.getAttribute('data-submenu') + '-submenu';
                    const submenu = document.getElementById(submenuId);
                    
                    if (submenu) {
                        submenu.classList.add('active');
                    }
                    
                    setTimeout(() => {
                        isTransitioning = false;
                    }, 300);
                });
            });

            // Back buttons in submenu
            backButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const submenu = this.closest('.mobile-submenu');
                    if (submenu) {
                        submenu.classList.remove('active');
                    }
                });
            });

            // Desktop menu overlay toggle
            desktopMenuItems.forEach(item => {
                item.addEventListener('click', function(e) {
                    e.stopPropagation();
                    const overlayId = this.getAttribute('data-overlay');
                    const overlay = document.getElementById(overlayId);
                    
                    if (overlay) {
                        // Close any active overlay
                        if (activeOverlay && activeOverlay !== overlay) {
                            activeOverlay.classList.remove('active');
                        }
                        
                        // Toggle current overlay
                        if (overlay.classList.contains('active')) {
                            closeDesktopOverlay(overlay);
                        } else {
                            openDesktopOverlay(overlay);
                        }
                    }
                });
            });

            // Close overlay with close button
            overlayCloseButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const overlay = this.closest('.desktop-overlay');
                    if (overlay) {
                        closeDesktopOverlay(overlay);
                    }
                });
            });

            // Close overlay when clicking outside
            document.addEventListener('click', function(e) {
                if (activeOverlay && 
                    !e.target.closest('.desktop-menu-item') && 
                    !e.target.closest('.overlay-container')) {
                    closeDesktopOverlay(activeOverlay);
                }
            });

            // ESC key to close overlays
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    if (activeOverlay) {
                        closeDesktopOverlay(activeOverlay);
                    } else if (mobileMenu.classList.contains('active')) {
                        closeAllMobile();
                    }
                }
            });

            // Mobile swipe down to close
            let touchStartY = 0;
            mobileMenu.addEventListener('touchstart', function(e) {
                touchStartY = e.touches[0].clientY;
            }, { passive: true });

            mobileMenu.addEventListener('touchmove', function(e) {
                const touchEndY = e.touches[0].clientY;
                const deltaY = touchEndY - touchStartY;

                if (deltaY > 70) {
                    closeAllMobile();
                    touchStartY = 0;
                }
            }, { passive: true });

            // Helper Functions
            function openMobileMenu() {
                document.body.style.overflow = 'hidden';
                mobileBackdrop.classList.add('active');
                mobileMenu.classList.add('active');
                hamburger.classList.add('active');
            }

            function closeAllMobile() {
                document.body.style.overflow = '';
                mobileBackdrop.classList.remove('active');
                mobileMenu.classList.remove('active');
                hamburger.classList.remove('active');
                
                // Close all submenus
                mobileSubmenus.forEach(submenu => {
                    submenu.classList.remove('active');
                });
            }

            function openDesktopOverlay(overlay) {
                document.body.style.overflow = 'hidden';
                overlay.classList.add('active');
                activeOverlay = overlay;
            }

            function closeDesktopOverlay(overlay) {
                document.body.style.overflow = '';
                overlay.classList.remove('active');
                activeOverlay = null;
            }

            // Story cards click handling
            const storyCards = document.querySelectorAll('.story-card');
            storyCards.forEach(card => {
                card.addEventListener('click', function() {
                    const link = this.querySelector('a');
                    if (link) {
                        link.click();
                    }
                });
            });

            // Story items click handling
            const storyItems = document.querySelectorAll('.story-item');
            storyItems.forEach(item => {
                item.addEventListener('click', function() {
                    window.location.href = '#story-detail';
                });
            });
        });
    </script>
</body>
</html>