<?php
// Démarrer la session pour récupérer les infos
session_start();

// Vérifier si les infos d'upload existent
if(!isset($_SESSION['upload_info'])) {
    // Rediriger vers la page d'upload si aucune info n'est trouvée
    header('Location: upload-xxx-redirect.php');
    exit();
}

// Récupérer les infos
$price = $_SESSION['upload_info']['price'];
$fileInfo = $_SESSION['upload_info']['file'];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Publication Réussie - Imators XXX</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: black;
            color: white;
            background-image: linear-gradient(to bottom, rgba(0,0,0,0.9) 0%, rgba(20,20,20,0.8) 100%);
        }
        .neon-text {
            text-shadow: 0 0 10px #ff69b4, 0 0 20px #ff69b4, 0 0 30px #ff69b4;
        }
        .glow-border {
            box-shadow: 0 0 10px rgba(255, 105, 180, 0.5), 0 0 20px rgba(255, 105, 180, 0.3);
        }
        .success-btn {
            background: linear-gradient(to right, #ff00cc, #333399);
        }
        .confetti {
            position: absolute;
            width: 10px;
            height: 10px;
            background-color: #ff69b4;
            animation: fall 5s ease-in infinite;
            opacity: 0.7;
        }
        @keyframes fall {
            0% {
                transform: translateY(-100px) rotate(0deg);
                opacity: 1;
            }
            100% {
                transform: translateY(100vh) rotate(360deg);
                opacity: 0;
            }
        }
        .pulse {
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
            100% {
                transform: scale(1);
            }
        }
    </style>
</head>
<body class="bg-black text-white min-h-screen">
    <!-- Confetti animation -->
    <div id="confetti-container"></div>
    
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8 sm:py-12">
        <!-- Header avec animation -->
        <header class="text-center mb-8 sm:mb-12">
            <h1 class="text-4xl sm:text-5xl font-light mb-2 neon-text pulse">Publication Réussie!</h1>
            <p class="text-gray-300 text-sm sm:text-base">Ton contenu va faire sensation 🔥</p>
        </header>
        
        <!-- Card principale -->
        <div class="bg-gradient-to-r from-purple-900 to-pink-900 p-6 sm:p-10 rounded-xl shadow-lg glow-border mb-8">
            <div class="flex flex-col md:flex-row items-center gap-8">
                <!-- Image de révélation du prix -->
                <div class="w-full md:w-1/2 flex justify-center">
                    <div class="relative w-full max-w-sm">
                        <?php if($fileInfo['type'] == 'image'): ?>
                            <img src="<?php echo $fileInfo['path']; ?>" class="w-full h-auto rounded-lg shadow-lg" alt="Ton contenu">
                        <?php elseif($fileInfo['type'] == 'video'): ?>
                            <video controls class="w-full h-auto rounded-lg shadow-lg">
                                <source src="<?php echo $fileInfo['path']; ?>" type="video/<?php echo $fileInfo['extension']; ?>">
                                Ton navigateur ne supporte pas la vidéo
                            </video>
                        <?php else: ?>
                            <div class="w-full h-64 bg-black rounded-lg flex items-center justify-center">
                                <p class="text-pink-400">Aperçu non disponible</p>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Badge avec le prix -->
                        <div class="absolute -top-4 -right-4 bg-pink-600 text-white text-2xl sm:text-3xl font-bold rounded-full w-24 h-24 sm:w-28 sm:h-28 flex items-center justify-center shadow-lg pulse">
                            <?php echo $price; ?>€
                        </div>
                    </div>
                </div>
                
                <!-- Texte d'explication -->
                <div class="w-full md:w-1/2">
                    <h2 class="text-2xl sm:text-3xl font-light mb-4">Félicitations!</h2>
                    <p class="mb-4">Ton contenu a été uploadé avec succès et pourrait te rapporter jusqu'à <span class="text-pink-300 font-semibold"><?php echo $price; ?>€</span> par mois.</p>
                    <p class="mb-6">Notre équipe va vérifier ton contenu dans les prochaines 24 heures avant qu'il soit publié sur la plateforme.</p>
                    
                    <div class="bg-black bg-opacity-40 p-4 rounded-lg mb-6">
                        <h3 class="text-pink-300 font-medium mb-2">Étapes suivantes:</h3>
                        <ul class="space-y-2 text-sm">
                            <li class="flex items-center">
                                <span class="bg-pink-500 rounded-full w-5 h-5 flex items-center justify-center mr-2">✓</span>
                                Tu recevras un email de confirmation quand ton contenu sera approuvé
                            </li>
                            <li class="flex items-center">
                                <span class="bg-pink-500 rounded-full w-5 h-5 flex items-center justify-center mr-2">✓</span>
                                Complète ton profil pour attirer plus de fans
                            </li>
                            <li class="flex items-center">
                                <span class="bg-pink-500 rounded-full w-5 h-5 flex items-center justify-center mr-2">✓</span>
                                Publie régulièrement pour maximiser tes revenus
                            </li>
                        </ul>
                    </div>
                    
                    <div class="flex flex-col sm:flex-row gap-4">
                        <a href="upload-xxx-redirect.php" class="success-btn text-white py-3 px-6 rounded-lg font-medium transition duration-300 text-center hover:opacity-90">Publier plus de contenu</a>
                        <a href="#" class="bg-gray-800 text-white py-3 px-6 rounded-lg font-medium transition duration-300 text-center hover:bg-gray-700">Voir mon profil</a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Statistiques -->
        <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-8">
            <div class="bg-gray-900 bg-opacity-70 p-4 rounded-lg text-center">
                <p class="text-3xl font-light text-pink-400 mb-1"><?php echo rand(85, 99); ?>%</p>
                <p class="text-sm text-gray-300">Taux d'approbation</p>
            </div>
            <div class="bg-gray-900 bg-opacity-70 p-4 rounded-lg text-center">
                <p class="text-3xl font-light text-pink-400 mb-1"><?php echo rand(12, 24); ?>h</p>
                <p class="text-sm text-gray-300">Temps de vérification moyen</p>
            </div>
            <div class="bg-gray-900 bg-opacity-70 p-4 rounded-lg text-center">
                <p class="text-3xl font-light text-pink-400 mb-1"><?php echo $price * 12; ?>€</p>
                <p class="text-sm text-gray-300">Potentiel annuel estimé</p>
            </div>
        </div>
        
        <!-- Recommandations -->
        <div class="mb-8">
            <h2 class="text-xl font-light mb-4">Pour augmenter tes revenus:</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">
                <div class="bg-gray-900 bg-opacity-70 p-4 rounded-lg">
                    <h3 class="font-medium text-pink-300 mb-2">Publie régulièrement</h3>
                    <p class="text-sm text-gray-300">Les créateurs qui publient au moins 3 fois par semaine gagnent 2x plus.</p>
                </div>
                <div class="bg-gray-900 bg-opacity-70 p-4 rounded-lg">
                    <h3 class="font-medium text-pink-300 mb-2">Interagis avec tes fans</h3>
                    <p class="text-sm text-gray-300">Réponds aux messages pour fidéliser ta communauté.</p>
                </div>
                <div class="bg-gray-900 bg-opacity-70 p-4 rounded-lg">
                    <h3 class="font-medium text-pink-300 mb-2">Propose du contenu exclusif</h3>
                    <p class="text-sm text-gray-300">Les contenus premium peuvent augmenter tes revenus de 70%.</p>
                </div>
            </div>
        </div>
        
        <footer class="text-center text-gray-500 text-xs sm:text-sm pb-6">
            <p>&copy; 2025 Imators XXX - Tous droits réservés</p>
            <p class="mt-2">En utilisant ce site, tu acceptes nos <a href="#" class="text-pink-400 hover:underline">conditions d'utilisation</a> et notre <a href="#" class="text-pink-400 hover:underline">politique de confidentialité</a></p>
        </footer>
    </div>
    
    <!-- Script pour l'animation confetti -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const container = document.getElementById('confetti-container');
            const colors = ['#ff69b4', '#ff00cc', '#cc00ff', '#9900ff', '#ffffff'];
            
            // Créer 50 confettis
            for (let i = 0; i < 50; i++) {
                const confetti = document.createElement('div');
                confetti.className = 'confetti';
                confetti.style.left = Math.random() * 100 + 'vw';
                confetti.style.backgroundColor = colors[Math.floor(Math.random() * colors.length)];
                confetti.style.width = Math.random() * 10 + 5 + 'px';
                confetti.style.height = Math.random() * 10 + 5 + 'px';
                confetti.style.animationDuration = Math.random() * 3 + 2 + 's';
                confetti.style.animationDelay = Math.random() * 5 + 's';
                container.appendChild(confetti);
            }
            
            // Supprimer la session après chargement de la page
            setTimeout(() => {
                fetch('clear_session.php');
            }, 1000);
        });
    </script>
</body>
</html>