<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TrafficLight API Documentation - Imators</title>
    <link rel="icon" type="image/png" href="traffic_logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Inter', 'sans-serif']
                    },
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#bae6fd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e'
                        },
                        traffic: {
                            red: '#ef4444',
                            green: '#10b981',
                            amber: '#f59e0b'
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50">
    <header class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <img src="traffic_logo.png" alt="Logo" class="w-8 h-8 mr-2">
                    <h1 class="text-xl font-semibold text-gray-800">TrafficLight Admin</h1>
                </div>
                <div class="flex items-center">
                    <a href="admin-dashboard.php" class="text-gray-600 hover:text-gray-900 px-3 py-2 rounded-md text-sm font-medium">Dashboard</a>
                    <a href="api-key-manager.php" class="text-primary-600 hover:text-primary-700 px-3 py-2 rounded-md text-sm font-medium">API Keys</a>
                    <a href="admin-logout.php" class="text-gray-600 hover:text-gray-900 px-3 py-2 rounded-md text-sm font-medium">Logout</a>
                </div>
            </div>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="mb-10">
            <h2 class="text-3xl font-bold text-gray-900 mb-2">TrafficLight API Documentation</h2>
            <p class="text-lg text-gray-600">Complete documentation for integrating with the TrafficLight API service.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
            <div class="md:col-span-1">
                <nav class="space-y-1 sticky top-4" aria-label="Sidebar">
                    <a href="#introduction" class="text-primary-600 hover:bg-primary-50 hover:text-primary-700 group flex items-center px-3 py-2 text-sm font-medium rounded-md">
                        <i class="fas fa-info-circle mr-3 text-primary-500"></i>
                        <span class="truncate">Introduction</span>
                    </a>
                    <a href="#authentication" class="text-gray-600 hover:bg-gray-50 hover:text-gray-900 group flex items-center px-3 py-2 text-sm font-medium rounded-md">
                        <i class="fas fa-key mr-3 text-gray-400 group-hover:text-gray-500"></i>
                        <span class="truncate">Authentication</span>
                    </a>
                    <a href="#endpoints" class="text-gray-600 hover:bg-gray-50 hover:text-gray-900 group flex items-center px-3 py-2 text-sm font-medium rounded-md">
                        <i class="fas fa-code mr-3 text-gray-400 group-hover:text-gray-500"></i>
                        <span class="truncate">API Endpoints</span>
                    </a>
                    <a href="#responses" class="text-gray-600 hover:bg-gray-50 hover:text-gray-900 group flex items-center px-3 py-2 text-sm font-medium rounded-md">
                        <i class="fas fa-reply mr-3 text-gray-400 group-hover:text-gray-500"></i>
                        <span class="truncate">Responses</span>
                    </a>
                    <a href="#examples" class="text-gray-600 hover:bg-gray-50 hover:text-gray-900 group flex items-center px-3 py-2 text-sm font-medium rounded-md">
                        <i class="fas fa-code-branch mr-3 text-gray-400 group-hover:text-gray-500"></i>
                        <span class="truncate">Code Examples</span>
                    </a>
                    <a href="#limitations" class="text-gray-600 hover:bg-gray-50 hover:text-gray-900 group flex items-center px-3 py-2 text-sm font-medium rounded-md">
                        <i class="fas fa-exclamation-triangle mr-3 text-gray-400 group-hover:text-gray-500"></i>
                        <span class="truncate">Limitations</span>
                    </a>
                </nav>
            </div>
            <div class="md:col-span-3">
                <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                    <div id="introduction" class="px-4 py-5 sm:px-6 border-b border-gray-200">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Introduction</h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">Learn how to use the TrafficLight API</p>
                    </div>
                    <div class="px-4 py-5 sm:p-6">
                        <p class="text-gray-700 mb-4">
                            TrafficLight API provides real-time traffic data and monitoring solutions for your applications. 
                            Our API allows developers to integrate traffic information into their applications, 
                            websites, or services quickly and efficiently.
                        </p>
                        <p class="text-gray-700 mb-4">
                            The base URL for all API requests is:
                        </p>
                        <div class="bg-gray-100 rounded p-3 font-mono text-sm mb-4">
                            https://imators.systems/traffic/api/v1
                        </div>
                        <p class="text-gray-700 mb-4">
                            All requests must use HTTPS and include a valid API key in the request headers.
                        </p>
                    </div>

                    <div id="authentication" class="px-4 py-5 sm:px-6 border-t border-b border-gray-200">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Authentication</h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">How to authenticate your API requests</p>
                    </div>
                    <div class="px-4 py-5 sm:p-6">
                        <p class="text-gray-700 mb-4">
                            All API requests require authentication using an API key. You can obtain an API key from your 
                            <a href="https://imators.systems/traffic/dashboard" class="text-primary-600 hover:text-primary-700">TrafficLight Dashboard</a>.
                        </p>
                        <p class="text-gray-700 mb-4">
                            Include your API key in the request headers as follows:
                        </p>
                        <div class="bg-gray-100 rounded p-3 font-mono text-sm mb-4">
                            X-API-Key: your_api_key_here
                        </div>
                        <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-exclamation-triangle text-yellow-400"></i>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm text-yellow-700">
                                        Keep your API key secret. Do not share it in publicly accessible areas such as GitHub, 
                                        client-side code, or forums.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div id="endpoints" class="px-4 py-5 sm:px-6 border-t border-b border-gray-200">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">API Endpoints</h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">Available endpoints and their usage</p>
                    </div>
                    <div class="px-4 py-5 sm:p-6">
                        <h4 class="font-semibold text-lg mb-2">Get Traffic Status</h4>
                        <p class="text-gray-700 mb-2">Returns the current traffic status for a given location or route.</p>
                        <div class="bg-gray-100 rounded p-3 font-mono text-sm mb-4">
                            GET /status?location={location}
                        </div>
                        <p class="text-gray-700 mb-4">
                            Parameters:
                        </p>
                        <table class="min-w-full divide-y divide-gray-200 mb-6">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Parameter</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">location</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">string</td>
                                    <td class="px-6 py-4 text-sm text-gray-500">The location to get traffic data for (e.g., city name, coordinates, or route ID)</td>
                                </tr>
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">format</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">string</td>
                                    <td class="px-6 py-4 text-sm text-gray-500">Optional. Response format: 'json' (default) or 'xml'</td>
                                </tr>
                            </tbody>
                        </table>

                        <h4 class="font-semibold text-lg mb-2 mt-8">Monitor Traffic</h4>
                        <p class="text-gray-700 mb-2">Sets up a traffic monitoring alert for a specified route.</p>
                        <div class="bg-gray-100 rounded p-3 font-mono text-sm mb-4">
                            POST /monitor
                        </div>
                        <p class="text-gray-700 mb-4">
                            Request body (JSON):
                        </p>
                        <div class="bg-gray-100 rounded p-3 font-mono text-sm mb-4">
{
  "route": "string",
  "threshold": "medium",
  "notification_url": "string",
  "active": true
}
                        </div>
                    </div>

                    <div id="responses" class="px-4 py-5 sm:px-6 border-t border-b border-gray-200">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Responses</h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">Understanding API responses</p>
                    </div>
                    <div class="px-4 py-5 sm:p-6">
                        <p class="text-gray-700 mb-4">
                            All API responses are returned in JSON format (unless XML is specified) and include a status code.
                        </p>
                        <h4 class="font-semibold text-lg mb-2">Success Response</h4>
                        <div class="bg-gray-100 rounded p-3 font-mono text-sm mb-6">
{
  "status": "success",
  "data": {
    "traffic_level": "medium",
    "travel_time": 15,
    "congestion_points": [
      {
        "location": "Main St & 5th Ave",
        "severity": "high"
      }
    ]
  }
}
                        </div>

                        <h4 class="font-semibold text-lg mb-2">Error Response</h4>
                        <div class="bg-gray-100 rounded p-3 font-mono text-sm mb-4">
{
  "status": "error",
  "error": {
    "code": 401,
    "message": "Invalid API key"
  }
}
                        </div>
                    </div>

                    <div id="examples" class="px-4 py-5 sm:px-6 border-t border-b border-gray-200">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Code Examples</h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">Implementation examples in various languages</p>
                    </div>
                    <div class="px-4 py-5 sm:p-6">
                        <div class="mb-8">
                            <h4 class="font-semibold text-lg mb-2">JavaScript</h4>
                            <div class="bg-gray-100 rounded p-3 font-mono text-sm">
const apiKey = 'your_api_key_here';
const location = 'New York';

fetch(`https://imators.systems/traffic/api/v1/status?location=${encodeURIComponent(location)}`, {
  headers: {
    'X-API-Key': apiKey
  }
})
.then(response => response.json())
.then(data => {
  console.log('Traffic status:', data);
})
.catch(error => {
  console.error('Error fetching traffic data:', error);
});
                            </div>
                        </div>

                        <div class="mb-8">
                            <h4 class="font-semibold text-lg mb-2">PHP</h4>
                            <div class="bg-gray-100 rounded p-3 font-mono text-sm">
$apiKey = 'your_api_key_here';
$location = 'New York';
$url = 'https://imators.systems/traffic/api/v1/status?location=' . urlencode($location);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'X-API-Key: ' . $apiKey
]);

$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);
print_r($data);
                            </div>
                        </div>
                    </div>

                    <div id="limitations" class="px-4 py-5 sm:px-6 border-t border-gray-200">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Limitations</h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">API usage limits and restrictions</p>
                    </div>
                    <div class="px-4 py-5 sm:p-6">
                        <ul class="list-disc pl-5 space-y-2 text-gray-700">
                            <li>Free tier accounts are limited to 1,000 requests per day.</li>
                            <li>Premium accounts have higher limits based on the subscription plan.</li>
                            <li>Rate limiting is applied to prevent API abuse. Exceeding the rate limit will result in a 429 (Too Many Requests) response.</li>
                            <li>Maximum of 10 concurrent requests per API key.</li>
                            <li>Requests that exceed the allowed limits will receive an error response.</li>
                        </ul>
                    </div>
                </div>

                <div class="mt-8 bg-white shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6 border-b border-gray-200">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Need Help?</h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">Contact our support team</p>
                    </div>
                    <div class="px-4 py-5 sm:p-6">
                        <p class="text-gray-700 mb-4">
                            If you need assistance or have questions about the TrafficLight API, our support team is here to help.
                        </p>
                        <a href="https://imators.systems/traffic/contact.php" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-primary-600 hover:bg-primary-700">
                            <i class="fas fa-envelope mr-2"></i> Contact Support
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="bg-white mt-12">
        <div class="max-w-7xl mx-auto py-12 px-4 overflow-hidden sm:px-6 lg:px-8">
            <nav class="-mx-5 -my-2 flex flex-wrap justify-center" aria-label="Footer">
                <div class="px-5 py-2">
                    <a href="https://imators.systems/traffic/" class="text-base text-gray-500 hover:text-gray-900">Home</a>
                </div>
                <div class="px-5 py-2">
                    <a href="https://imators.systems/traffic/documentation.php" class="text-base text-gray-500 hover:text-gray-900">Documentation</a>
                </div>
                <div class="px-5 py-2">
                    <a href="https://imators.systems/traffic/pricing.php" class="text-base text-gray-500 hover:text-gray-900">Pricing</a>
                </div>
                <div class="px-5 py-2">
                    <a href="https://imators.systems/traffic/contact.php" class="text-base text-gray-500 hover:text-gray-900">Contact</a>
                </div>
                <div class="px-5 py-2">
                    <a href="https://imators.systems/traffic/terms.php" class="text-base text-gray-500 hover:text-gray-900">Terms</a>
                </div>
                <div class="px-5 py-2">
                    <a href="https://imators.systems/traffic/privacy.php" class="text-base text-gray-500 hover:text-gray-900">Privacy</a>
                </div>
            </nav>
            <div class="mt-8 flex justify-center space-x-6">
                <a href="#" class="text-gray-400 hover:text-gray-500">
                    <i class="fab fa-facebook"></i>
                </a>
                <a href="#" class="text-gray-400 hover:text-gray-500">
                    <i class="fab fa-twitter"></i>
                </a>
                <a href="#" class="text-gray-400 hover:text-gray-500">
                    <i class="fab fa-linkedin"></i>
                </a>
                <a href="#" class="text-gray-400 hover:text-gray-500">
                    <i class="fab fa-github"></i>
                </a>
            </div>
            <p class="mt-8 text-center text-base text-gray-400">
                &copy; 2025 Imators Systems. All rights reserved.
            </p>
        </div>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const navLinks = document.querySelectorAll('nav a[href^="#"]');
            
            navLinks.forEach(link => {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    const targetId = this.getAttribute('href');
                    const targetElement = document.querySelector(targetId);
                    
                    if (targetElement) {
                        window.scrollTo({
                            top: targetElement.offsetTop - 20,
                            behavior: 'smooth'
                        });
                        
                        navLinks.forEach(l => l.classList.remove('text-primary-600', 'hover:bg-primary-50', 'hover:text-primary-700'));
                        navLinks.forEach(l => l.classList.add('text-gray-600', 'hover:bg-gray-50', 'hover:text-gray-900'));
                        
                        this.classList.remove('text-gray-600', 'hover:bg-gray-50', 'hover:text-gray-900');
                        this.classList.add('text-primary-600', 'hover:bg-primary-50', 'hover:text-primary-700');
                    }
                });
            });
        });
    </script>
</body>
</html>