<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Documentation - TrafficLight</title>
    <link rel="icon" type="image/png" href="traffic_logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Inter', 'sans-serif']
                    },
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#bae6fd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e'
                        },
                        traffic: {
                            red: '#ef4444',
                            green: '#10b981',
                            amber: '#f59e0b'
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50">
    <header class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <img src="traffic_logo.png" alt="Logo" class="w-8 h-8 mr-2">
                    <h1 class="text-xl font-semibold text-gray-800">TrafficLight Admin</h1>
                </div>
                <div class="flex items-center">
                    <a href="admin-dashboard.php" class="text-gray-600 hover:text-gray-900 px-3 py-2 rounded-md text-sm font-medium">Dashboard</a>
                    <a href="api-key-manager.php" class="text-primary-600 hover:text-primary-700 px-3 py-2 rounded-md text-sm font-medium">API Keys</a>
                    <a href="admin-logout.php" class="text-gray-600 hover:text-gray-900 px-3 py-2 rounded-md text-sm font-medium">Logout</a>
                </div>
            </div>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="md:flex md:items-center md:justify-between mb-6">
            <div class="flex-1 min-w-0">
                <h2 class="text-2xl font-bold leading-7 text-gray-900 sm:text-3xl sm:truncate">API Documentation</h2>
                <p class="mt-1 text-sm text-gray-500">Complete documentation for the TrafficLight API</p>
            </div>
        </div>

        <div class="bg-white shadow overflow-hidden sm:rounded-lg mb-6">
            <div class="px-4 py-5 sm:px-6 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-medium text-gray-900">Getting Started</h3>
            </div>
            <div class="px-4 py-5 sm:p-6">
                <p class="text-gray-700 mb-4">
                    To get started with the TrafficLight API, you need an API key. You can manage your API keys in the 
                    <a href="api-key-manager.php" class="text-primary-600 hover:underline">API Key Manager</a>.
                </p>
                <p class="text-gray-700 mb-4">
                    The base URL for all API requests is:
                </p>
                <div class="bg-gray-100 rounded p-3 font-mono text-sm mb-4">
                    https://imators.systems/traffic/api/v1
                </div>
                <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <i class="fas fa-exclamation-triangle text-yellow-400"></i>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-yellow-700">
                                Keep your API key secret. Do not share it in publicly accessible areas such as GitHub, 
                                client-side code, or forums.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-white shadow overflow-hidden sm:rounded-lg mb-6">
            <div class="px-4 py-5 sm:px-6 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-medium text-gray-900">Authentication</h3>
            </div>
            <div class="px-4 py-5 sm:p-6">
                <p class="text-gray-700 mb-4">
                    All API requests require authentication using an API key header:
                </p>
                <div class="bg-gray-100 rounded p-3 font-mono text-sm mb-4">
                    X-API-Key: your_api_key_here
                </div>
                <p class="text-gray-700 mb-4">
                    Example request using cURL:
                </p>
                <div class="bg-gray-100 rounded p-3 font-mono text-sm">
curl -X GET "https://imators.systems/traffic/api/v1/status" \
     -H "X-API-Key: your_api_key_here"
                </div>
            </div>
        </div>
        
        <div class="bg-white shadow overflow-hidden sm:rounded-lg mb-6">
            <div class="px-4 py-5 sm:px-6 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-medium text-gray-900">Endpoints</h3>
            </div>
            <div class="border-b border-gray-200">
                <div class="px-4 py-5 sm:p-6">
                    <h4 class="text-md font-bold text-gray-800 mb-2">Get Traffic Status</h4>
                    <div class="flex items-center mb-2">
                        <span class="px-2 py-1 text-xs font-medium rounded bg-green-100 text-green-800 mr-2">GET</span>
                        <span class="font-mono text-sm">/api/v1/status</span>
                    </div>
                    <p class="text-gray-700 mb-4">
                        Returns the current traffic status for a given location or route.
                    </p>
                    <h5 class="font-semibold text-sm text-gray-700 mb-1">Query Parameters:</h5>
                    <table class="min-w-full divide-y divide-gray-200 mb-4">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Parameter</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Required</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">location</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">string</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Yes</td>
                                <td class="px-6 py-4 text-sm text-gray-500">The location identifier (city name or coordinates)</td>
                            </tr>
                        </tbody>
                    </table>
                    
                    <h5 class="font-semibold text-sm text-gray-700 mb-1">Example Response:</h5>
                    <div class="bg-gray-100 rounded p-3 font-mono text-sm">
{
  "status": "success",
  "data": {
    "location": "New York",
    "traffic_level": "medium",
    "timestamp": "2025-04-06T14:30:00Z",
    "congestion_points": [
      {
        "location": "Broadway & 42nd St",
        "level": "high"
      },
      {
        "location": "5th Ave & 34th St",
        "level": "medium"
      }
    ]
  }
}
                    </div>
                </div>
            </div>
            
            <div class="px-4 py-5 sm:p-6">
                <h4 class="text-md font-bold text-gray-800 mb-2">Create Traffic Monitor</h4>
                <div class="flex items-center mb-2">
                    <span class="px-2 py-1 text-xs font-medium rounded bg-blue-100 text-blue-800 mr-2">POST</span>
                    <span class="font-mono text-sm">/api/v1/monitors</span>
                </div>
                <p class="text-gray-700 mb-4">
                    Creates a traffic monitoring alert for a specific route.
                </p>
                
                <h5 class="font-semibold text-sm text-gray-700 mb-1">Request Body:</h5>
                <div class="bg-gray-100 rounded p-3 font-mono text-sm mb-4">
{
  "route": "Broadway to Central Park",
  "threshold": "high",
  "notification_url": "https://example.com/webhook",
  "email_notification": "user@example.com"
}
                </div>
                
                <h5 class="font-semibold text-sm text-gray-700 mb-1">Example Response:</h5>
                <div class="bg-gray-100 rounded p-3 font-mono text-sm">
{
  "status": "success",
  "data": {
    "monitor_id": "mon_12345",
    "route": "Broadway to Central Park",
    "created_at": "2025-04-06T15:00:00Z",
    "status": "active"
  }
}
                </div>
            </div>
        </div>
        
        <div class="bg-white shadow overflow-hidden sm:rounded-lg mb-6">
            <div class="px-4 py-5 sm:px-6 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-medium text-gray-900">Error Codes</h3>
            </div>
            <div class="px-4 py-5 sm:p-6">
                <p class="text-gray-700 mb-4">
                    The API uses standard HTTP status codes and includes detailed error messages.
                </p>
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status Code</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">200 OK</td>
                            <td class="px-6 py-4 text-sm text-gray-500">The request was successful</td>
                        </tr>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">400 Bad Request</td>
                            <td class="px-6 py-4 text-sm text-gray-500">The request was invalid or malformed</td>
                        </tr>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">401 Unauthorized</td>
                            <td class="px-6 py-4 text-sm text-gray-500">Invalid or missing API key</td>
                        </tr>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">403 Forbidden</td>
                            <td class="px-6 py-4 text-sm text-gray-500">The API key doesn't have access to the requested resource</td>
                        </tr>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">404 Not Found</td>
                            <td class="px-6 py-4 text-sm text-gray-500">The requested resource doesn't exist</td>
                        </tr>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">429 Too Many Requests</td>
                            <td class="px-6 py-4 text-sm text-gray-500">Rate limit exceeded</td>
                        </tr>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">500 Server Error</td>
                            <td class="px-6 py-4 text-sm text-gray-500">An error occurred on the server</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="bg-white shadow overflow-hidden sm:rounded-lg">
            <div class="px-4 py-5 sm:px-6 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-medium text-gray-900">Code Examples</h3>
            </div>
            <div class="px-4 py-5 sm:p-6">
                <div class="mb-6">
                    <h4 class="text-md font-bold text-gray-800 mb-2">JavaScript</h4>
                    <div class="bg-gray-100 rounded p-3 font-mono text-sm">
// Get traffic status
const apiKey = 'your_api_key_here';
const location = 'New York';

fetch(`https://imators.systems/traffic/api/v1/status?location=${encodeURIComponent(location)}`, {
  headers: {
    'X-API-Key': apiKey
  }
})
.then(response => response.json())
.then(data => {
  console.log('Traffic status:', data);
})
.catch(error => {
  console.error('Error:', error);
});
                    </div>
                </div>
                
                <div class="mb-6">
                    <h4 class="text-md font-bold text-gray-800 mb-2">PHP</h4>
                    <div class="bg-gray-100 rounded p-3 font-mono text-sm">
<?php
// Get traffic status
$apiKey = 'your_api_key_here';
$location = 'New York';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://imators.systems/traffic/api/v1/status?location=' . urlencode($location));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'X-API-Key: ' . $apiKey
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200) {
    $data = json_decode($response, true);
    print_r($data);
} else {
    echo "Error: " . $httpCode;
}
?>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Any additional scripts can go here
        });
    </script>
</body>
</html>