<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AndWeare</title>
    <link rel="icon" type="image/png" href="logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+KR:wght@300;400;500;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/ScrollTrigger.min.js"></script>
    <style>
        body {
            font-family: 'Noto Sans KR', sans-serif;
            background-color: #ffffff;
            overflow-x: hidden;
        }
        
        .hero-section {
            height: 100vh;
            position: relative;
        }
        
        .content-container {
            position: relative;
            z-index: 10;
        }
        
        .phone-container {
            position: fixed;
            width: 270px;
            height: 570px;
            border-radius: 42px;
            background-color: #111;
            box-shadow: 0 15px 35px rgba(0,0,0,0.2);
            padding: 4px;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 5;
        }
        
        .phone-frame {
            width: 100%;
            height: 100%;
            border-radius: 38px;
            overflow: hidden;
            position: relative;
            border: 1px solid rgba(255,255,255,0.05);
        }
        
        .dynamic-island {
            position: absolute;
            top: 10px;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 30px;
            background-color: #000;
            border-radius: 20px;
            z-index: 2;
        }
        
        .dynamic-island::after {
            content: '';
            position: absolute;
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background-color: rgba(255,255,255,0.4);
            right: 10px;
        }
        
        .phone-video {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .phone-left {
            left: 10%;
            top: 50%;
            transform: translateY(-50%) perspective(1000px) rotateY(-5deg) rotateX(5deg) rotate(-5deg);
        }
        
        .phone-scroll {
            right: 10%;
            top: 50%;
            transform: translateY(-50%) perspective(1000px) rotateY(5deg) rotateX(5deg) rotate(5deg);
        }
        
        .phone-mobile {
            position: relative;
            width: 180px;
            height: 370px;
            border-radius: 30px;
            margin: 0 auto;
            display: none;
        }
        
        .phone-mobile .phone-frame {
            border-radius: 28px;
        }
        
        .phone-mobile .dynamic-island {
            width: 70px;
            height: 20px;
        }
        
        .phone-cutoff {
            position: relative;
            height: 200px;
            width: 100%;
            max-width: 200px;
            margin: 0 auto;
            overflow: hidden;
            border-top-left-radius: 30px;
            border-top-right-radius: 30px;
            display: none;
        }
        
        .phone-cutoff .phone-frame {
            border-radius: 0;
            border-top-left-radius: 28px;
            border-top-right-radius: 28px;
            height: 400px;
            transform: translateY(-200px);
        }
        
        .feature-section {
            min-height: 100vh;
            display: flex;
            align-items: center;
            padding: 80px 0;
        }
        
        .feature-content {
            opacity: 0;
            transform: translateY(30px);
        }
        
        .feature-icon {
            font-size: 2.5rem;
            margin-bottom: 1.5rem;
            display: inline-block;
            padding: 1rem;
            border-radius: 50%;
        }
        
        @media (max-width: 768px) {
            .phone-container {
                display: none;
            }
            
            .phone-mobile {
                display: block;
            }
            
            .phone-cutoff {
                display: block;
            }
            
            .feature-section {
                min-height: auto;
                padding: 60px 0;
            }
        }
    </style>
</head>
<body>
    <div class="phone-container phone-left hidden md:block">
        <div class="phone-frame">
            <div class="dynamic-island"></div>
            <video autoplay loop muted playsinline class="phone-video">
                <source src="250395_small.mp4" type="video/mp4">
            </video>
        </div>
    </div>
    
    <div id="scrollPhone" class="phone-container phone-scroll hidden md:block">
        <div class="phone-frame">
            <div class="dynamic-island"></div>
            <video autoplay loop muted playsinline class="phone-video">
                <source src="253998_small.mp4" type="video/mp4">
            </video>
        </div>
    </div>
    
    <section class="hero-section flex items-center justify-center p-4">
        <div class="content-container max-w-2xl mx-auto text-center">
            <span class="inline-block px-4 py-2 bg-gray-100 rounded-full text-sm font-medium text-gray-800 mb-6">Where we'll all be</span>
            
            <h1 class="text-5xl md:text-6xl font-bold mb-6">AndWeare.</h1>
            
            <p class="text-xl text-gray-600 mb-10">
                Create a private online space where your family can connect, share, and organize your life together - no matter how far apart you are.
            </p>
            
            <a href="/hub" class="inline-block px-8 py-4 bg-black text-white rounded-full hover:bg-gray-800 transition-colors text-center text-lg">
                Get Started
            </a>
            
            <div class="phone-cutoff mt-20">
                <div class="phone-frame">
                    <video autoplay loop muted playsinline class="phone-video">
                        <source src="253998_small.mp4" type="video/mp4">
                    </video>
                </div>
            </div>
        </div>
    </section>

    <div id="features" class="features-container">
        <section id="feature1" class="feature-section">
            <div class="max-w-6xl mx-auto px-4 md:px-8 w-full">
                <div class="grid md:grid-cols-2 gap-16 items-center">
                    <div class="feature-content">
                        <div class="feature-icon text-blue-500 bg-blue-100">
                            <i class="fas fa-users"></i>
                        </div>
                        <h2 class="text-3xl md:text-4xl font-bold mb-4">Connectez toute votre famille</h2>
                        <p class="text-lg text-gray-600">
                            Créez un espace privé où votre famille peut partager des moments précieux, 
                            des photos et des vidéos, en toute sécurité et de manière organisée.
                        </p>
                    </div>
                    <div class="phone-mobile">
                        <div class="phone-frame">
                            <div class="dynamic-island"></div>
                            <video autoplay loop muted playsinline class="phone-video">
                                <source src="253998_small.mp4" type="video/mp4">
                            </video>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section id="feature2" class="feature-section">
            <div class="max-w-6xl mx-auto px-4 md:px-8 w-full">
                <div class="grid md:grid-cols-2 gap-16 items-center">
                    <div class="feature-content">
                        <div class="feature-icon text-green-500 bg-green-100">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                        <h2 class="text-3xl md:text-4xl font-bold mb-4">Organisez votre vie ensemble</h2>
                        <p class="text-lg text-gray-600">
                            Partagez des calendriers, des listes de tâches et des rappels pour coordonner 
                            facilement les activités familiales et rester connectés à l'essentiel.
                        </p>
                    </div>
                    <div class="phone-mobile">
                        <div class="phone-frame">
                            <div class="dynamic-island"></div>
                            <video autoplay loop muted playsinline class="phone-video">
                                <source src="253998_small.mp4" type="video/mp4">
                            </video>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section id="feature3" class="feature-section">
            <div class="max-w-6xl mx-auto px-4 md:px-8 w-full">
                <div class="grid md:grid-cols-2 gap-16 items-center">
                    <div class="feature-content">
                        <div class="feature-icon text-purple-500 bg-purple-100">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <h2 class="text-3xl md:text-4xl font-bold mb-4">Sécurité et confidentialité</h2>
                        <p class="text-lg text-gray-600">
                            Gardez vos souvenirs familiaux protégés avec un chiffrement avancé et 
                            un contrôle total sur qui peut voir et partager votre contenu.
                        </p>
                    </div>
                    <div class="phone-mobile">
                        <div class="phone-frame">
                            <div class="dynamic-island"></div>
                            <video autoplay loop muted playsinline class="phone-video">
                                <source src="253998_small.mp4" type="video/mp4">
                            </video>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            gsap.registerPlugin(ScrollTrigger);
            
            const scrollPhone = document.getElementById('scrollPhone');
            const featureContents = document.querySelectorAll('.feature-content');
            const featureSections = document.querySelectorAll('.feature-section');
            
            if (window.innerWidth > 768) {
                gsap.set(scrollPhone, { opacity: 0, y: 50 });
                
                gsap.to(scrollPhone, {
                    opacity: 1,
                    y: 0,
                    duration: 0.8,
                    scrollTrigger: {
                        trigger: '.hero-section',
                        start: 'bottom 80%',
                        toggleActions: 'play none none reverse'
                    }
                });
                
                gsap.to(scrollPhone, {
                    scrollTrigger: {
                        trigger: '#features',
                        start: 'top top',
                        end: 'bottom bottom',
                        scrub: 1,
                        pin: scrollPhone,
                        pinSpacing: false
                    }
                });
                
                featureSections.forEach((section, index) => {
                    let tl = gsap.timeline({
                        scrollTrigger: {
                            trigger: section,
                            start: 'top 60%',
                            end: 'center 60%',
                            scrub: 1,
                            toggleActions: 'play none none reverse'
                        }
                    });
                    
                    tl.to(featureContents[index], {
                        opacity: 1,
                        y: 0,
                        duration: 0.8,
                        ease: 'power2.out'
                    });
                });
            } else {
                const mobilePhones = document.querySelectorAll('.phone-mobile');
                
                featureSections.forEach((section, index) => {
                    let tl = gsap.timeline({
                        scrollTrigger: {
                            trigger: section,
                            start: 'top 70%',
                            toggleActions: 'play none none reverse'
                        }
                    });
                    
                    tl.from(featureContents[index], {
                        opacity: 0,
                        y: 30,
                        duration: 0.6,
                        ease: 'power2.out'
                    });
                    
                    if (mobilePhones[index]) {
                        tl.from(mobilePhones[index], {
                            opacity: 0,
                            y: 30,
                            duration: 0.6,
                            ease: 'power2.out'
                        }, "-=0.3");
                    }
                });
            }
        });
    </script>
</body>
</html>