<?php
require_once 'config.php';

header('Content-Type: application/json');

// Gestion des likes/dislikes
if(isset($_POST['action']) && isset($_SESSION['user_id'])) {
    $action = $_POST['action'];
    $video_id = $_POST['video_id'];
    
    $stmt = $pdo->prepare("DELETE FROM interactions WHERE content_id = ? AND user_id = ? AND type IN ('like', 'dislike')");
    $stmt->execute([$video_id, $_SESSION['user_id']]);
    
    if($action !== 'remove') {
        $stmt = $pdo->prepare("INSERT INTO interactions (content_id, user_id, type) VALUES (?, ?, ?)");
        $stmt->execute([$video_id, $_SESSION['user_id'], $action]);
    }
    exit(json_encode(['success' => true]));
}

// Gestion des commentaires
if(isset($_POST['comment']) && isset($_SESSION['user_id'])) {
    $comment = $_POST['comment'];
    $video_id = $_POST['video_id'];
    
    $stmt = $pdo->prepare("INSERT INTO interactions (content_id, user_id, type, comment_text) VALUES (?, ?, 'comment', ?)");
    $stmt->execute([$video_id, $_SESSION['user_id'], $comment]);
    exit(json_encode(['success' => true]));
}

if(isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    
    // Ajouter une vue
    if(isset($_SESSION['user_id'])) {
        $stmt = $pdo->prepare("INSERT INTO interactions (content_id, user_id, type) VALUES (?, ?, 'view')");
        $stmt->execute([$id, $_SESSION['user_id']]);
    }

    // Récupérer les infos de la vidéo
    $stmt = $pdo->prepare("
        SELECT 
            c.*,
            u.username as author_name,
            COUNT(DISTINCT CASE WHEN i.type = 'view' THEN i.id END) as view_count,
            COUNT(DISTINCT CASE WHEN i.type = 'like' THEN i.id END) as like_count,
            COUNT(DISTINCT CASE WHEN i.type = 'dislike' THEN i.id END) as dislike_count
        FROM content c
        LEFT JOIN users u ON c.author_id = u.id
        LEFT JOIN interactions i ON c.id = i.content_id
        WHERE c.id = ?
        GROUP BY c.id
    ");
    $stmt->execute([$id]);
    $video = $stmt->fetch(PDO::FETCH_ASSOC);

    if($video) {
        // Vérifier l'interaction de l'utilisateur
        $userInteraction = null;
        if(isset($_SESSION['user_id'])) {
            $stmt = $pdo->prepare("
                SELECT type 
                FROM interactions 
                WHERE content_id = ? AND user_id = ? AND type IN ('like', 'dislike') 
                ORDER BY created_at DESC 
                LIMIT 1
            ");
            $stmt->execute([$id, $_SESSION['user_id']]);
            $userInteraction = $stmt->fetchColumn();
        }

        $response = [
            'id' => $video['id'],
            'name' => $video['name'],
            'description' => $video['description'],
            'url_video' => $video['url_video'],
            'picture_cover' => $video['picture_cover'],
            'tags' => $video['tags'],
            'time' => $video['time'],
            'author_name' => $video['author_name'],
            'author_id' => $video['author_id'],
            'view_count' => (int)$video['view_count'],
            'like_count' => (int)$video['like_count'],
            'dislike_count' => (int)$video['dislike_count'],
            'user_interaction' => $userInteraction,
            'created_at' => $video['created_at']
        ];

        echo json_encode($response);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Video not found']);
    }
}
?>