<?php
$section = isset($_GET['section']) ? $_GET['section'] : 'general';
$valid_sections = ['general', 'notifications', 'privacy', 'account'];

if (!in_array($section, $valid_sections)) {
    $section = 'general';
}

// Récupérer les données actuelles
if ($section === 'general' || $section === 'privacy') {
    $stmt = $db->prepare("SELECT * FROM family_sites WHERE id = ?");
    $stmt->execute([$family_id]);
    $family_settings = $stmt->fetch();
}

if ($section === 'notifications') {
    $stmt = $db->prepare("SELECT * FROM member_preferences WHERE user_id = ? AND family_id = ?");
    $stmt->execute([$user_id, $family_id]);
    $preferences = $stmt->fetch();
    
    if (!$preferences) {
        $preferences = [
            'email_events' => 1,
            'email_photos' => 1,
            'email_members' => 1
        ];
    }
}

// Traitement des formulaires
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($section === 'general' && $is_admin) {
        // Mise à jour des paramètres généraux
        $family_name = isset($_POST['family_name']) ? trim($_POST['family_name']) : '';
        $description = isset($_POST['description']) ? trim($_POST['description']) : '';
        $timezone = isset($_POST['timezone']) ? $_POST['timezone'] : 'UTC';
        
        if (!empty($family_name)) {
            $stmt = $db->prepare("UPDATE family_sites SET family_name = ?, description = ?, timezone = ? WHERE id = ?");
            $stmt->execute([$family_name, $description, $timezone, $family_id]);
            
            $success = "Family hub settings updated successfully!";
            
            // Mettre à jour les informations de la famille en mémoire
            $family['family_name'] = $family_name;
            $family['description'] = $description;
            $family['timezone'] = $timezone;
            $family_settings['family_name'] = $family_name;
            $family_settings['description'] = $description;
            $family_settings['timezone'] = $timezone;
        }
    } else if ($section === 'privacy' && $is_admin) {
        // Mise à jour des paramètres de confidentialité
        $content_access = isset($_POST['content_access']) ? $_POST['content_access'] : 'members_only';
        $photos_download = isset($_POST['photos_download']) ? 1 : 0;
        $search_engine_visibility = isset($_POST['search_engine_visibility']) ? 1 : 0;
        
        $stmt = $db->prepare("UPDATE family_sites SET content_access = ?, photos_download = ?, search_engine_visibility = ? WHERE id = ?");
        $stmt->execute([$content_access, $photos_download, $search_engine_visibility, $family_id]);
        
        $success = "Privacy settings updated successfully!";
        
        // Mettre à jour les informations de la famille en mémoire
        $family_settings['content_access'] = $content_access;
        $family_settings['photos_download'] = $photos_download;
        $family_settings['search_engine_visibility'] = $search_engine_visibility;
    } else if ($section === 'notifications') {
        // Mise à jour des préférences de notification
        $email_events = isset($_POST['email_events']) ? 1 : 0;
        $email_photos = isset($_POST['email_photos']) ? 1 : 0;
        $email_members = isset($_POST['email_members']) ? 1 : 0;
        
        $stmt = $db->prepare("
            INSERT INTO member_preferences (user_id, family_id, email_events, email_photos, email_members) 
            VALUES (?, ?, ?, ?, ?) 
            ON DUPLICATE KEY UPDATE email_events = ?, email_photos = ?, email_members = ?
        ");
        $stmt->execute([$user_id, $family_id, $email_events, $email_photos, $email_members, $email_events, $email_photos, $email_members]);
        
        $success = "Notification preferences updated successfully!";
        
        // Mettre à jour les préférences en mémoire
        $preferences['email_events'] = $email_events;
        $preferences['email_photos'] = $email_photos;
        $preferences['email_members'] = $email_members;
    } else if ($section === 'account') {
        // Mise à jour des paramètres du compte personnel
        $current_password = isset($_POST['current_password']) ? $_POST['current_password'] : '';
        $new_password = isset($_POST['new_password']) ? $_POST['new_password'] : '';
        $confirm_password = isset($_POST['confirm_password']) ? $_POST['confirm_password'] : '';
        
        if (!empty($current_password) && !empty($new_password)) {
            if ($new_password !== $confirm_password) {
                $error = "New passwords do not match.";
            } else if (strlen($new_password) < 8) {
                $error = "New password must be at least 8 characters long.";
            } else {
                // Vérifier le mot de passe actuel
                $stmt = $db->prepare("SELECT password FROM utilisateurs WHERE id = ?");
                $stmt->execute([$user_id]);
                $user_data = $stmt->fetch();
                
                if (password_verify($current_password, $user_data['password'])) {
                    $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                    
                    $stmt = $db->prepare("UPDATE utilisateurs SET password = ? WHERE id = ?");
                    $stmt->execute([$hashed_password, $user_id]);
                    
                    $success = "Password updated successfully!";
                } else {
                    $error = "Current password is incorrect.";
                }
            }
        } else if (!empty($current_password) || !empty($new_password) || !empty($confirm_password)) {
            $error = "Please fill in all password fields.";
        }
    }
}
?>

<div class="mb-6">
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Settings</h1>
    </div>
    
    <?php if (isset($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo htmlspecialchars($error); ?>
        </div>
    <?php endif; ?>
    
    <?php if (isset($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo htmlspecialchars($success); ?>
        </div>
    <?php endif; ?>
    
    <div class="bg-white shadow rounded-lg">
        <div class="md:flex">
            <!-- Navigation latérale -->
            <div class="md:w-64 bg-gray-50 rounded-l-lg p-6 border-r border-gray-200">
                <nav class="space-y-1">
                    <a href="?page=settings&section=general" class="<?php echo $section === 'general' ? 'bg-indigo-50 text-indigo-600' : 'text-gray-700 hover:text-indigo-600 hover:bg-gray-100'; ?> group flex items-center px-3 py-2 rounded-md">
                        <svg xmlns="http://www.w3.org/2000/svg" class="<?php echo $section === 'general' ? 'text-indigo-500' : 'text-gray-400 group-hover:text-indigo-500'; ?> flex-shrink-0 h-6 w-6 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                        General
                    </a>
                    
                    <a href="?page=settings&section=notifications" class="<?php echo $section === 'notifications' ? 'bg-indigo-50 text-indigo-600' : 'text-gray-700 hover:text-indigo-600 hover:bg-gray-100'; ?> group flex items-center px-3 py-2 rounded-md">
                        <svg xmlns="http://www.w3.org/2000/svg" class="<?php echo $section === 'notifications' ? 'text-indigo-500' : 'text-gray-400 group-hover:text-indigo-500'; ?> flex-shrink-0 h-6 w-6 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                        </svg>
                        Notifications
                    </a>
                    
                    <?php if ($is_admin): ?>
                        <a href="?page=settings&section=privacy" class="<?php echo $section === 'privacy' ? 'bg-indigo-50 text-indigo-600' : 'text-gray-700 hover:text-indigo-600 hover:bg-gray-100'; ?> group flex items-center px-3 py-2 rounded-md">
                            <svg xmlns="http://www.w3.org/2000/svg" class="<?php echo $section === 'privacy' ? 'text-indigo-500' : 'text-gray-400 group-hover:text-indigo-500'; ?> flex-shrink-0 h-6 w-6 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                            </svg>
                            Privacy
                        </a>
                    <?php endif; ?>
                    
                    <a href="?page=settings&section=account" class="<?php echo $section === 'account' ? 'bg-indigo-50 text-indigo-600' : 'text-gray-700 hover:text-indigo-600 hover:bg-gray-100'; ?> group flex items-center px-3 py-2 rounded-md">
                        <svg xmlns="http://www.w3.org/2000/svg" class="<?php echo $section === 'account' ? 'text-indigo-500' : 'text-gray-400 group-hover:text-indigo-500'; ?> flex-shrink-0 h-6 w-6 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                        </svg>
                        Account
                    </a>
                </nav>
            </div>
            
            <!-- Contenu principal -->
            <div class="p-6 flex-1">
                <?php if ($section === 'general'): ?>
                    <h2 class="text-lg font-bold mb-6">General Settings</h2>
                    
                    <?php if ($is_admin): ?>
                        <form method="POST" action="?page=settings&section=general">
                            <div class="mb-4">
                                <label for="family_name" class="block text-sm font-medium text-gray-700 mb-1">Family Hub Name</label>
                                <input type="text" id="family_name" name="family_name" required value="<?php echo htmlspecialchars($family_settings['family_name']); ?>" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            </div>
                            
                            <div class="mb-4">
                                <label for="description" class="block text-sm font-medium text-gray-700 mb-1">Description (optional)</label>
                                <textarea id="description" name="description" rows="3" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo htmlspecialchars($family_settings['description'] ?? ''); ?></textarea>
                                <p class="mt-1 text-xs text-gray-500">This description will appear on your family hub home page.</p>
                            </div>
                            
                            <div class="mb-6">
                                <label for="timezone" class="block text-sm font-medium text-gray-700 mb-1">Timezone</label>
                                <select id="timezone" name="timezone" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <?php
                                    $timezones = [
                                        'UTC' => 'UTC',
                                        'Europe/London' => 'London (GMT)',
                                        'Europe/Paris' => 'Paris, Berlin, Rome (CET)',
                                        'America/New_York' => 'New York (EST)',
                                        'America/Chicago' => 'Chicago (CST)',
                                        'America/Denver' => 'Denver (MST)',
                                        'America/Los_Angeles' => 'Los Angeles (PST)',
                                        'Asia/Tokyo' => 'Tokyo (JST)',
                                        'Asia/Shanghai' => 'Beijing, Hong Kong (CST)',
                                        'Australia/Sydney' => 'Sydney (AEST)'
                                    ];
                                    
                                    foreach ($timezones as $tz_value => $tz_label) {
                                        $selected = ($family_settings['timezone'] == $tz_value) ? 'selected' : '';
                                        echo "<option value=\"{$tz_value}\" {$selected}>{$tz_label}</option>";
                                    }
                                    ?>
                                </select>
                                <p class="mt-1 text-xs text-gray-500">This timezone will be used for all dates and times on your family hub.</p>
                            </div>
                            
                            <div class="border-t border-gray-200 pt-6">
                                <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition">Save Changes</button>
                            </div>
                        </form>
                    <?php else: ?>
                        <div class="mb-4">
                            <h3 class="text-sm font-medium text-gray-700 mb-1">Family Hub Name</h3>
                            <p class="text-gray-900"><?php echo htmlspecialchars($family_settings['family_name']); ?></p>
                        </div>
                        
                        <?php if (!empty($family_settings['description'])): ?>
                            <div class="mb-4">
                                <h3 class="text-sm font-medium text-gray-700 mb-1">Description</h3>
                                <p class="text-gray-900"><?php echo nl2br(htmlspecialchars($family_settings['description'])); ?></p>
                            </div>
                        <?php endif; ?>
                        
                        <div class="mb-4">
                            <h3 class="text-sm font-medium text-gray-700 mb-1">Timezone</h3>
                            <p class="text-gray-900">
                                <?php 
                                $timezones = [
                                    'UTC' => 'UTC',
                                    'Europe/London' => 'London (GMT)',
                                    'Europe/Paris' => 'Paris, Berlin, Rome (CET)',
                                    'America/New_York' => 'New York (EST)',
                                    'America/Chicago' => 'Chicago (CST)',
                                    'America/Denver' => 'Denver (MST)',
                                    'America/Los_Angeles' => 'Los Angeles (PST)',
                                    'Asia/Tokyo' => 'Tokyo (JST)',
                                    'Asia/Shanghai' => 'Beijing, Hong Kong (CST)',
                                    'Australia/Sydney' => 'Sydney (AEST)'
                                ];
                                echo $timezones[$family_settings['timezone']] ?? $family_settings['timezone'];
                                ?>
                            </p>
                        </div>
                        
                        <div class="rounded-lg bg-yellow-50 p-4 text-sm">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <h3 class="font-medium text-yellow-800">Admin access required</h3>
                                    <p class="mt-2 text-yellow-700">
                                        Only family administrators can change these settings. Please contact an admin if you need changes.
                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                <?php elseif ($section === 'notifications'): ?>
                    <h2 class="text-lg font-bold mb-6">Notification Preferences</h2>
                    
                    <form method="POST" action="?page=settings&section=notifications">
                        <div class="space-y-4">
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="email_events" name="email_events" type="checkbox" <?php echo (!empty($preferences['email_events'])) ? 'checked' : ''; ?> class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="email_events" class="font-medium text-gray-700">Calendar events</label>
                                    <p class="text-gray-500">Receive email notifications when new events are added or existing events are updated.</p>
                                </div>
                            </div>
                            
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="email_photos" name="email_photos" type="checkbox" <?php echo (!empty($preferences['email_photos'])) ? 'checked' : ''; ?> class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="email_photos" class="font-medium text-gray-700">New photos</label>
                                    <p class="text-gray-500">Receive email notifications when new photos are uploaded to the family hub.</p>
                                </div>
                            </div>
                            
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="email_members" name="email_members" type="checkbox" <?php echo (!empty($preferences['email_members'])) ? 'checked' : ''; ?> class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="email_members" class="font-medium text-gray-700">Member updates</label>
                                    <p class="text-gray-500">Receive email notifications when new members join or existing members leave the family hub.</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="border-t border-gray-200 pt-6 mt-6">
                            <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition">Save Preferences</button>
                        </div>
                    </form>
                
                <?php elseif ($section === 'privacy' && $is_admin): ?>
                    <h2 class="text-lg font-bold mb-6">Privacy Settings</h2>
                    
                    <form method="POST" action="?page=settings&section=privacy">
                        <div class="mb-6">
                            <label for="content_access" class="block text-sm font-medium text-gray-700 mb-1">Content Access</label>
                            <select id="content_access" name="content_access" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <option value="members_only" <?php echo ($family_settings['content_access'] === 'members_only') ? 'selected' : ''; ?>>Members Only</option>
                                <option value="password" <?php echo ($family_settings['content_access'] === 'password') ? 'selected' : ''; ?>>Password Protected</option>
                                <option value="public" <?php echo ($family_settings['content_access'] === 'public') ? 'selected' : ''; ?>>Public</option>
                            </select>
                            <p class="mt-1 text-xs text-gray-500">Control who can access your family hub content.</p>
                        </div>
                        
                        <div class="space-y-4 mb-6">
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="photos_download" name="photos_download" type="checkbox" <?php echo (!empty($family_settings['photos_download'])) ? 'checked' : ''; ?> class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="photos_download" class="font-medium text-gray-700">Allow photo downloads</label>
                                    <p class="text-gray-500">Allow family members to download photos from the gallery.</p>
                                </div>
                            </div>
                            
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="search_engine_visibility" name="search_engine_visibility" type="checkbox" <?php echo (!empty($family_settings['search_engine_visibility'])) ? 'checked' : ''; ?> class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="search_engine_visibility" class="font-medium text-gray-700">Search engine visibility</label>
                                    <p class="text-gray-500">Allow search engines to index your family hub. If disabled, your hub won't appear in search results.</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="border-t border-gray-200 pt-6">
                            <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition">Save Privacy Settings</button>
                        </div>
                    </form>
                
                <?php elseif ($section === 'account'): ?>
                    <h2 class="text-lg font-bold mb-6">Account Settings</h2>
                    
                    <div class="mb-6">
                        <h3 class="text-md font-medium mb-4">Change Password</h3>
                        
                        <form method="POST" action="?page=settings&section=account">
                            <div class="mb-4">
                                <label for="current_password" class="block text-sm font-medium text-gray-700 mb-1">Current Password</label>
                                <input type="password" id="current_password" name="current_password" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            </div>
                            
                            <div class="mb-4">
                                <label for="new_password" class="block text-sm font-medium text-gray-700 mb-1">New Password</label>
                                <input type="password" id="new_password" name="new_password" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <p class="mt-1 text-xs text-gray-500">Must be at least 8 characters long.</p>
                            </div>
                            
                            <div class="mb-6">
                                <label for="confirm_password" class="block text-sm font-medium text-gray-700 mb-1">Confirm New Password</label>
                                <input type="password" id="confirm_password" name="confirm_password" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            </div>
                            
                            <div>
                                <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition">Update Password</button>
                            </div>
                        </form>
                    </div>
                    
                    <div class="mt-8 pt-8 border-t border-gray-200">
                        <h3 class="text-md font-medium mb-4 text-red-600">Danger Zone</h3>
                        
                        <p class="text-sm text-gray-600 mb-4">
                            If you wish to leave this family hub, please contact an administrator. 
                            Note that this action cannot be undone and you will lose access to all family content.
                        </p>
                        
                        <a href="?page=members" class="text-sm text-indigo-600 hover:text-indigo-500">
                            View family members to contact an admin
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>