<?php
require_once '../search/db.php';
session_start();

// Vérification de la connexion
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Récupération des infos utilisateur
$user_id = $_SESSION['user_id'];
$query = "SELECT * FROM users WHERE id = :id";
$stmt = $db->prepare($query);
$stmt->execute([':id' => $user_id]);
$user = $stmt->fetch();

// Comptage des documents et notes
$docs_query = "SELECT COUNT(*) FROM user_documents WHERE user_id = :user_id";
$stmt = $db->prepare($docs_query);
$stmt->execute([':user_id' => $user_id]);
$docs_count = $stmt->fetchColumn();

$notes_query = "SELECT COUNT(*) FROM user_notes WHERE user_id = :user_id";
$stmt = $db->prepare($notes_query);
$stmt->execute([':user_id' => $user_id]);
$notes_count = $stmt->fetchColumn();

// Pour les rédacteurs, compte des articles
$articles_count = 0;
if ($user['role'] === 'writer') {
    $articles_query = "SELECT COUNT(*) FROM data_article WHERE author = :author";
    $stmt = $db->prepare($articles_query);
    $stmt->execute([':author' => $user['first_name'] . ' ' . $user['last_name']]);
    $articles_count = $stmt->fetchColumn();
}
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Peerkinton</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://api.fontshare.com/v2/css?f[]=satoshi@400,500,700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Satoshi', sans-serif;
            background: #fafafa;
        }

        .nav-link {
            transition: all 0.2s ease;
        }

        .nav-link:hover {
            background-color: rgba(0, 0, 0, 0.05);
        }

        .nav-link.active {
            background-color: #f3f4f6;
            color: #111827;
        }

        .dashboard-card {
            transition: all 0.3s ease;
        }

        .dashboard-card:hover {
            transform: translateY(-2px);
        }
    </style>
</head>
<body class="h-full">
    <?php include '../header.php'; ?>

    <div class="flex min-h-screen pt-20">
        <!-- Sidebar -->
        <aside class="w-64 border-r border-gray-200 px-4 py-6">
            <nav class="space-y-2">
                <a href="dashboard.php" class="nav-link active flex items-center px-4 py-2 text-sm text-gray-600 rounded-lg">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                    </svg>
                    Dashboard
                </a>
                <a href="dashboard-files.php" class="nav-link flex items-center px-4 py-2 text-sm text-gray-600 rounded-lg">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"/>
                    </svg>
                    Casier membre
                </a>
                <a href="dashboard-profile.php" class="nav-link flex items-center px-4 py-2 text-sm text-gray-600 rounded-lg">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                    Profil
                </a>
                <?php if ($user['role'] === 'writer'): ?>
                <a href="dashboard-write.php" class="nav-link flex items-center px-4 py-2 text-sm text-gray-600 rounded-lg">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                    </svg>
                    Editorial
                </a>
                <?php endif; ?>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 px-8 py-6">
            <!-- Welcome Section -->
            <div class="mb-8">
                <h1 class="text-2xl font-medium text-gray-900">
                    Welcome back, <?php echo htmlspecialchars($user['first_name']); ?>
                </h1>
                <p class="mt-1 text-gray-600">Here's an overview of your account</p>
            </div>

            <!-- Stats Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                <!-- Documents Stats -->
                <div class="dashboard-card bg-white rounded-xl p-6 border border-gray-200">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-blue-50">
                            <svg class="w-6 h-6 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                        </div>
                        <div class="ml-4">
                            <h2 class="text-lg font-medium text-gray-900"><?php echo $docs_count; ?></h2>
                            <p class="text-gray-600">Documents</p>
                        </div>
                    </div>
                </div>

                <!-- Notes Stats -->
                <div class="dashboard-card bg-white rounded-xl p-6 border border-gray-200">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-green-50">
                            <svg class="w-6 h-6 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                            </svg>
                        </div>
                        <div class="ml-4">
                            <h2 class="text-lg font-medium text-gray-900"><?php echo $notes_count; ?></h2>
                            <p class="text-gray-600">Notes</p>
                        </div>
                    </div>
                </div>

                <?php if ($user['role'] === 'writer'): ?>
                <!-- Articles Stats -->
                <div class="dashboard-card bg-white rounded-xl p-6 border border-gray-200">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-purple-50">
                            <svg class="w-6 h-6 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9.5a2.5 2.5 0 00-2.5-2.5H15"/>
                            </svg>
                        </div>
                        <div class="ml-4">
                            <h2 class="text-lg font-medium text-gray-900"><?php echo $articles_count; ?></h2>
                            <p class="text-gray-600">Articles publiés</p>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- Recent Activity -->
            <div class="bg-white rounded-xl p-6 border border-gray-200">
                <h2 class="text-lg font-medium text-gray-900 mb-4">Recent Activity</h2>
                <div class="space-y-4">
                    <?php
                    // Get recent documents
                    $recent_query = "SELECT 'document' as type, filename as name, created_at 
                                   FROM user_documents 
                                   WHERE user_id = :user_id
                                   UNION ALL
                                   SELECT 'note' as type, title as name, created_at 
                                   FROM user_notes 
                                   WHERE user_id = :user_id
                                   ORDER BY created_at DESC 
                                   LIMIT 5";
                    $stmt = $db->prepare($recent_query);
                    $stmt->execute([':user_id' => $user_id]);
                    $recent_items = $stmt->fetchAll();

                    foreach ($recent_items as $item):
                        $icon_class = $item['type'] === 'document' ? 'text-blue-500' : 'text-green-500';
                    ?>
                        <div class="flex items-center">
                            <div class="p-2 rounded-full <?php echo $item['type'] === 'document' ? 'bg-blue-50' : 'bg-green-50'; ?>">
                                <svg class="w-5 h-5 <?php echo $icon_class; ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <?php if ($item['type'] === 'document'): ?>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                    <?php else: ?>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                    <?php endif; ?>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-900">
                                    <?php echo htmlspecialchars($item['name']); ?>
                                </p>
                                <p class="text-sm text-gray-500">
                                    <?php echo date('j M Y, H:i', strtotime($item['created_at'])); ?>
                                </p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </main>
    </div>
</body>
</html>