<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Izhak | Portfolio</title>
    <link href="https://fonts.googleapis.com/css2?family=Assistant:wght@300;400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Assistant', 'ui-sans-serif', 'system-ui']
                    }
                }
            }
        }
    </script>
    <style>
        :root {
            --bg-primary: #ffffff;
            --text-primary: #000000;
            --bg-secondary: #f4f4f4;
            --text-secondary: #333333;
        }
        @media (prefers-color-scheme: dark) {
            :root {
                --bg-primary: #121212;
                --text-primary: #ffffff;
                --bg-secondary: #1e1e1e;
                --text-secondary: #cccccc;
            }
        }
        body {
            background-color: var(--bg-primary);
            color: var(--text-primary);
            transition: background-color 0.3s, color 0.3s;
        }
        .grid-bg {
            background-image: 
                linear-gradient(to right, rgba(0,0,0,0.05) 1px, transparent 1px),
                linear-gradient(to bottom, rgba(0,0,0,0.05) 1px, transparent 1px);
            background-size: 30px 30px;
        }
        .dark .grid-bg {
            background-image: 
                linear-gradient(to right, rgba(255,255,255,0.05) 1px, transparent 1px),
                linear-gradient(to bottom, rgba(255,255,255,0.05) 1px, transparent 1px);
        }
        .section-marker {
            position: fixed;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            display: flex;
            flex-direction: column;
            gap: 10px;
            z-index: 50;
        }
        .section-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background-color: rgba(128, 128, 128, 0.3);
            transition: all 0.3s ease;
        }
        .section-dot.active {
            width: 12px;
            height: 12px;
            background-color: var(--text-primary);
        }
        .project-card {
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(0,0,0,0.05);
            transition: transform 0.3s, box-shadow 0.3s;
        }
        .project-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);
        }
        .reveal {
            opacity: 0;
            transform: translateY(20px);
            transition: opacity 0.6s, transform 0.6s;
        }
        .reveal.active {
            opacity: 1;
            transform: translateY(0);
        }
    </style>
</head>
<body class="font-sans grid-bg">
    <div class="section-marker">
        <div class="section-dot" data-section="hero"></div>
        <div class="section-dot" data-section="skills"></div>
        <div class="section-dot" data-section="projects"></div>
        <div class="section-dot" data-section="musicians"></div>
        <div class="section-dot" data-section="movies"></div>
    </div>

    <div class="container mx-auto px-4 max-w-5xl">
        <section id="hero" class="min-h-screen flex items-center relative py-16">
            <div class="space-y-6 reveal">
                <p class="text-lg text-gray-600 mb-2 tracking-wider uppercase">Izhak Imators</p>
                <h1 class="text-6xl mb-4 tracking-tight leading-tight">
                    Digital Architect <br>Building Innovative Solutions
                </h1>
                <p class="text-xl max-w-2xl mb-8 text-gray-700">
                    Transforming complex challenges into elegant, user-centric digital experiences through strategic design and cutting-edge technology.
                </p>
                <div class="h-0.5 bg-black opacity-20 w-24"></div>
            </div>
        </section>

        <section id="skills" class="py-16">
            <h2 class="text-4xl mb-8 reveal">Technical Expertise</h2>
            <div class="grid md:grid-cols-2 gap-4">
                <div class="bg-white dark:bg-[#1e1e1e] p-5 rounded-lg shadow-sm reveal delay-100">
                    <h3 class="text-xl mb-2">Web Technologies</h3>
                    <p>HTML, CSS, PHP, JavaScript</p>
                </div>
                <div class="bg-white dark:bg-[#1e1e1e] p-5 rounded-lg shadow-sm reveal delay-200">
                    <h3 class="text-xl mb-2">Design & Development</h3>
                    <p>Responsive Design, UI/UX Principles</p>
                </div>
            </div>
        </section>

        <section id="projects" class="py-16">
            <h2 class="text-4xl mb-8 reveal">Selected Projects</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="project-card bg-white dark:bg-[#1e1e1e] p-6 rounded-lg reveal">
                    <h3 class="text-2xl mb-3">Web Platform</h3>
                    <p class="text-gray-600 dark:text-gray-400 mb-4">Comprehensive web solution with integrated services.</p>
                    <div class="flex justify-between items-center">
                        <span class="text-sm bg-gray-100 dark:bg-gray-800 px-3 py-1 rounded">PHP, JavaScript</span>
                        <a href="#" class="text-blue-600 hover:underline">View Project</a>
                    </div>
                </div>
                <div class="project-card bg-white dark:bg-[#1e1e1e] p-6 rounded-lg reveal delay-100">
                    <h3 class="text-2xl mb-3">Mobile Application</h3>
                    <p class="text-gray-600 dark:text-gray-400 mb-4">User-centric mobile app with intuitive design.</p>
                    <div class="flex justify-between items-center">
                        <span class="text-sm bg-gray-100 dark:bg-gray-800 px-3 py-1 rounded">JavaScript</span>
                        <a href="#" class="text-blue-600 hover:underline">View Project</a>
                    </div>
                </div>
                <div class="project-card bg-white dark:bg-[#1e1e1e] p-6 rounded-lg reveal delay-200">
                    <h3 class="text-2xl mb-3">E-commerce Platform</h3>
                    <p class="text-gray-600 dark:text-gray-400 mb-4">Scalable solution with secure payment integration.</p>
                    <div class="flex justify-between items-center">
                        <span class="text-sm bg-gray-100 dark:bg-gray-800 px-3 py-1 rounded">PHP, HTML</span>
                        <a href="#" class="text-blue-600 hover:underline">View Project</a>
                    </div>
                </div>
            </div>
        </section>

        <section id="musicians" class="py-16">
            <h2 class="text-4xl mb-8 reveal">Music Inspiration</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="bg-white dark:bg-[#1e1e1e] rounded-lg overflow-hidden reveal">
                    <img src="/api/placeholder/400/300" alt="Musician" class="w-full h-48 object-cover">
                    <div class="p-4">
                        <h3 class="text-xl mb-2">Artist Name</h3>
                        <a href="#" class="text-blue-600 hover:underline">Apple Music</a>
                    </div>
                </div>
            </div>
        </section>

        <section id="movies" class="py-16">
            <h2 class="text-4xl mb-8 reveal">Cinematic Favorites</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="bg-white dark:bg-[#1e1e1e] rounded-lg overflow-hidden reveal">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full h-[450px] object-cover">
                    <div class="p-4">
                        <h3 class="text-xl mb-2">Movie Title</h3>
                        <a href="#" class="text-blue-600 hover:underline">Streaming Platform</a>
                    </div>
                </div>
                <div class="bg-white dark:bg-[#1e1e1e] rounded-lg overflow-hidden reveal delay-100">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full h-[450px] object-cover">
                    <div class="p-4">
                        <h3 class="text-xl mb-2">Movie Title</h3>
                        <a href="#" class="text-blue-600 hover:underline">Streaming Platform</a>
                    </div>
                </div>
                <div class="bg-white dark:bg-[#1e1e1e] rounded-lg overflow-hidden reveal delay-200">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full h-[450px] object-cover">
                    <div class="p-4">
                        <h3 class="text-xl mb-2">Movie Title</h3>
                        <a href="#" class="text-blue-600 hover:underline">Streaming Platform</a>
                    </div>
                </div>
            </div>
        </section>

        <footer class="py-8 text-center border-t border-gray-100 dark:border-gray-800">
            <p class="text-gray-600 dark:text-gray-400">&copy; 2024 Izhak. All rights reserved.</p>
        </footer>
    </div>

    <script>
        // Section marker and reveal animations
        document.addEventListener('scroll', function() {
            const sections = document.querySelectorAll('section');
            const dots = document.querySelectorAll('.section-dot');
            const revealElements = document.querySelectorAll('.reveal');
            
            sections.forEach((section, index) => {
                const rect = section.getBoundingClientRect();
                if (rect.top <= window.innerHeight / 2 && rect.bottom >= window.innerHeight / 2) {
                    dots.forEach(dot => dot.classList.remove('active'));
                    dots[index].classList.add('active');
                }
            });

            revealElements.forEach(element => {
                const elementTop = element.getBoundingClientRect().top;
                const elementBottom = element.getBoundingClientRect().bottom;
                
                if (elementTop < window.innerHeight && elementBottom >= 0) {
                    element.classList.add('active');
                }
            });
        });

        // Activate first dot on page load
        document.querySelector('.section-dot').classList.add('active');
    </script>
</body>
</html>