<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Izhak | Portfolio</title>
    <link href="https://fonts.googleapis.com/css2?family=Assistant:wght@300;400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Assistant', 'ui-sans-serif', 'system-ui']
                    }
                }
            }
        }
    </script>
    <style>
        @keyframes blurAppear {
            from { opacity: 0; filter: blur(10px); }
            to { opacity: 1; filter: blur(0); }
        }
        .blur-appear { 
            animation: blurAppear 1s ease-out forwards; 
            opacity: 0;
        }
        .fade-slide-in {
            animation: fadeSlideIn 0.8s ease-out forwards;
            opacity: 0;
            transform: translateY(20px);
        }
        @keyframes fadeSlideIn {
            to { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
        body {
            background-color: white;
            color: black;
        }
        @media (prefers-color-scheme: dark) {
            body {
                background-color: black;
                color: white;
            }
        }
        .section-indicator {
            position: fixed;
            left: 30px;
            top: 50%;
            transform: translateY(-50%);
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        .section-dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background-color: rgba(128, 128, 128, 0.5);
            transition: all 0.3s ease;
        }
        .section-dot.active {
            background-color: black;
            width: 15px;
            height: 15px;
        }
        @media (max-width: 768px) {
            .section-indicator {
                display: none;
            }
        }
    </style>
</head>
<body class="font-sans">
    <div class="section-indicator">
        <div class="section-dot" data-section="hero"></div>
        <div class="section-dot" data-section="skills"></div>
        <div class="section-dot" data-section="projects"></div>
        <div class="section-dot" data-section="musicians"></div>
        <div class="section-dot" data-section="movies"></div>
    </div>

    <div class="container mx-auto px-4">
        <!-- Section Hero -->
        <section id="hero" class="min-h-screen flex items-center relative">
            <div class="space-y-6">
                <div class="blur-appear">
                    <p class="text-lg text-gray-600 mb-2">Hello, I am</p>
                    <h1 class="text-5xl mb-4">Izhak</h1>
                    <p class="text-xl max-w-2xl mb-6">
                        CEO of Imators, passionate developer creating innovative digital experiences.
                    </p>
                </div>
                <div class="h-1 bg-black dark:bg-white w-full"></div>
            </div>
        </section>

        <!-- Competences Section -->
        <section id="skills" class="py-16">
            <h2 class="text-4xl text-left mb-8">My Skills</h2>
            <div class="space-y-4">
                <div class="fade-slide-in delay-100">HTML</div>
                <div class="fade-slide-in delay-200">PHP</div>
                <div class="fade-slide-in delay-300">JavaScript</div>
                <div class="fade-slide-in delay-400">CSS</div>
            </div>
        </section>

        <!-- Projects Section -->
        <section id="projects" class="py-16">
            <h2 class="text-4xl mb-8">Accomplished Projects</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="border p-6">
                    <h3 class="text-2xl mb-4">Project Name</h3>
                    <p class="mb-4">Project description</p>
                    <p class="mb-4">Language: HTML, PHP</p>
                    <a href="#" class="text-blue-600">Project Link</a>
                </div>
            </div>
        </section>

        <!-- Favourite Musicians Section -->
        <section id="musicians" class="py-16">
            <h2 class="text-4xl mb-8">Favourite Musicians</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="relative">
                    <img src="/api/placeholder/400/300" alt="Musician" class="w-full object-cover md:h-64 h-48">
                    <div class="mt-4">
                        <h3 class="text-2xl">Artist Name</h3>
                        <a href="#" class="text-blue-600">Apple Music</a>
                    </div>
                </div>
            </div>
        </section>

        <!-- Favourite Movies Section -->
        <section id="movies" class="py-16">
            <h2 class="text-4xl mb-8">Favourite Movies</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="flex flex-col items-center">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full max-w-[300px] h-[450px] object-cover mb-4">
                    <h3 class="text-2xl mb-2">Movie Title</h3>
                    <a href="#" class="text-blue-600">Streaming Platform</a>
                </div>
                <div class="flex flex-col items-center">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full max-w-[300px] h-[450px] object-cover mb-4">
                    <h3 class="text-2xl mb-2">Movie Title</h3>
                    <a href="#" class="text-blue-600">Streaming Platform</a>
                </div>
                <div class="flex flex-col items-center">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full max-w-[300px] h-[450px] object-cover mb-4">
                    <h3 class="text-2xl mb-2">Movie Title</h3>
                    <a href="#" class="text-blue-600">Streaming Platform</a>
                </div>
            </div>
        </section>

        <!-- Footer -->
        <footer class="py-8 text-center">
            <p>&copy; 2024 Izhak. All rights reserved.</p>
        </footer>
    </div>

    <script>
        document.addEventListener('scroll', function() {
            const sections = document.querySelectorAll('section');
            const dots = document.querySelectorAll('.section-dot');
            
            sections.forEach((section, index) => {
                const rect = section.getBoundingClientRect();
                if (rect.top <= window.innerHeight / 2 && rect.bottom >= window.innerHeight / 2) {
                    dots.forEach(dot => dot.classList.remove('active'));
                    dots[index].classList.add('active');
                }
            });
        });

        // Activate first dot on page load
        document.querySelector('.section-dot').classList.add('active');
    </script>
</body>
</html>