<?php
require_once '../includes/db.php';
require_once '../includes/functions.php';

require_login();

$error = null;
$success = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['target_user_id'])) {
    $target_user_id = $_POST['target_user_id'];
    
    if ($target_user_id == $_SESSION['user_id']) {
        $error = "Tu ne peux pas former une alliance avec toi-même.";
    } else {
        $existing = db_get_one(
            "SELECT * FROM alliances 
             WHERE (user1_id = ? AND user2_id = ?) OR (user1_id = ? AND user2_id = ?)",
            [$_SESSION['user_id'], $target_user_id, $target_user_id, $_SESSION['user_id']]
        );
        
        if ($existing) {
            if ($existing['status'] === 'pending' && $existing['user1_id'] == $_SESSION['user_id']) {
                $error = "Tu as déjà envoyé une demande d'alliance à cet agent.";
            } elseif ($existing['status'] === 'pending' && $existing['user2_id'] == $_SESSION['user_id']) {
                $error = "Cet agent t'a déjà envoyé une demande d'alliance. Vérifie tes communications.";
            } elseif ($existing['status'] === 'active') {
                $error = "Tu es déjà allié avec cet agent.";
            } elseif ($existing['status'] === 'rejected') {
                $data = [
                    'status' => 'pending',
                    'created_at' => date('Y-m-d H:i:s')
                ];
                
                db_update('alliances', $data, 'id = ?', [$existing['id']]);
                $success = "Demande d'alliance envoyée.";
            } elseif ($existing['status'] === 'blocked') {
                $error = "Tu ne peux pas demander une alliance à cet agent.";
            }
        } else {
            $data = [
                'user1_id' => $_SESSION['user_id'],
                'user2_id' => $target_user_id,
                'status' => 'pending',
                'created_at' => date('Y-m-d H:i:s')
            ];
            
            db_insert('alliances', $data);
            $success = "Demande d'alliance envoyée.";
        }
    }
}

header('Location: communication.php?tab=nearby' . ($error ? '&error=' . urlencode($error) : '') . ($success ? '&success=' . urlencode($success) : ''));
exit;
?>