<?php
session_start();
require_once 'db.php';

function checkLogin() {
    if (!isset($_SESSION['user_id'])) {
        header("Location: login.php");
        exit();
    }
}

function logActivity($action, $details = '') {
    global $db;
    
    // Vérifier si l'utilisateur existe avant d'ajouter son ID
    $userId = null;
    if (isset($_SESSION['user_id'])) {
        $checkUser = $db->prepare("SELECT id FROM users WHERE id = ?");
        $checkUser->execute([$_SESSION['user_id']]);
        if ($checkUser->rowCount() > 0) {
            $userId = $_SESSION['user_id'];
        }
    }
    
    $stmt = $db->prepare("INSERT INTO activity_logs (user_id, action, details, ip_address, created_at) VALUES (?, ?, ?, ?, NOW())");
    $stmt->execute([$userId, $action, $details, $_SERVER['REMOTE_ADDR']]);
}

function getProfiles($search = '') {
    global $db;
    
    $query = "SELECT * FROM profiles WHERE 1=1";
    $params = [];
    
    if (!empty($search)) {
        $query .= " AND (full_name LIKE ? OR email LIKE ? OR phone LIKE ? OR address LIKE ? OR notes LIKE ?)";
        $searchTerm = "%$search%";
        $params = [$searchTerm, $searchTerm, $searchTerm, $searchTerm, $searchTerm];
    }
    
    $query .= " ORDER BY updated_at DESC";
    
    $stmt = $db->prepare($query);
    $stmt->execute($params);
    return $stmt->fetchAll();
}

function getProfile($id) {
    global $db;
    $stmt = $db->prepare("SELECT * FROM profiles WHERE id = ?");
    $stmt->execute([$id]);
    return $stmt->fetch();
}

function createProfile($data) {
    global $db;
    
    $stmt = $db->prepare("INSERT INTO profiles (full_name, email, phone, address, birth_date, occupation, notes, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
    
    $stmt->execute([
        $data['full_name'],
        $data['email'],
        $data['phone'],
        $data['address'],
        $data['birth_date'],
        $data['occupation'],
        $data['notes']
    ]);
    
    $profileId = $db->lastInsertId();
    logActivity('create_profile', "Profil créé: ID #$profileId, Nom: {$data['full_name']}");
    
    return $profileId;
}

function updateProfile($id, $data) {
    global $db;
    
    $stmt = $db->prepare("UPDATE profiles SET full_name = ?, email = ?, phone = ?, address = ?, birth_date = ?, occupation = ?, notes = ?, updated_at = NOW() WHERE id = ?");
    
    $stmt->execute([
        $data['full_name'],
        $data['email'],
        $data['phone'],
        $data['address'],
        $data['birth_date'],
        $data['occupation'],
        $data['notes'],
        $id
    ]);
    
    logActivity('update_profile', "Profil mis à jour: ID #$id, Nom: {$data['full_name']}");
    
    return true;
}

function deleteProfile($id) {
    global $db;
    
    $profile = getProfile($id);
    if (!$profile) {
        return false;
    }
    
    $stmt = $db->prepare("DELETE FROM profiles WHERE id = ?");
    $stmt->execute([$id]);
    
    logActivity('delete_profile', "Profil supprimé: ID #$id, Nom: {$profile['full_name']}");
    
    return true;
}

function getSystemInfo() {
    $creationDate = '2025-03-07'; // Date de création du système
    
    $logFile = __DIR__ . '/logs/updates.log';
    $updateLogs = [];
    
    if (file_exists($logFile)) {
        $updateLogs = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    }
    
    return [
        'name' => 'Peerkinton',
        'version' => '1.0',
        'creation_date' => $creationDate,
        'update_logs' => $updateLogs
    ];
}