<?php
// Assurez-vous que la session est démarrée
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Si l'utilisateur est connecté, récupérer ses informations
$user = null;
if (isset($_SESSION['user_id']) && isset($db)) {
    try {
        $user_query = "SELECT first_name, last_name, role FROM users WHERE id = :user_id";
        $user_stmt = $db->prepare($user_query);
        $user_stmt->execute([':user_id' => $_SESSION['user_id']]);
        $user = $user_stmt->fetch();
    } catch (Exception $e) {
        // Gérer silencieusement l'erreur
    }
}
?>

<header class="fixed w-full top-0 z-50">
    <div class="nav-container">
        <div class="max-w-6xl mx-auto px-6">
            <nav class="flex items-center justify-between h-20">
                <a href="/" class="text-xl font-medium tracking-tight text-gray-900">Peerkinton</a>
                
                <div class="hidden lg:flex items-center space-x-10">                        
                    <a href="/search/data" class="nav-link text-gray-600 text-sm">Search Data</a>
                    <a href="/search/profile" class="nav-link text-gray-600 text-sm">Search Profile</a>
                    <a href="/about" class="nav-link text-gray-600 text-sm">Enterprise</a>
                </div>

                <div class="hidden lg:flex items-center space-x-8">
                    <?php if (isset($_SESSION['user_id'])): ?>
                        <div class="relative dropdown-trigger">
                            <div class="flex items-center space-x-2 cursor-pointer text-sm text-gray-600 hover:text-gray-900">
                                <span>
                                    <?php 
                                    if (isset($user['first_name'])) {
                                        echo htmlspecialchars($user['first_name']);
                                    } else {
                                        echo htmlspecialchars($_SESSION['username'] ?? 'Member');
                                    }
                                    ?>
                                </span>
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </div>
                            <div class="dropdown-menu">
                                <a href="/dashboard.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Dashboard</a>
                                <a href="/dashboard-files.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Member records</a>
                                <a href="/dashboard-profile.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Profile</a>
                                <?php if (isset($user['role']) && $user['role'] === 'writer'): ?>
                                <a href="/dashboard-write.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Editorial</a>
                                <?php endif; ?>
                                <div class="border-t border-gray-100"></div>
                                <a href="/logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">Logout</a>
                            </div>
                        </div>
                    <?php else: ?>
                        <a href="/login.php" class="text-gray-600 text-sm hover:text-gray-900">Sign in</a>
                        <a href="/signup.php" class="primary-button bg-gray-900 px-6 py-2 text-sm text-white rounded-full">
                            Become a member of the academy
                        </a>
                    <?php endif; ?>
                </div>

                <button id="menu-toggle" class="lg:hidden p-2">
                    <svg class="w-6 h-6 text-gray-900" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 8h16M4 16h16"/>
                    </svg>
                </button>
            </nav>
        </div>
    </div>

    <div id="mobile-menu" class="mobile-menu lg:hidden fixed inset-0 z-50">
        <div class="container mx-auto px-6 py-8 h-full flex flex-col">
            <div class="flex justify-end">
                <button id="close-menu" class="p-2">
                    <svg class="w-6 h-6 text-gray-900" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>
            </div>
            
            <div class="flex flex-col items-center justify-center flex-1 space-y-8">
                <a href="/search/data" class="text-gray-900 text-lg">Search Data</a>
                <a href="/search/profile" class="text-gray-900 text-lg">Search Profile</a>
                <a href="/about" class="text-gray-900 text-lg">Enterprise</a>
                <div class="pt-8 flex flex-col items-center space-y-6">
                    <?php if (isset($_SESSION['user_id'])): ?>
                        <a href="/dashboard.php" class="text-gray-600 hover:text-gray-900">Dashboard</a>
                        <a href="/dashboard-files.php" class="text-gray-600 hover:text-gray-900">Member records</a>
                        <a href="/dashboard-profile.php" class="text-gray-600 hover:text-gray-900">Profile</a>
                        <?php if (isset($user['role']) && $user['role'] === 'writer'): ?>
                        <a href="/dashboard-write.php" class="text-gray-600 hover:text-gray-900">Editorial</a>
                        <?php endif; ?>
                        <a href="/logout.php" class="text-red-600 hover:text-red-700">Logout</a>
                    <?php else: ?>
                        <a href="/login.php" class="text-gray-600 hover:text-gray-900">Sign in</a>
                        <a href="/signup.php" class="primary-button bg-gray-900 px-8 py-2.5 text-white rounded-full">
                            Become a member
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</header>

<script>
    const menuToggle = document.getElementById('menu-toggle');
    const closeMenu = document.getElementById('close-menu');
    const mobileMenu = document.getElementById('mobile-menu');

    const toggleMenu = () => {
        mobileMenu.classList.toggle('active');
    };

    menuToggle.addEventListener('click', toggleMenu);
    closeMenu.addEventListener('click', toggleMenu);
</script>