<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Minimal Header</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://api.fontshare.com/v2/css?f[]=satoshi@400,500,700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Satoshi', sans-serif;
            background: #fafafa;
        }

        .nav-container {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        }

        .nav-link {
            position: relative;
        }

        .nav-link::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 1px;
            background: currentColor;
            transition: width 0.3s ease;
        }

        .nav-link:hover::after {
            width: 100%;
        }

        .primary-button {
            transition: all 0.3s ease;
        }

        .primary-button:hover {
            transform: translateY(-1px);
        }

        .mobile-menu {
            background: #fafafa;
            transition: all 0.3s ease;
            opacity: 0;
            visibility: hidden;
        }

        .mobile-menu.active {
            opacity: 1;
            visibility: visible;
        }
        
        .dropdown-menu {
            display: none;
            position: absolute;
            right: 0;
            top: 100%;
            background: white;
            border: 1px solid rgba(0, 0, 0, 0.05);
            border-radius: 0.5rem;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
            z-index: 50;
            min-width: 150px;
        }
        
        .dropdown-trigger:hover .dropdown-menu {
            display: block;
        }
    </style>
</head>
<body class="h-full">
    <header class="fixed w-full top-0 z-50">
        <div class="nav-container">
            <div class="max-w-6xl mx-auto px-6">
                <nav class="flex items-center justify-between h-20">
                    <a href="/" class="text-xl font-medium tracking-tight text-gray-900">Peerkinton</a>
                    
                    <div class="hidden lg:flex items-center space-x-10">                        
                        <a href="/search/data" class="nav-link text-gray-600 text-sm">Search Data</a>
                        <a href="/search/profile" class="nav-link text-gray-600 text-sm">Search Profile</a>
                        <a href="/about" class="nav-link text-gray-600 text-sm">Enterprise</a>
                    </div>

                    <div class="hidden lg:flex items-center space-x-8">
                        <?php if (isset($_SESSION['user_id'])): ?>
                            <div class="relative dropdown-trigger">
                                <div class="flex items-center space-x-2 cursor-pointer text-sm text-gray-600 hover:text-gray-900">
                                    <span>
                                        <?php 
                                        $user_query = "SELECT name FROM users WHERE id = :user_id";
                                        $user_stmt = $db->prepare($user_query);
                                        $user_stmt->execute([':user_id' => $_SESSION['user_id']]);
                                        $user = $user_stmt->fetch();
                                        echo htmlspecialchars($user['name'] ?? $_SESSION['username'] ?? 'Member'); 
                                        ?>
                                    </span>
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </div>
                                <div class="dropdown-menu">
                                    <a href="/dashboard.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Dashboard</a>
                                    <a href="/dashboard-profile.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Profile</a>
                                    <div class="border-t border-gray-100"></div>
                                    <a href="/logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">Logout</a>
                                </div>
                            </div>
                        <?php else: ?>
                            <a href="/login" class="text-gray-600 text-sm hover:text-gray-900">Sign in</a>
                            <a href="/signup" class="primary-button bg-gray-900 px-6 py-2 text-sm text-white rounded-full">
                                Become a member of the academy
                            </a>
                        <?php endif; ?>
                    </div>

                    <button id="menu-toggle" class="lg:hidden p-2">
                        <svg class="w-6 h-6 text-gray-900" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 8h16M4 16h16"/>
                        </svg>
                    </button>
                </nav>
            </div>
        </div>

        <div id="mobile-menu" class="mobile-menu lg:hidden fixed inset-0 z-50">
            <div class="container mx-auto px-6 py-8 h-full flex flex-col">
                <div class="flex justify-end">
                    <button id="close-menu" class="p-2">
                        <svg class="w-6 h-6 text-gray-900" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
                
                <div class="flex flex-col items-center justify-center flex-1 space-y-8">
                    <a href="/search/data" class="text-gray-900 text-lg">Search Data</a>
                    <a href="/search/profile" class="text-gray-900 text-lg">Search Profile</a>
                    <a href="/about" class="text-gray-900 text-lg">Enterprise</a>
                    <div class="pt-8 flex flex-col items-center space-y-6">
                        <?php if (isset($_SESSION['user_id'])): ?>
                            <a href="/dashboard.php" class="text-gray-600 hover:text-gray-900">Dashboard</a>
                            <a href="/dashboard-profile.php" class="text-gray-600 hover:text-gray-900">Profile</a>
                            <a href="/logout.php" class="text-red-600 hover:text-red-700">Logout</a>
                        <?php else: ?>
                            <a href="/login" class="text-gray-600 hover:text-gray-900">Sign in</a>
                            <a href="/signup" class="primary-button bg-gray-900 px-8 py-2.5 text-white rounded-full">
                                Become a member
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <script>
        const menuToggle = document.getElementById('menu-toggle');
        const closeMenu = document.getElementById('close-menu');
        const mobileMenu = document.getElementById('mobile-menu');

        const toggleMenu = () => {
            mobileMenu.classList.toggle('active');
        };

        menuToggle.addEventListener('click', toggleMenu);
        closeMenu.addEventListener('click', toggleMenu);
    </script>
</body>
</html>