<?php
require_once 'auth_check.php';
require_once 'db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

if (isset($_POST['share_files'])) {
    $selectedFiles = $_POST['selected_files'];
    $shareId = uniqid('share_', true);
    $expiryDate = date('Y-m-d H:i:s', strtotime('+7 days'));

    $db2 = getDB2Connection();
    $stmt = $db2->prepare("INSERT INTO shares (share_id, files, expiry_date, created_by) VALUES (?, ?, ?, ?)");
    $filesJson = json_encode($selectedFiles);
    $stmt->execute([$shareId, $filesJson, $expiryDate, $_SESSION['user_id']]);

    $shareUrl = "https://" . $_SERVER['HTTP_HOST'] . "/download.php?id=" . $shareId;
    header("Location: share.php?success=1&url=" . urlencode($shareUrl));
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Share Files - Imators Systems</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    },
                }
            }
        }
    </script>
</head>
<body class="bg-white dark:bg-black text-black dark:text-white min-h-screen transition-colors duration-200 p-4 md:p-6 lg:p-8">
    <div class="max-w-[1400px] mx-auto">
        <?php if(isset($_GET['success']) && isset($_GET['url'])): ?>
        <div class="success-notification fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50">
            <div class="flex items-center space-x-2">
                <i class="fas fa-check-circle"></i>
                <span>Share link created successfully!</span>
            </div>
            <div class="mt-2">
                <input type="text" value="<?= htmlspecialchars($_GET['url']) ?>" 
                       class="w-full px-3 py-1 rounded bg-white/20 text-white" readonly>
                <button onclick="copyLink(this)" class="text-sm hover:underline mt-1">
                    <i class="fas fa-copy"></i> Copy link
                </button>
            </div>
        </div>
        <?php endif; ?>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
            <div class="flex items-center justify-between mb-8">
                <div class="flex items-center space-x-4">
                    <img src="https://cdn.imators.com/logo.png" alt="Logo" class="h-10 w-auto">
                    <div>
                        <h1 class="text-2xl font-bold">Share Files</h1>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Select files to share</p>
                    </div>
                </div>
                <button id="theme-toggle" class="p-2 rounded-lg bg-gray-100 dark:bg-gray-800">
                    <i class="fas fa-sun dark:hidden"></i>
                    <i class="fas fa-moon hidden dark:block"></i>
                </button>
            </div>

            <form action="" method="POST" class="space-y-6">
                <div class="bg-gray-100 dark:bg-gray-800 rounded-lg p-6">
                    <div class="mb-4">
                        <h2 class="text-xl font-medium flex items-center space-x-2">
                            <i class="fas fa-file-alt text-gray-600 dark:text-gray-400"></i>
                            <span>Available Files</span>
                        </h2>
                        <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                            Select the files you want to share
                        </p>
                    </div>

                    <div class="space-y-2">
                        <?php
                        $db2 = getDB2Connection();
                        $query = $db2->query("SELECT * FROM documents ORDER BY created_at DESC");
                        while($doc = $query->fetch(PDO::FETCH_ASSOC)) {
                            $filePath = $doc['pdf-link'];
                            if (file_exists('share-file/' . basename($filePath))) {
                        ?>
                            <label class="flex items-center space-x-3 p-4 bg-white dark:bg-gray-900 rounded-lg cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                                <input type="checkbox" name="selected_files[]" value="<?= htmlspecialchars($filePath) ?>" 
                                       class="rounded border-gray-300 dark:border-gray-600 text-black dark:text-white 
                                              focus:ring-black dark:focus:ring-white">
                                <div class="flex items-center space-x-3">
                                    <i class="fas fa-file-pdf text-red-500"></i>
                                    <span><?= htmlspecialchars(basename($filePath)) ?></span>
                                </div>
                                <span class="ml-auto text-xs text-gray-500">
                                    <?= date('Y-m-d H:i', strtotime($doc['created_at'])) ?>
                                </span>
                            </label>
                        <?php
                            }
                        }
                        ?>
                    </div>
                </div>

                <div class="flex justify-end space-x-3">
                    <a href="index.php" class="px-4 py-2 border border-gray-200 dark:border-gray-600 rounded-lg 
                              text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 
                              transition-colors flex items-center space-x-2">
                        <i class="fas fa-arrow-left"></i>
                        <span>Back</span>
                    </a>
                    <button type="submit" name="share_files" class="px-4 py-2 bg-black dark:bg-white text-white dark:text-black 
                                   rounded-lg hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors 
                                   flex items-center space-x-2">
                        <i class="fas fa-share"></i>
                        <span>Generate Share Link</span>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
    function copyLink(button) {
        const input = button.previousElementSibling;
        input.select();
        document.execCommand('copy');
        
        const originalText = button.innerHTML;
        button.innerHTML = '<i class="fas fa-check"></i> Copied!';
        setTimeout(() => {
            button.innerHTML = originalText;
        }, 2000);
    }

    document.getElementById('theme-toggle').addEventListener('click', () => {
        document.documentElement.classList.toggle('dark');
        localStorage.theme = document.documentElement.classList.contains('dark') ? 'dark' : 'light';
    });

    if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
        document.documentElement.classList.add('dark');
    } else {
        document.documentElement.classList.remove('dark');
    }
    </script>
</body>
</html>