<?php
require_once 'db.php';
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Management Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com/2.2.19"></script>
    <script>
        tailwind.config = {
            darkMode: 'media',
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
        @media (prefers-color-scheme: dark) {
            body {
                background-color: #1a1a1a;
                color: #ffffff;
            }
        }
        .success-notification {
            animation: fadeOut 3s forwards;
            animation-delay: 2s;
        }
        @keyframes fadeOut {
            from {opacity: 1;}
            to {opacity: 0; display: none;}
        }
        .search-highlight {
            background-color: rgba(255, 255, 0, 0.3);
        }
    </style>
</head>
<body class="bg-white dark:bg-gray-900 text-gray-900 dark:text-white transition-colors duration-200">
    <!-- Notifications -->
    <?php if(isset($_GET['success'])): ?>
    <div class="success-notification fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50">
        Operation completed successfully!
    </div>
    <?php endif; ?>

    <?php if(isset($_GET['error'])): ?>
    <div class="error-notification fixed top-4 right-4 bg-red-500 text-white px-6 py-3 rounded-lg shadow-lg z-50">
        An error occurred during the operation.
    </div>
    <?php endif; ?>

    <div class="container mx-auto px-4 py-8">
        <!-- Header with Logo -->
        <div class="flex flex-col md:flex-row items-center justify-between mb-8 space-y-4 md:space-y-0">
            <div class="flex items-center space-x-4">
                <img src="path/to/your/logo.png" alt="Logo" class="h-12 w-auto">
                <h1 class="text-3xl font-bold">Management Dashboard</h1>
            </div>
            
            <!-- Global Search Bar -->
            <div class="w-full md:w-96">
                <div class="relative">
                    <input type="text" 
                           id="global-search" 
                           placeholder="Search users or documents..." 
                           class="w-full px-4 py-2 pl-10 pr-4 rounded-lg border border-gray-300 
                                  dark:border-gray-600 dark:bg-gray-700 focus:outline-none 
                                  focus:ring-2 focus:ring-black dark:focus:ring-white">
                    <div class="absolute left-3 top-2.5">
                        <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                  d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                        </svg>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tabs -->
        <div class="mb-8">
            <div class="border-b border-gray-200 dark:border-gray-700">
                <nav class="-mb-px flex space-x-8">
                    <button 
                        class="user-tab px-4 py-2 font-medium border-b-2 border-black dark:border-white"
                        data-tab="users">
                        User Management
                    </button>
                    <button 
                        class="doc-tab px-4 py-2 font-medium border-b-2 border-transparent"
                        data-tab="documents">
                        Document Management
                    </button>
                </nav>
            </div>
        </div>

        <!-- Users Content -->
        <div id="users-content" class="tab-content">
            <div class="mb-6">
                <div class="flex justify-between items-center">
                    <p class="text-sm text-gray-500 dark:text-gray-400" id="users-count">
                        Loading users...
                    </p>
                </div>
            </div>
            <div id="users-grid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <?php
                $db1 = getDB1Connection();
                $query = $db1->query("SELECT * FROM utilisateurs ORDER BY username");
                while($user = $query->fetch(PDO::FETCH_ASSOC)) {
                    ?>
                    <div class="user-card bg-gray-50 dark:bg-gray-800 p-6 rounded-lg cursor-pointer 
                              hover:shadow-lg transition-all duration-200" 
                         data-user-id="<?= htmlspecialchars($user['id']) ?>"
                         data-email="<?= htmlspecialchars($user['email']) ?>"
                         data-username="<?= htmlspecialchars($user['username']) ?>"
                         data-note="<?= htmlspecialchars($user['note']) ?>"
                         data-searchable="<?= htmlspecialchars($user['username'] . ' ' . $user['email'] . ' ' . $user['note']) ?>">
                        <div class="flex justify-between items-start">
                            <div>
                                <h3 class="font-medium text-lg username">
                                    <?= htmlspecialchars($user['username']) ?>
                                </h3>
                                <p class="text-sm text-gray-600 dark:text-gray-300 email">
                                    <?= htmlspecialchars($user['email']) ?>
                                </p>
                            </div>
                            <span class="text-xs px-2 py-1 bg-gray-200 dark:bg-gray-700 rounded-full">
                                Edit
                            </span>
                        </div>
                        <div class="mt-4">
                            <p class="text-sm text-gray-500 dark:text-gray-400 note">
                                Note: <?= $user['note'] ? htmlspecialchars($user['note']) : 'No note' ?>
                            </p>
                        </div>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>

        