<!DOCTYPE html>
<html lang="fr">
<head>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <title>ISE Engine</title>
   <script src="https://cdn.tailwindcss.com"></script>
   <link rel="preconnect" href="https://fonts.googleapis.com">
   <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Source+Code+Pro:ital,wght@0,200..900;1,200..900&family=Urbanist:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Urbanist:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <style>

        .urbanist {
            font-family: "Urbanist", serif;
            }

        .crypted-word {
            font-family: "Source Code Pro", monospace;
            font-optical-sizing: auto;
            font-weight: <weight>;
            font-style: normal;
            }

    </style>
</head>
<body class="urbanist bg-white">
   <header class="w-full px-8 py-6 flex justify-between items-center">
       <div class="text-xl">ISE Engine</div>
       <button id="menu-toggle" class="md:hidden">
           <i class="fas fa-bars text-xl"></i>
       </button>
       <nav class="md:flex space-x-8">
           <a href="#" class="hover:opacity-60">Try the engine</a>
       </nav>
   </header>

   <div id="mobile-nav" class="hidden px-8 py-4 md:hidden">
       <div class="flex flex-col space-y-4">
           <a href="#" class="hover:opacity-60">Try the Engine</a>
       </div>
   </div>

   <main class="crypted-word flex items-center justify-center min-h-screen">
       <div class="text-center">
           <div class="encrypted-text text-3xl opacity-0">##11&&&&</div>
       </div>
   </main>

   <script>
       document.getElementById('menu-toggle').addEventListener('click', () => {
           document.getElementById('mobile-nav').classList.toggle('hidden');
       });

       const phrase = 'Search Find And Be a human, not a ai.';
       const element = document.querySelector('.encrypted-text');

       function decrypt(element, text) {
           const chars = '##1à&_&&@#$%';
           let steps = 0;
           const maxSteps = 20;
           
           const interval = setInterval(() => {
               let result = '';
               for (let i = 0; i < text.length; i++) {
                   if (i < (text.length * steps / maxSteps)) {
                       result += text[i];
                   } else {
                       result += chars[Math.floor(Math.random() * chars.length)];
                   }
               }
               element.textContent = result;
               steps++;
               
               if (steps > maxSteps) {
                   clearInterval(interval);
                   element.textContent = text;
               }
           }, 100);
       }

       setTimeout(() => {
           element.style.opacity = '1';
           element.style.transition = 'opacity 0.5s';
           setTimeout(() => {
               decrypt(element, phrase);
           }, 500);
       }, 1000);
   </script>
</body>
</html>