<!DOCTYPE html>
<html lang="fr">
<head>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <title>ISE Engine</title>
   <script src="https://cdn.tailwindcss.com"></script>
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-white">
   <header class="w-full px-8 py-6 flex justify-between items-center">
       <div class="text-xl">ISE Engine</div>
       <button id="menu-toggle" class="md:hidden">
           <i class="fas fa-bars text-xl"></i>
       </button>
       <nav class="hidden md:flex space-x-8">
           <a href="#" class="hover:opacity-60">Home</a>
           <a href="#" class="hover:opacity-60">About</a>
           <a href="#" class="hover:opacity-60">Contact</a>
       </nav>
   </header>

   <div id="mobile-nav" class="hidden px-8 py-4 md:hidden">
       <div class="flex flex-col space-y-4">
           <a href="#" class="hover:opacity-60">Home</a>
           <a href="#" class="hover:opacity-60">About</a>
           <a href="#" class="hover:opacity-60">Contact</a>
       </div>
   </div>

   <main class="flex items-center justify-center min-h-screen">
       <div class="text-center space-y-12">
           <div class="decrypt-item opacity-0">
               <i class="fas fa-search text-3xl mb-4 block"></i>
               <div class="encrypted-text text-xl">##11&&&&</div>
           </div>
           <div class="decrypt-item opacity-0">
               <i class="fas fa-eye text-3xl mb-4 block"></i>
               <div class="encrypted-text text-xl">##11&&&&</div>
           </div>
           <div class="decrypt-item opacity-0">
               <i class="fas fa-plus text-3xl mb-4 block"></i>
               <div class="encrypted-text text-xl">##11&&&&</div>
           </div>
           <div class="decrypt-item opacity-0">
               <i class="fas fa-user text-3xl mb-4 block"></i>
               <div class="encrypted-text text-xl">##11&&&&</div>
           </div>
       </div>
   </main>

   <script>
       document.getElementById('menu-toggle').addEventListener('click', () => {
           document.getElementById('mobile-nav').classList.toggle('hidden');
       });

       const words = ['Search', 'Find', 'And', 'Be a human, not a ai'];
       const items = document.querySelectorAll('.decrypt-item');

       function decrypt(element, word) {
           const chars = '##11&&&&@#$%';
           let steps = 0;
           const maxSteps = 15;
           
           const interval = setInterval(() => {
               let result = '';
               for (let i = 0; i < word.length; i++) {
                   if (i < (word.length * steps / maxSteps)) {
                       result += word[i];
                   } else {
                       result += chars[Math.floor(Math.random() * chars.length)];
                   }
               }
               element.textContent = result;
               steps++;
               
               if (steps > maxSteps) {
                   clearInterval(interval);
                   element.textContent = word;
               }
           }, 100);
       }

       setTimeout(() => {
           items.forEach((item, i) => {
               setTimeout(() => {
                   item.style.opacity = '1';
                   item.style.transition = 'opacity 0.5s';
                   setTimeout(() => {
                       decrypt(item.querySelector('.encrypted-text'), words[i]);
                   }, 300);
               }, i * 800);
           });
       }, 1000);
   </script>
</body>
</html>