<?php
$lang = isset($_GET['lang']) ? $_GET['lang'] : 'en';
$group = isset($_GET['group']) ? $_GET['group'] : 'A';

$mapkit_token = "eyJraWQiOiI0SzQ4R1hEN1I0IiwidHlwIjoiSldUIiwiYWxnIjoiRVMyNTYifQ.eyJpc3MiOiJQUDg0RkQ3VUJOIiwiaWF0IjoxNzQyMzE3NzEwLCJvcmlnaW4iOiJpbWF0b3JzLmNvbSIsImV4cCI6MTc1Nzg2NjEwOX0.uBhJSSpW0uBxQl4aMlYF-qsF5drQdYYKmTWs9GxMbVvr3trr65zh11tySWV6XDamBYpeJasysWyLlgIVe6APAA";

$locations = [
    'A' => [
        'name' => [
            'en' => 'Paris Studio',
            'fr' => 'Studio Paris'
        ],
        'address' => [
            'en' => '123 Champs-Élysées, Paris',
            'fr' => '123 Champs-Élysées, Paris'
        ],
        'latitude' => 50.80157,
        'longitude' => 4.38356
    ],
    'B' => [
        'name' => [
            'en' => 'Lyon Studio',
            'fr' => 'Studio Lyon'
        ],
        'address' => [
            'en' => '123 Champs-Élysées, Paris',
            'fr' => '123 Champs-Élysées, Paris'
        ],
        'latitude' => 45.7640,
        'longitude' => 4.8357
    ]
];

$content = [
    'en' => [
        'title' => 'Your invitation to appear in an Imators advertisement.',
        'promo_title' => 'Your invitation to appear in an Imators advertisement.',
        'photo_title' => 'Photography',
        'photo_desc' => 'Our sessions are held in open and not closed or risky places. All photos taken during the session are shown to your children, and sent to you before selection.',
        'security_title' => 'Security',
        'security_desc' => 'We hold ourselves responsible in case of accidents on site, even though these are extremely rare.',
        'confidentiality_title' => 'Confidentiality',
        'confidentiality_desc' => 'By virtue of the European and international laws imposed on us as well as out of respect for our ethics, your child\'s photos will in no case be used for illegal purposes or to harm them.',
        'download_docs' => 'Download Documents',
        'steps_title' => 'Steps.',
        'step1_title' => 'Download & Print',
        'step1_desc' => 'Download the documents and print them on A4 paper.',
        'step2_title' => 'Fill & Sign',
        'step2_desc' => 'Fill in all required fields and sign the documents. Parent or guardian signature is mandatory.',
        'step3_title' => 'Return Documents',
        'step3_desc' => 'Return the signed documents to your Imators representative.',
        'contact_info' => 'For any questions, please contact us at ask@imators.com',
        'date_time' => 'Date and Time',
        'location' => 'Shooting Location',
        'group' => 'Group'
    ],
    'fr' => [
        'title' => 'Votre invitation à apparaître dans une publicité Imators.',
        'promo_title' => 'Votre invitation à apparaître dans une publicité Imators.',
        'photo_title' => 'Photographie',
        'photo_desc' => 'Nos sessions sont tenues dans des lieux ouvert et non fermés ou à risque. Toute photos prises pendant la sessions sont montrée à vos enfants, et vont sont envoyer avant la sélection.',
        'security_title' => 'Sécurité',
        'security_desc' => 'Nous nous tenons responsable en cas d\'accident sur place, même si ces derniers sont extrêmement rare.',
        'confidentiality_title' => 'Confidentialité',
        'confidentiality_desc' => 'En vertu des lois Européennes et internationales qui nous sont imposés ainsi que par respect de notre éthique, les photos de votre enfant ne seront en aucun cas utilisé pour un buts illégal ou pour leur nuire.',
        'download_docs' => 'Télécharger les Documents',
        'steps_title' => 'Étapes.',
        'step1_title' => 'Télécharger & Imprimer',
        'step1_desc' => 'Téléchargez les documents et imprimez-les sur du papier A4.',
        'step2_title' => 'Remplir & Signer',
        'step2_desc' => 'Remplissez tous les champs requis et signez les documents. La signature du parent ou tuteur est obligatoire.',
        'step3_title' => 'Retourner les Documents',
        'step3_desc' => 'Retournez les documents signés à votre représentant Imators.',
        'contact_info' => 'Pour toute question, veuillez nous contacter à ask@imators.com',
        'date_time' => 'Date et Heure',
        'location' => 'Lieu du Tournage',
        'group' => 'Groupe'
    ]
];

$event_date = "2025-04-15T14:30:00";
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $content[$lang]['title']; ?></title>
    
    <meta property="og:title" content="<?php echo $content[$lang]['title']; ?>">
    <meta property="og:description" content="Imators Casting">
    <meta property="og:image" content="https://imators.systems/images/og-casting.jpg">
    <meta property="og:url" content="https://imators.systems/casting">
    <meta property="og:type" content="website">
    
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <script src="https://cdn.apple-mapkit.com/mk/5.x.x/mapkit.core.js"
        crossorigin async
        data-callback="initMapKit"
        data-libraries="map"
        data-token="<?php echo $mapkit_token; ?>">
    </script>
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #000;
            color: #fff;
        }
        
        .info-box {
            border-left: 2px solid white;
        }
        
        .info-box:hover {
            background-color: rgba(255, 255, 255, 0.05);
        }
        
        .step-card {
            background-color: #111;
            border: 1px solid #333;
            transition: transform 0.3s ease;
        }
        
        .step-card:hover {
            transform: translateY(-5px);
        }
        
        #map {
            height: 300px;
            width: 100%;
            border-radius: 8px;
            background-color: #111;
        }
        
        .datetime-box {
            background-color: #111;
            border: 1px solid #333;
            border-radius: 8px;
        }
    </style>
</head>
<body class="min-h-screen bg-black text-white">
    <?php if (file_exists('src/header.php')) { include 'src/header.php'; } ?>
    
    <div class="max-w-4xl mx-auto px-4 py-12">
        <h1 class="mt-24 text-4xl font-light text-center mb-12"><?php echo $content[$lang]['promo_title']; ?></h1>
        <p class="text-center text-sm">In collaboration with</p>
        
        <div class="w-full bg-black p-6 flex flex-wrap justify-around items-center gap-4 md:flex-row flex-col">
            <img src="https://d3k1k88y44k0jy.cloudfront.net/wwwjcdecauxcom/s3fs-public/assets/themes/custom/jcd/html/generic/images/logo.png?VersionId=1INjwgQ1fZlGidpfCf4.wPm0Q8OH5ZN5" alt="Logo 1" class="w-64 max-w-full h-auto transition-transform duration-300 hover:scale-105">
            <img src="https://cdn.freelogovectors.net/wp-content/uploads/2023/05/google_ads_logo-freelogovectors.net_.png" alt="Logo 2" class="w-64 max-w-full h-auto transition-transform duration-300 hover:scale-105">
        </div>
        
        <div class="my-8 grid md:grid-cols-2 gap-6">
            <div class="datetime-box p-6">
                <h2 class="text-xl font-light mb-4"><?php echo $content[$lang]['date_time']; ?></h2>
                <div id="datetime" class="text-2xl font-light">
                    <?php
                        $date = new DateTime($event_date);
                        echo $date->format($lang === 'fr' ? 'd/m/Y H:i' : 'Y-m-d h:i A');
                    ?>
                </div>
                <div class="mt-4">
                    <span class="bg-white text-black px-3 py-1 rounded-full text-sm">
                        <?php echo $content[$lang]['group']; ?> <?php echo $group; ?>
                    </span>
                </div>
            </div>
            <div class="datetime-box p-6">
                <h2 class="text-xl font-light mb-4"><?php echo $content[$lang]['location']; ?></h2>
                <p class="mb-2"><?php echo $locations[$group]['name'][$lang]; ?></p>
                <p class="text-sm text-gray-300 mb-4"><?php echo $locations[$group]['address'][$lang]; ?></p>
            </div>
        </div>
        
        <div class="my-8">
            <div id="map"></div>
        </div>
        
        <div class="space-y-8">
            <div class="grid md:grid-cols-3 gap-6">
                <div class="info-box pl-6 pr-4 py-6">
                    <h2 class="text-xl font-light mb-3"><?php echo $content[$lang]['photo_title']; ?></h2>
                    <p class="text-gray-300 text-sm"><?php echo $content[$lang]['photo_desc']; ?></p>
                </div>
                
                <div class="info-box pl-6 pr-4 py-6">
                    <h2 class="text-xl font-light mb-3"><?php echo $content[$lang]['security_title']; ?></h2>
                    <p class="text-gray-300 text-sm"><?php echo $content[$lang]['security_desc']; ?></p>
                </div>
                
                <div class="info-box pl-6 pr-4 py-6">
                    <h2 class="text-xl font-light mb-3"><?php echo $content[$lang]['confidentiality_title']; ?></h2>
                    <p class="text-gray-300 text-sm"><?php echo $content[$lang]['confidentiality_desc']; ?></p>
                </div>
            </div>

            <div class="py-8">
                <h2 class="text-2xl font-light text-center mb-8"><?php echo $content[$lang]['steps_title']; ?></h2>
                
                <div class="grid md:grid-cols-3 gap-6">
                    <div class="step-card p-6 rounded-lg">
                        <div class="flex items-center mb-4">
                            <div class="bg-white text-black rounded-full w-8 h-8 flex items-center justify-center mr-3">1</div>
                            <h3 class="text-lg font-light"><?php echo $content[$lang]['step1_title']; ?></h3>
                        </div>
                        <p class="text-gray-300 text-sm"><?php echo $content[$lang]['step1_desc']; ?></p>
                    </div>
                    
                    <div class="step-card p-6 rounded-lg">
                        <div class="flex items-center mb-4">
                            <div class="bg-white text-black rounded-full w-8 h-8 flex items-center justify-center mr-3">2</div>
                            <h3 class="text-lg font-light"><?php echo $content[$lang]['step2_title']; ?></h3>
                        </div>
                        <p class="text-gray-300 text-sm"><?php echo $content[$lang]['step2_desc']; ?></p>
                    </div>
                    
                    <div class="step-card p-6 rounded-lg">
                        <div class="flex items-center mb-4">
                            <div class="bg-white text-black rounded-full w-8 h-8 flex items-center justify-center mr-3">3</div>
                            <h3 class="text-lg font-light"><?php echo $content[$lang]['step3_title']; ?></h3>
                        </div>
                        <p class="text-gray-300 text-sm"><?php echo $content[$lang]['step3_desc']; ?></p>
                    </div>
                </div>
            </div>
            
            <div class="text-center py-8">
                <a href="imators-cast.pdf" class="inline-flex items-center border border-white text-white px-8 py-4 rounded-full text-lg hover:bg-white hover:text-black transition duration-300">
                    <i class="fa fa-download mr-3"></i> <?php echo $content[$lang]['download_docs']; ?>
                </a>
            </div>
            
            <div class="text-center text-sm text-gray-400 py-4">
                <?php echo $content[$lang]['contact_info']; ?>
            </div>
        </div>
    </div>
    
    <div class="fixed bottom-6 right-6 flex space-x-2">
        <a href="?lang=en&group=<?php echo $group; ?>" class="px-3 py-1 rounded <?php echo $lang === 'en' ? 'bg-white text-black' : 'bg-black text-white border border-gray-700'; ?>">
            EN
        </a>
        <a href="?lang=fr&group=<?php echo $group; ?>" class="px-3 py-1 rounded <?php echo $lang === 'fr' ? 'bg-white text-black' : 'bg-black text-white border border-gray-700'; ?>">
            FR
        </a>
    </div>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
            <h5 class="text-xs uppercase font-medium mb-6">Follow Us</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/itsimators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
                <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Privacy Policy</a>
                <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Terms of Use</a>
                <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Home</a>
                <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">About Us</a>
                <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Contact Us</a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Possible reality</h5>
                <p class="text-sm">All images, videos, and content on this site are the property of Imators.</p>
            </div>
        </div>
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">&copy; 2025 Imators. All rights reserved.</p>
            <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.</p>
        </div>
    </footer>

    <script>
        function initMapKit() {
            const latitude = <?php echo $locations[$group]['latitude']; ?>;
            const longitude = <?php echo $locations[$group]['longitude']; ?>;
            
            try {
                const center = new mapkit.Coordinate(latitude, longitude);
                const span = new mapkit.CoordinateSpan(0.01, 0.01);
                const region = new mapkit.CoordinateRegion(center, span);
                
                const map = new mapkit.Map('map', {
                    region: region,
                    mapType: mapkit.Map.MapTypes.Standard,
                    showsZoomControl: true,
                    showsCompass: mapkit.FeatureVisibility.Visible,
                    showsScale: mapkit.FeatureVisibility.Visible
                });
                
                const annotation = new mapkit.MarkerAnnotation(center, {
                    title: "<?php echo addslashes($locations[$group]['name'][$lang]); ?>",
                    subtitle: "<?php echo addslashes($locations[$group]['address'][$lang]); ?>",
                    color: "#FF9500",
                    glyphText: "<?php echo $group; ?>",
                    selected: true,
                    animates: true
                });
                
                map.addAnnotation(annotation);
                
            } catch (error) {
                console.error("Error initializing map:", error);
                document.getElementById("map").innerHTML = "<div class='flex items-center justify-center h-full'><p class='text-center p-4'>La carte n'est pas disponible actuellement.</p></div>";
            }
        }

        window.addEventListener('error', function(e) {
            if (e.filename && e.filename.includes('mapkit')) {
                document.getElementById("map").innerHTML = "<div class='flex items-center justify-center h-full'><p class='text-center p-4'>La carte n'est pas disponible actuellement.</p></div>";
            }
        }, true);
    </script>
</body>
</html>