<?php
$host = 'localhost:3306';
$dbname = 'gqdcvggs_trafficlight';
$username = 'gqdcvggs';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

header('Content-Type: application/json');

switch ($action) {
    case 'getTrafficLights':
        getTrafficLights($pdo);
        break;
    
    case 'getTrafficLight':
        $id = isset($_GET['id']) ? $_GET['id'] : null;
        getTrafficLight($pdo, $id);
        break;
    
    case 'addTrafficLight':
        addTrafficLight($pdo);
        break;
    
    case 'updateTiming':
        updateTiming($pdo);
        break;
    
    default:
        echo json_encode(['success' => false, 'message' => 'Invalid action']);
}

function getTrafficLights($pdo) {
    try {
        $stmt = $pdo->query("SELECT * FROM traffic_lights WHERE certification = 'true'");
        $lights = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode($lights);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error fetching traffic lights: ' . $e->getMessage()]);
    }
}

function getTrafficLight($pdo, $id) {
    if (!$id) {
        echo json_encode(['success' => false, 'message' => 'ID is required']);
        return;
    }
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM traffic_lights WHERE id = ? AND certification = 'true'");
        $stmt->execute([$id]);
        $light = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($light) {
            echo json_encode($light);
        } else {
            echo json_encode(['success' => false, 'message' => 'Traffic light not found']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error fetching traffic light: ' . $e->getMessage()]);
    }
}

function addTrafficLight($pdo) {
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);
    
    if (!$data) {
        echo json_encode(['success' => false, 'message' => 'Invalid data format']);
        return;
    }
    
    $required = ['name', 'latitude', 'longitude', 'direction', 'red_duration', 'green_duration'];
    foreach ($required as $field) {
        if (!isset($data[$field])) {
            echo json_encode(['success' => false, 'message' => "$field is required"]);
            return;
        }
    }
    
    try {
        $stmt = $pdo->prepare("INSERT INTO traffic_lights (name, latitude, longitude, direction, red_duration, green_duration, certification) VALUES (?, ?, ?, ?, ?, ?, 'false')");
        $stmt->execute([
            $data['name'],
            $data['latitude'],
            $data['longitude'],
            $data['direction'],
            $data['red_duration'],
            $data['green_duration']
        ]);
        
        $id = $pdo->lastInsertId();
        
        $stmt = $pdo->prepare("SELECT * FROM traffic_lights WHERE id = ?");
        $stmt->execute([$id]);
        $light = $stmt->fetch(PDO::FETCH_ASSOC);
        
        echo json_encode(['success' => true, 'light' => $light]);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error adding traffic light: ' . $e->getMessage()]);
    }
}

function updateTiming($pdo) {
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);
    
    if (!$data || !isset($data['id']) || !isset($data['duration_type']) || !isset($data['duration'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid data format']);
        return;
    }
    
    $durationType = $data['duration_type'];
    if ($durationType !== 'red' && $durationType !== 'green') {
        echo json_encode(['success' => false, 'message' => 'Invalid duration type']);
        return;
    }
    
    $field = $durationType . '_duration';
    
    try {
        $stmt = $pdo->prepare("UPDATE traffic_lights SET $field = ? WHERE id = ?");
        $stmt->execute([$data['duration'], $data['id']]);
        
        $stmt = $pdo->prepare("SELECT * FROM traffic_lights WHERE id = ?");
        $stmt->execute([$data['id']]);
        $light = $stmt->fetch(PDO::FETCH_ASSOC);
        
        echo json_encode(['success' => true, 'light' => $light]);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error updating traffic light timing: ' . $e->getMessage()]);
    }
}
?>