<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Our Services - Imators</title>
    <link rel="icon" type="image/png" href="imators.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f9f0e6;
        }
    </style>
</head>
<body class="text-gray-800">
    <div class="max-w-4xl mx-auto px-4 py-20">
        <header class="mb-24">
            <h1 class="text-4xl font-light tracking-wider">Our Services</h1>
            <p class="text-sm">Découvre nos services et solutions digitales adaptés à tes besoins professionnels.</p>
        </header>

        <main>
            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Développement Web</h2>
                <p class="mb-6">
                    Création de sites web modernes et responsives, applications web sur mesure et solutions e-commerce performantes pour développer ta présence digitale.</p>
                <div class="bg-white p-6 rounded-lg shadow-sm">
                    <h3 class="text-lg font-medium mb-2">Prix</h3>
                    <ul class="space-y-2">
                        <li>- Site vitrine : à partir de 1 500€</li>
                        <li>- Site e-commerce : à partir de 3 500€</li>
                        <li>- Application web : à partir de 5 000€</li>
                        <li>- Maintenance mensuelle : 150€/mois</li>
                    </ul>
                </div>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Design & Identité Visuelle</h2>
                <p class="mb-6">
                    Création d'identités visuelles uniques, design de logos, charte graphique complète et supports de communication pour renforcer ton image de marque.</p>
                <div class="bg-white p-6 rounded-lg shadow-sm">
                    <h3 class="text-lg font-medium mb-2">Prix</h3>
                    <ul class="space-y-2">
                        <li>- Logo simple : 350€</li>
                        <li>- Identité visuelle complète : 1 200€</li>
                        <li>- Charte graphique : 800€</li>
                        <li>- Design UI/UX : 150€/jour</li>
                    </ul>
                </div>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Marketing Digital</h2>
                <p class="mb-6">
                    Stratégies SEO, gestion des réseaux sociaux, campagnes publicitaires et création de contenu pour booster ta visibilité en ligne.</p>
                <div class="bg-white p-6 rounded-lg shadow-sm">
                    <h3 class="text-lg font-medium mb-2">Prix</h3>
                    <ul class="space-y-2">
                        <li>- Audit SEO : 500€</li>
                        <li>- Optimisation SEO : 200€/mois</li>
                        <li>- Gestion réseaux sociaux : 400€/mois</li>
                        <li>- Campagne publicitaire : 300€ + budget pub</li>
                    </ul>
                </div>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Consulting & Formation</h2>
                <p class="mb-6">
                    Accompagnement personnalisé, formations techniques et conseils stratégiques pour développer tes compétences digitales et optimiser tes processus.</p>
                <div class="bg-white p-6 rounded-lg shadow-sm">
                    <h3 class="text-lg font-medium mb-2">Prix</h3>
                    <ul class="space-y-2">
                        <li>- Consultation stratégique : 120€/heure</li>
                        <li>- Formation technique : 800€/jour</li>
                        <li>- Audit technique : 600€</li>
                        <li>- Support technique : 80€/heure</li>
                    </ul>
                </div>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Contact</h2>
                <p>
                    Pour discuter de ton projet ou obtenir un devis personnalisé, contacte notre équipe à hello@imators.com
                </p>
            </section>
        </main>

        <footer class="mt-24 pt-6 border-t border-gray-200 text-sm text-gray-500">
            <p>&copy; 2025 Imators. All rights reserved.</p>
        </footer>
    </div>
</body>
</html>