<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- HTML Meta Tags -->
    <title>Imators</title>
    <meta name="description" content="Imators is een technologiebedrijf, opgericht begin 2024 door Izhak Aktas. Ons doel is om de basis te leggen voor de tweede technologische fase die de wereld zal meemaken. Dit zal stap voor stap gebeuren, zodat u ervan kunt genieten.">

    <!-- Facebook Meta Tags -->
    <meta property="og:url" content="https://imators.com">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Imators">
    <meta property="og:description" content="Imators is een technologiebedrijf, opgericht begin 2024 door Izhak Aktas. Ons doel is om de basis te leggen voor de tweede technologische fase die de wereld zal meemaken. Dit zal stap voor stap gebeuren, zodat u ervan kunt genieten.">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <!-- Twitter Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta property="twitter:domain" content="imators.com">
    <meta property="twitter:url" content="https://imators.com">
    <meta name="twitter:title" content="Imators">
    <meta name="twitter:description" content="Imators is een technologiebedrijf, opgericht begin 2024 door Izhak Aktas. Ons doel is om de basis te leggen voor de tweede technologische fase die de wereld zal meemaken. Dit zal stap voor stap gebeuren, zodat u ervan kunt genieten.">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css" rel="stylesheet" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&family=Space+Grotesk:wght@300;400;500;600;700&family=Fredoka:wght@300..700&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />

    <style>
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-out forwards;
        }

        .fredoka {
            font-family: "Fredoka", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
            font-variation-settings: "wdth" 100;
        }

        .Montserrat {
            font-family: "Montserrat", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
        }
		        
        .slide {
            transition: opacity 0.8s ease-in-out, transform 0.8s ease-in-out;
        }
        .banner-image {
            transition: transform 0.8s ease-in-out, filter 0.8s ease-in-out;
        }
        .slide.active .banner-image {
            transform: scale(1.05);
            filter: brightness(0.9);
        }

        .gemance {
            font-family: "Princess Sofia", cursive;
            font-weight: 400;
            font-style: normal;
        }

        #slideshow {
            z-index: 1;
        }

        .header {
            z-index: 1000;
        }

        .zajidhiadj {
            z-index: 1001;
            position: relative;
        }

        @media (max-width: 640px) {
            .slide .flex-grow {
                padding-top: 2rem;
            }
            .banner-image {
                height: 50vh;
                object-fit: cover;
            }
        }

        .slide-content {
            transition: opacity 0.5s ease-in-out, transform 0.5s ease-in-out;
        }
        .slide:not(.active) .slide-content {
            opacity: 0;
            transform: translateY(20px);
        }
        .slide.active .slide-content {
            opacity: 1;
            transform: translateY(0);
        }
        #slideshow-dots button {
            transition: background-color 0.3s ease, transform 0.3s ease;
        }
        #slideshow-dots button:hover {
            transform: scale(1.2);
        }
    </style>
</head>
<body class="bg-black">
    <?php include 'src/header.php'; ?>

    <div id="slideshow" class="h-screen w-screen overflow-hidden relative">
        <section class="Montserrat slide absolute inset-0 flex flex-col z-10 opacity-0">
            <div class="flex-grow flex flex-col justify-center items-center text-center px-4 py-8 slide-content">
                <p class="text-sm uppercase tracking-widest mb-2 text-teal-400">Beschikbaar voor Windows en MacOS</p>
                <h2 class="text-4xl md:text-6xl font-bold mb-4 leading-tight">Progm</h2>
                <p class="text-lg md:text-xl text-gray-400 mb-2 max-w-lg">Een modern, minimalistisch tijdelijk programma op uw scherm</p>
            </div>
            <div class="relative h-3/5 md:h-3/5 overflow-hidden">
                <img src="Progm1.png" alt="Koraalrif" class="banner-image hidden md:block object-cover w-full h-full">
                <img src="mobile_progm.png" alt="Koraalrif Mobiel" class="banner-image md:hidden object-cover w-full h-full">
                <div class="absolute inset-0 bg-gradient-to-t from-transparent to-black opacity-70"></div>
            </div>
        </section>
        
        <section class="Montserrat slide absolute inset-0 flex flex-col z-10">
            <div class="flex-grow flex flex-col justify-center items-center text-center px-4 py-8 slide-content">
                <p class="text-sm uppercase tracking-widest mb-2 text-purple-400">Beschikbaar op 25 december</p>
                <h2 class="text-4xl md:text-6xl font-bold mb-4 leading-tight Montserrat">Academ</h2>
                <p class="text-lg md:text-xl text-gray-400 mb-2 max-w-lg">Verander het schoolleren voor altijd zodat u nooit meer in de problemen komt</p>
            </div>
            <div class="relative h-3/5 md:h-3/5 overflow-hidden">
                <img href="/progm" src="design4.png" alt="Academ" class="banner-image hidden md:block object-cover w-full h-full">
                <img src="design4.png" alt="Academ Mobiel" class="banner-image md:hidden object-cover w-full h-full">
                <div class="absolute inset-0 bg-gradient-to-t from-transparent to-black opacity-70"></div>
            </div>
        </section>
        
        <section class="Montserrat slide absolute inset-0 flex flex-col z-10">
            <div class="flex-grow flex flex-col justify-center items-center text-center px-4 py-8 slide-content">
                <p class="text-sm uppercase tracking-widest mb-2 text-purple-400">Een Imators Winkel</p>
                <h2 class="text-4xl md:text-6xl mb-4 leading-tight gemance">Gemance</h2>
                <p class="text-lg md:text-xl text-gray-400 mb-2 max-w-lg">Schoonheid die betaalbaar is voor iedereen. Ontdek het Gemance stenengamma</p>
            </div>
            <div class="relative h-3/5 md:h-3/5 overflow-hidden">
                <img src="gemance.png" alt="Gemance" class="banner-image hidden md:block object-cover w-full h-full">
                <img href="https://gemance.com" src="gemance_cube.png" alt="Gemance Mobiel" class="banner-image md:hidden object-cover w-full h-full">
                <div class="absolute inset-0 bg-gradient-to-t from-transparent to-black opacity-70"></div>
            </div>
        </section>
        
        <section class="Montserrat slide absolute inset-0 flex flex-col z-10 opacity-0">
            <div class="flex-grow flex flex-col justify-center items-center text-center px-4 py-8 slide-content">
                <p class="text-sm uppercase tracking-widest mb-2 text-purple-400">Binnenkort beschikbaar</p>
                <h2 class="text-4xl md:text-6xl font-bold mb-4 leading-tight">OhMyPanel</h2>
                <p class="text-lg md:text-xl text-gray-400 mb-2 max-w-lg">E&eacute;n ding dat de handel voor altijd zou kunnen revolutioneren</p>
            </div>
            <div class="relative h-3/5 md:h-3/5 overflow-hidden">
                <img src="design3.png" alt="Besneeuwde toppen" class="banner-image hidden md:block object-cover w-full h-full">
                <img src="design3.png" alt="Besneeuwde toppen Mobiel" class="banner-image md:hidden object-cover w-full h-full">
                <div class="absolute inset-0 bg-gradient-to-t from-transparent to-black opacity-70"></div>
            </div>
        </section>
        
        <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 flex space-x-4 z-20" id="slideshow-dots">
            <button class="w-2 h-2 rounded-full bg-gray-600 focus:outline-none hover:bg-gray-400 transition-colors"></button>
            <button class="w-2 h-2 rounded-full bg-gray-600 focus:outline-none hover:bg-gray-400 transition-colors"></button>
            <button class="w-2 h-2 rounded-full bg-gray-600 focus:outline-none hover:bg-gray-400 transition-colors"></button>
            <button class="w-2 h-2 rounded-full bg-gray-600 focus:outline-none hover:bg-gray-400 transition-colors"></button>
        </div>
    </div>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Volg ons</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/this.is.imators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <img src="https://uxwing.com/wp-content/themes/uxwing/download/brands-and-social-media/instagram-white-icon.png" alt="Instagram" class="w-6 h-6 mr-2">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Ontdekken</h5>
                <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Privacybeleid</a>
                <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Gebruiksvoorwaarden</a>
                <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Startpagina</a>
                <a href="/over-ons" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Over ons</a>
                <a href="/contact" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Contact</a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Mogelijke realiteit</h5>
                <p class="text-sm">Alle afbeeldingen, video's en inhoud op deze site zijn eigendom van Imators.</p>
            </div>
        </div>
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">&copy; 2024 Imators. Alle rechten voorbehouden.</p>
            <p class="text-xs">Imators is een geregistreerde BV (Besloten Vennootschap). Al onze producten, of ze nu technologisch fysiek of online zijn, zijn onderworpen aan onze regels, die u kunt raadplegen.</p>
        </div>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const slides = document.querySelectorAll('.slide');
            const dots = document.querySelectorAll('#slideshow-dots button');
            let currentSlide = 0;

            function showSlide(index) {
                slides.forEach((slide, i) => {
                    if (i === index) {
                        slide.style.opacity = '1';
                        slide.classList.add('active');
                    } else {
                        slide.style.opacity = '0';
                        slide.classList.remove('active');
                    }
                });
                dots.forEach((dot, i) => {
                    dot.classList.toggle('bg-white', i === index);
                    dot.classList.toggle('bg-gray-600', i !== index);
                });
            }

            function nextSlide() {
                currentSlide = (currentSlide + 1) % slides.length;
                showSlide(currentSlide);
            }

            dots.forEach((dot, i) => {
                dot.addEventListener('click', () => {
                    currentSlide = i;
                    showSlide(currentSlide);
                });
            });

            setInterval(nextSlide, 5000);
            showSlide(currentSlide);
        });
    </script>

    </body>
    </html>