<?php
$data = json_decode(file_get_contents('stock.json'), true);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Horaires des Trains</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-white">
    <div class="container mx-auto p-8">
        <h1 class="text-4xl font-bold mb-8">Horaires des Trains</h1>
        <div id="trains" class="space-y-4"></div>
    </div>
    <div id="announcement" class="fixed bottom-0 left-0 w-full bg-blue-600 transform translate-y-full transition-transform duration-500"></div>

    <script>
    function updateTrains() {
        fetch('stock.json?' + new Date().getTime())
        .then(response => response.json())
        .then(data => {
            const trainsDiv = document.getElementById('trains');
            trainsDiv.innerHTML = '';
            
            data.forEach(train => {
                const arrival = new Date(train.arrival);
                const now = new Date();
                const timeLeft = Math.max(0, arrival - now);
                
                const minutes = Math.floor(timeLeft / 60000);
                
                const div = document.createElement('div');
                div.className = 'bg-gray-800 p-6 rounded-lg grid grid-cols-4 gap-4 items-center';
                div.innerHTML = `
                    <div class="text-xl font-bold">${train.line}</div>
                    <div>${train.station}</div>
                    <div>${minutes} minutes</div>
                    <div class="text-${train.status === 'on-time' ? 'green' : 'red'}-500">
                        ${train.status === 'on-time' ? 'À l\'heure' : 'Retardé'}
                    </div>
                `;
                
                if (minutes === 0) {
                    showAnnouncement(`Train ligne ${train.line} à destination de ${train.station} entre en gare`);
                }
                
                trainsDiv.appendChild(div);
            });
        });
    }

    function showAnnouncement(text) {
        const announcement = document.getElementById('announcement');
        announcement.textContent = text;
        announcement.classList.remove('translate-y-full');
        setTimeout(() => {
            announcement.classList.add('translate-y-full');
        }, 5000);
    }

    updateTrains();
    setInterval(updateTrains, 5000);
    </script>
</body>
</html>