<?php
require_once 'db.php';

if (!isset($_GET['file']) || !isset($_GET['share'])) {
    header('Location: index.php');
    exit;
}

$filename = basename($_GET['file']);
$shareId = $_GET['share'];

$db2 = getDB2Connection();
$stmt = $db2->prepare("SELECT * FROM shares WHERE share_id = ? AND expiry_date > NOW()");
$stmt->execute([$shareId]);
$share = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$share) {
    header('Location: index.php?error=expired');
    exit;
}

$files = json_decode($share['files'], true);
$isFileInShare = false;

foreach ($files as $file) {
    if (basename($file) === $filename) {
        $isFileInShare = true;
        break;
    }
}

if (!$isFileInShare) {
    header('Location: index.php?error=unauthorized');
    exit;
}

$filepath = 'share-file/' . $filename;

if (!file_exists($filepath)) {
    header('Location: index.php?error=notfound');
    exit;
}

$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mimeType = finfo_file($finfo, $filepath);
finfo_close($finfo);

header('Content-Type: ' . $mimeType);
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Content-Length: ' . filesize($filepath));
header('Cache-Control: no-cache, must-revalidate');
header('Pragma: public');

readfile($filepath);
exit;
?>