<?php
$action = isset($_GET['action']) ? $_GET['action'] : 'view';
$event_id = isset($_GET['event']) ? intval($_GET['event']) : null;

// Traitement des actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($action === 'add' || $action === 'edit') {
        $title = isset($_POST['title']) ? trim($_POST['title']) : '';
        $description = isset($_POST['description']) ? trim($_POST['description']) : '';
        $date = isset($_POST['date']) ? $_POST['date'] : '';
        $time = isset($_POST['time']) ? $_POST['time'] : '';
        $all_day = isset($_POST['all_day']) ? 1 : 0;
        $reminder = isset($_POST['reminder']) ? intval($_POST['reminder']) : 0;
        
        if (!empty($title) && !empty($date)) {
            $datetime = $date . ($all_day ? '' : ' ' . $time);
            
            if ($action === 'add') {
                $stmt = $db->prepare("INSERT INTO events (family_id, title, description, date, time, all_day, reminder, created_by, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())");
                $stmt->execute([$family_id, $title, $description, $date, $time, $all_day, $reminder, $user_id]);
            } else if ($action === 'edit' && $event_id) {
                $stmt = $db->prepare("UPDATE events SET title = ?, description = ?, date = ?, time = ?, all_day = ?, reminder = ? WHERE id = ? AND family_id = ?");
                $stmt->execute([$title, $description, $date, $time, $all_day, $reminder, $event_id, $family_id]);
            }
            
            header("Location: ?page=calendar");
            exit;
        }
    } else if ($action === 'delete' && $event_id) {
        $stmt = $db->prepare("DELETE FROM events WHERE id = ? AND family_id = ?");
        $stmt->execute([$event_id, $family_id]);
        
        header("Location: ?page=calendar");
        exit;
    }
}

// Récupérer l'événement si on est en mode édition
$event = null;
if (($action === 'edit' || $action === 'view_event') && $event_id) {
    $stmt = $db->prepare("SELECT * FROM events WHERE id = ? AND family_id = ?");
    $stmt->execute([$event_id, $family_id]);
    $event = $stmt->fetch();
    
    if (!$event) {
        header("Location: ?page=calendar");
        exit;
    }
}

// Récupérer le mois et l'année à afficher
$month = isset($_GET['month']) ? intval($_GET['month']) : intval(date('m'));
$year = isset($_GET['year']) ? intval($_GET['year']) : intval(date('Y'));

// Valider le mois et l'année
if ($month < 1 || $month > 12) {
    $month = date('m');
}
if ($year < 2000 || $year > 2100) {
    $year = date('Y');
}

// Calculer les mois précédent et suivant
$prev_month = $month - 1;
$prev_year = $year;
if ($prev_month < 1) {
    $prev_month = 12;
    $prev_year--;
}

$next_month = $month + 1;
$next_year = $year;
if ($next_month > 12) {
    $next_month = 1;
    $next_year++;
}

// Obtenir les événements du mois
$start_date = sprintf('%04d-%02d-01', $year, $month);
$end_date = sprintf('%04d-%02d-%02d', $year, $month, date('t', strtotime($start_date)));

$stmt = $db->prepare("SELECT * FROM events WHERE family_id = ? AND date BETWEEN ? AND ? ORDER BY date, time");
$stmt->execute([$family_id, $start_date, $end_date]);
$events = $stmt->fetchAll();

// Organiser les événements par jour
$events_by_day = [];
foreach ($events as $event) {
    $day = intval(date('j', strtotime($event['date'])));
    if (!isset($events_by_day[$day])) {
        $events_by_day[$day] = [];
    }
    $events_by_day[$day][] = $event;
}

// Obtenir les prochains événements (pour la sidebar)
$stmt = $db->prepare("SELECT * FROM events WHERE family_id = ? AND date >= CURDATE() ORDER BY date, time LIMIT 5");
$stmt->execute([$family_id]);
$upcoming_events = $stmt->fetchAll();
?>

<div class="mb-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Family Calendar</h1>
        <button class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition" onclick="document.getElementById('add-event-modal').classList.remove('hidden')">
            Add Event
        </button>
    </div>
    
    <div class="flex flex-col md:flex-row gap-6">
        <!-- Calendar -->
        <div class="md:w-3/4 bg-white shadow rounded-lg p-6">
            <!-- Month Navigation -->
            <div class="flex justify-between items-center mb-6">
                <a href="?page=calendar&month=<?php echo $prev_month; ?>&year=<?php echo $prev_year; ?>" class="text-indigo-600 hover:text-indigo-800">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 inline" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd" />
                    </svg>
                    Previous
                </a>
                <h2 class="text-xl font-bold"><?php echo date('F Y', strtotime($start_date)); ?></h2>
                <a href="?page=calendar&month=<?php echo $next_month; ?>&year=<?php echo $next_year; ?>" class="text-indigo-600 hover:text-indigo-800">
                    Next
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 inline" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                    </svg>
                </a>
            </div>
            
            <!-- Calendar Grid -->
            <div class="grid grid-cols-7 gap-px bg-gray-200">
                <!-- Day Headers -->
                <?php foreach (['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'] as $day): ?>
                    <div class="bg-gray-100 text-center py-2 font-medium text-gray-600">
                        <?php echo $day; ?>
                    </div>
                <?php endforeach; ?>
                
                <!-- Calendar Days -->
                <?php
                $first_day = date('w', strtotime($start_date));
                $total_days = date('t', strtotime($start_date));
                $current_day = 1;
                $today = date('Y-m-d');
                
                // Empty cells before the first day
                for ($i = 0; $i < $first_day; $i++) {
                    echo '<div class="bg-white p-2 h-32"></div>';
                }
                
                // Calendar days
                for ($day = 1; $day <= $total_days; $day++) {
                    $date = sprintf('%04d-%02d-%02d', $year, $month, $day);
                    $is_today = ($today === $date);
                    
                    echo '<div class="bg-white p-2 h-32 border-t' . ($is_today ? ' ring-2 ring-indigo-500' : '') . '">';
                    
                    // Day number
                    echo '<div class="flex justify-between items-center">';
                    echo '<span class="font-bold' . ($is_today ? ' text-indigo-600' : '') . '">' . $day . '</span>';
                    echo '<button class="text-gray-400 hover:text-indigo-600" onclick="document.getElementById(\'add-event-modal\').classList.remove(\'hidden\'); document.getElementById(\'event_date\').value = \'' . $date . '\';">';
                    echo '<svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">';
                    echo '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />';
                    echo '</svg>';
                    echo '</button>';
                    echo '</div>';
                    
                    // Events for this day
                    if (isset($events_by_day[$day])) {
                        echo '<div class="mt-1 space-y-1 max-h-24 overflow-y-auto">';
                        foreach ($events_by_day[$day] as $event) {
                            $time_display = $event['all_day'] ? 'All day' : date('g:i A', strtotime($event['time']));
                            echo '<a href="?page=calendar&action=view_event&event=' . $event['id'] . '" class="block text-xs p-1 rounded bg-indigo-50 hover:bg-indigo-100">';
                            echo '<div class="font-medium truncate">' . htmlspecialchars($event['title']) . '</div>';
                            echo '<div class="text-gray-500">' . $time_display . '</div>';
                            echo '</a>';
                        }
                        echo '</div>';
                    }
                    
                    echo '</div>';
                }
                
                // Empty cells after the last day
                $cells_filled = $first_day + $total_days;
                $empty_cells_after = 7 - ($cells_filled % 7);
                if ($empty_cells_after < 7) {
                    for ($i = 0; $i < $empty_cells_after; $i++) {
                        echo '<div class="bg-white p-2 h-32"></div>';
                    }
                }
                ?>
            </div>
        </div>
        
        <!-- Sidebar -->
        <div class="md:w-1/4">
            <div class="bg-white shadow rounded-lg p-6 mb-6">
                <h3 class="text-lg font-bold mb-4">Upcoming Events</h3>
                <?php if (count($upcoming_events) > 0): ?>
                    <div class="space-y-4">
                        <?php foreach ($upcoming_events as $event): ?>
                            <a href="?page=calendar&action=view_event&event=<?php echo $event['id']; ?>" class="block p-3 rounded hover:bg-gray-50 transition">
                                <div class="font-medium"><?php echo htmlspecialchars($event['title']); ?></div>
                                <div class="text-sm text-gray-500">
                                    <?php 
                                    echo date('M j, Y', strtotime($event['date']));
                                    echo $event['all_day'] ? ' (All day)' : ' at ' . date('g:i A', strtotime($event['time']));
                                    ?>
                                </div>
                                <?php if (!empty($event['description'])): ?>
                                    <div class="text-sm text-gray-600 mt-1 truncate"><?php echo htmlspecialchars($event['description']); ?></div>
                                <?php endif; ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <p class="text-gray-500">No upcoming events</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php if ($action === 'view_event' && $event): ?>
    <!-- Event Details Modal -->
    <div id="event-details-modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
        <div class="bg-white rounded-lg max-w-lg w-full">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <h2 class="text-xl font-bold"><?php echo htmlspecialchars($event['title']); ?></h2>
                    <a href="?page=calendar" class="text-gray-500 hover:text-gray-700">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </a>
                </div>
                
                <div class="mb-4">
                    <div class="flex items-center text-gray-600 mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                        <span>
                            <?php 
                            echo date('F j, Y', strtotime($event['date']));
                            echo $event['all_day'] ? ' (All day)' : ' at ' . date('g:i A', strtotime($event['time']));
                            ?>
                        </span>
                    </div>
                    
                    <?php if (!empty($event['description'])): ?>
                        <div class="flex items-start text-gray-600 mb-2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h7" />
                            </svg>
                            <span><?php echo nl2br(htmlspecialchars($event['description'])); ?></span>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($event['reminder']): ?>
                        <div class="flex items-center text-gray-600 mb-2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                            </svg>
                            <span>
                                Reminder: 
                                <?php 
                                $reminder_options = [
                                    0 => 'None',
                                    15 => '15 minutes before',
                                    30 => '30 minutes before',
                                    60 => '1 hour before',
                                    1440 => '1 day before'
                                ];
                                echo $reminder_options[$event['reminder']] ?? 'Custom';
                                ?>
                            </span>
                        </div>
                    <?php endif; ?>
                    
                    <div class="flex items-center text-gray-600">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                        </svg>
                        <span>
                            <?php 
                            $stmt = $db->prepare("SELECT username FROM utilisateurs WHERE id = ?");
                            $stmt->execute([$event['created_by']]);
                            $creator = $stmt->fetch();
                            echo 'Created by ' . htmlspecialchars($creator['username']) . ' on ' . date('M j, Y', strtotime($event['created_at']));
                            ?>
                        </span>
                    </div>
                </div>
                
                <div class="flex justify-end space-x-2">
                    <?php if ($is_admin || $event['created_by'] == $user_id): ?>
                        <a href="?page=calendar&action=edit&event=<?php echo $event['id']; ?>" class="bg-white px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition">Edit</a>
                        <a href="?page=calendar&action=delete&event=<?php echo $event['id']; ?>" class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition" onclick="return confirm('Are you sure you want to delete this event? This cannot be undone.')">Delete</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Add/Edit Event Modal -->
<div id="add-event-modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 <?php echo ($action === 'add' || $action === 'edit') ? '' : 'hidden'; ?>">
    <div class="bg-white rounded-lg max-w-lg w-full">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-xl font-bold"><?php echo $action === 'edit' ? 'Edit Event' : 'Add New Event'; ?></h2>
                <button onclick="document.getElementById('add-event-modal').classList.add('hidden')" class="text-gray-500 hover:text-gray-700">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            
            <form action="?page=calendar&action=<?php echo $action === 'edit' ? 'edit&event=' . $event_id : 'add'; ?>" method="POST">
                <div class="mb-4">
                    <label for="title" class="block text-sm font-medium text-gray-700 mb-1">Event Title</label>
                    <input type="text" id="title" name="title" required value="<?php echo $event ? htmlspecialchars($event['title']) : ''; ?>" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                
                <div class="mb-4">
                    <label for="description" class="block text-sm font-medium text-gray-700 mb-1">Description (optional)</label>
                    <textarea id="description" name="description" rows="3" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo $event ? htmlspecialchars($event['description']) : ''; ?></textarea>
                </div>
                
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="date" class="block text-sm font-medium text-gray-700 mb-1">Date</label>
                        <input type="date" id="event_date" name="date" required value="<?php echo $event ? $event['date'] : date('Y-m-d'); ?>" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    
                    <div x-data="{ allDay: <?php echo ($event && $event['all_day']) ? 'true' : 'false'; ?> }">
                        <div class="flex items-center justify-between mb-1">
                            <label for="time" class="block text-sm font-medium text-gray-700">Time</label>
                            <div class="flex items-center">
                                <input type="checkbox" id="all_day" name="all_day" x-model="allDay" <?php echo ($event && $event['all_day']) ? 'checked' : ''; ?> class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <label for="all_day" class="ml-2 text-sm text-gray-700">All day</label>
                            </div>
                        </div>
                        <input type="time" id="time" name="time" x-bind:disabled="allDay" value="<?php echo $event ? $event['time'] : '12:00'; ?>" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" x-bind:class="{ 'opacity-50': allDay }">
                    </div>
                </div>
                
                <div class="mb-6">
                    <label for="reminder" class="block text-sm font-medium text-gray-700 mb-1">Reminder</label>
                    <select id="reminder" name="reminder" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <option value="0" <?php echo ($event && $event['reminder'] == 0) ? 'selected' : ''; ?>>None</option>
                        <option value="15" <?php echo ($event && $event['reminder'] == 15) ? 'selected' : ''; ?>>15 minutes before</option>
                        <option value="30" <?php echo ($event && $event['reminder'] == 30) ? 'selected' : ''; ?>>30 minutes before</option>
                        <option value="60" <?php echo ($event && $event['reminder'] == 60) ? 'selected' : ''; ?>>1 hour before</option>
                        <option value="1440" <?php echo ($event && $event['reminder'] == 1440) ? 'selected' : ''; ?>>1 day before</option>
                    </select>
                </div>
                
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="document.getElementById('add-event-modal').classList.add('hidden')" class="bg-white px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition">Cancel</button>
                    <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition"><?php echo $action === 'edit' ? 'Update Event' : 'Add Event'; ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    <?php if ($action === 'add' || $action === 'edit'): ?>
    document.getElementById('add-event-modal').classList.remove('hidden');
    <?php endif; ?>
});
</script>