document.addEventListener('DOMContentLoaded', function() {
    // Liste des fichiers PHP requis pour le module Finance
    const requiredFiles = [
        'finance_tables.php',
        'get_finance_data.php',
        'get_financial_goals.php',
        'get_transactions.php',
        'get_transaction.php',
        'add_transaction.php',
        'update_transaction.php',
        'get_goal.php',
        'add_goal.php',
        'update_goal.php'
    ];

    // Container pour afficher les résultats
    const container = document.createElement('div');
    container.style.position = 'fixed';
    container.style.top = '20px';
    container.style.right = '20px';
    container.style.width = '400px';
    container.style.maxHeight = '80vh';
    container.style.overflowY = 'auto';
    container.style.backgroundColor = '#ffffff';
    container.style.color = '#000000';
    container.style.borderRadius = '10px';
    container.style.boxShadow = '0 4px 12px rgba(0, 0, 0, 0.15)';
    container.style.padding = '20px';
    container.style.zIndex = '10000';
    container.style.fontFamily = 'Arial, sans-serif';

    // Titre du rapport
    const title = document.createElement('h2');
    title.textContent = 'Vérification des fichiers Finance';
    title.style.margin = '0 0 15px 0';
    title.style.borderBottom = '1px solid #eee';
    title.style.paddingBottom = '10px';
    container.appendChild(title);

    // Conteneur pour le statut global
    const statusContainer = document.createElement('div');
    statusContainer.style.marginBottom = '20px';
    statusContainer.style.padding = '10px';
    statusContainer.style.borderRadius = '5px';
    statusContainer.style.backgroundColor = '#f8f9fa';
    statusContainer.style.border = '1px solid #dee2e6';
    statusContainer.innerHTML = '<strong>Statut global:</strong> <span id="global-status">Vérification en cours...</span>';
    container.appendChild(statusContainer);

    // Liste des fichiers
    const fileList = document.createElement('div');
    fileList.id = 'file-status-list';
    container.appendChild(fileList);

    // Bouton pour fermer le rapport
    const closeButton = document.createElement('button');
    closeButton.textContent = 'Fermer';
    closeButton.style.marginTop = '15px';
    closeButton.style.padding = '8px 15px';
    closeButton.style.backgroundColor = '#007bff';
    closeButton.style.color = 'white';
    closeButton.style.border = 'none';
    closeButton.style.borderRadius = '4px';
    closeButton.style.cursor = 'pointer';
    closeButton.onclick = function() {
        document.body.removeChild(container);
    };
    container.appendChild(closeButton);

    // Ajouter le container au document
    document.body.appendChild(container);

    // Compteurs
    let total = requiredFiles.length;
    let found = 0;
    let missing = 0;
    let errors = 0;

    // Fonction pour mettre à jour le statut global
    function updateGlobalStatus() {
        const globalStatus = document.getElementById('global-status');
        if (found === total) {
            globalStatus.textContent = 'Tous les fichiers sont présents';
            globalStatus.style.color = '#28a745';
        } else if (missing > 0) {
            globalStatus.textContent = `${missing} fichier(s) manquant(s)`;
            globalStatus.style.color = '#dc3545';
        } else if (errors > 0) {
            globalStatus.textContent = `${errors} fichier(s) avec erreurs`;
            globalStatus.style.color = '#ffc107';
        }
    }

    // Fonction pour vérifier l'existence d'un fichier
    async function checkFile(filename) {
        const fileItem = document.createElement('div');
        fileItem.style.marginBottom = '10px';
        fileItem.style.padding = '10px';
        fileItem.style.borderRadius = '5px';
        fileItem.style.border = '1px solid #dee2e6';

        try {
            const response = await fetch(filename + '?check=1', { method: 'HEAD' });
            
            if (response.ok) {
                fileItem.style.backgroundColor = '#d4edda';
                fileItem.innerHTML = `<span style="color:#28a745">✓</span> <strong>${filename}</strong>: Fichier trouvé`;
                found++;
            } else {
                fileItem.style.backgroundColor = '#f8d7da';
                fileItem.innerHTML = `<span style="color:#dc3545">✗</span> <strong>${filename}</strong>: Fichier introuvable (erreur ${response.status})`;
                missing++;
            }
        } catch (error) {
            fileItem.style.backgroundColor = '#fff3cd';
            fileItem.innerHTML = `<span style="color:#ffc107">⚠</span> <strong>${filename}</strong>: Erreur lors de la vérification - ${error.message}`;
            errors++;
        }

        fileList.appendChild(fileItem);
        updateGlobalStatus();

        // Vérifier si nous avons terminé toutes les vérifications
        if (found + missing + errors === total) {
            // Analyse supplémentaire des résultats
            const analysisResult = document.createElement('div');
            analysisResult.style.marginTop = '20px';
            analysisResult.style.padding = '15px';
            analysisResult.style.backgroundColor = '#e9ecef';
            analysisResult.style.borderRadius = '5px';
            
            if (missing > 0) {
                analysisResult.innerHTML = `
                    <h3 style="margin-top:0">Analyse</h3>
                    <p>Certains fichiers sont manquants, ce qui explique probablement pourquoi votre module Finance ne se charge pas correctement.</p>
                    <p><strong>Solution recommandée:</strong> Créez les fichiers manquants selon les instructions fournies.</p>
                `;
            } else if (errors > 0) {
                analysisResult.innerHTML = `
                    <h3 style="margin-top:0">Analyse</h3>
                    <p>Des erreurs se sont produites lors de la vérification de certains fichiers, ce qui pourrait indiquer des problèmes de permissions ou de configuration.</p>
                    <p><strong>Solution recommandée:</strong> Vérifiez les permissions des fichiers et les journaux d'erreurs du serveur.</p>
                `;
            } else {
                analysisResult.innerHTML = `
                    <h3 style="margin-top:0">Analyse</h3>
                    <p>Tous les fichiers PHP sont présents, mais le module Finance ne se charge toujours pas.</p>
                    <p><strong>Solutions recommandées:</strong></p>
                    <ul>
                        <li>Vérifiez les journaux d'erreurs PHP pour identifier d'éventuelles erreurs dans le code.</li>
                        <li>Assurez-vous que les tables de la base de données ont été créées correctement.</li>
                        <li>Vérifiez que Chart.js est correctement chargé dans votre page.</li>
                    </ul>
                `;
            }
            
            container.insertBefore(analysisResult, closeButton);
        }
    }

    // Vérifier chaque fichier
    requiredFiles.forEach(file => {
        checkFile(file);
    });

    // Vérification supplémentaire pour Chart.js
    const chartScriptCheck = document.createElement('div');
    chartScriptCheck.style.marginTop = '20px';
    chartScriptCheck.style.padding = '10px';
    chartScriptCheck.style.borderRadius = '5px';

    if (typeof Chart !== 'undefined') {
        chartScriptCheck.style.backgroundColor = '#d4edda';
        chartScriptCheck.innerHTML = `<span style="color:#28a745">✓</span> <strong>Chart.js</strong>: Bibliothèque correctement chargée (version ${Chart.version})`;
    } else {
        chartScriptCheck.style.backgroundColor = '#f8d7da';
        chartScriptCheck.innerHTML = `<span style="color:#dc3545">✗</span> <strong>Chart.js</strong>: Bibliothèque non chargée`;
    }

    container.insertBefore(chartScriptCheck, closeButton);
});