admin.php
<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('stock.json'), true) ?: [];
    
    if (isset($_POST['action'])) {
        if ($_POST['action'] === 'add') {
            $data[] = [
                'line' => $_POST['line'],
                'station' => $_POST['station'],
                'arrival' => $_POST['arrival'],
                'platform' => $_POST['platform'],
                'status' => 'on-time',
                'info' => $_POST['info']
            ];
        } elseif ($_POST['action'] === 'update') {
            $index = $_POST['index'];
            if (isset($data[$index])) {
                $data[$index]['status'] = $_POST['status'];
                $data[$index]['platform'] = $_POST['platform'];
                $data[$index]['info'] = $_POST['info'];
            }
        } elseif ($_POST['action'] === 'delete') {
            array_splice($data, $_POST['index'], 1);
        }
    }
    
    file_put_contents('stock.json', json_encode($data));
    header('Location: admin.php');
    exit;
}

$data = json_decode(file_get_contents('stock.json'), true) ?: [];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin | Horaires des Trains</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-black text-white">
    <div class="container mx-auto p-4">
        <header class="flex justify-between items-center mb-8">
            <h1 class="text-2xl font-light">Administration</h1>
            <a href="index.php" class="text-sm text-blue-400 hover:text-blue-300">← Retour à l'affichage</a>
        </header>
        
        <!-- Formulaire d'ajout -->
        <form method="POST" class="bg-gray-900 p-4 rounded mb-8">
            <input type="hidden" name="action" value="add">
            <div class="grid grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Ligne</label>
                    <input type="text" name="line" maxlength="5" 
                        class="w-full bg-gray-800 p-2 rounded border border-gray-700 focus:border-blue-500 focus:outline-none" 
                        required>
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Destination</label>
                    <input type="text" name="station" 
                        class="w-full bg-gray-800 p-2 rounded border border-gray-700 focus:border-blue-500 focus:outline-none" 
                        required>
                </div>
            </div>

            <div class="grid grid-cols-3 gap-4 mb-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Heure d'arrivée</label>
                    <input type="datetime-local" name="arrival" 
                        class="w-full bg-gray-800 p-2 rounded border border-gray-700 focus:border-blue-500 focus:outline-none text-white" 
                        required>
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Voie</label>
                    <input type="number" name="platform" min="1" max="99" 
                        class="w-full bg-gray-800 p-2 rounded border border-gray-700 focus:border-blue-500 focus:outline-none" 
                        required>
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Information</label>
                    <input type="text" name="info" 
                        class="w-full bg-gray-800 p-2 rounded border border-gray-700 focus:border-blue-500 focus:outline-none">
                </div>
            </div>

            <button type="submit" class="bg-blue-500 text-sm px-4 py-2 rounded hover:bg-blue-600">
                Ajouter un train
            </button>
        </form>
        
        <!-- Liste des trains -->
        <div id="trainList" class="space-y-3">
            <?php foreach ($data as $index => $train): 
                $arrival = new DateTime($train['arrival']);
                $now = new DateTime();
                $timeLeft = $arrival->getTimestamp() - $now->getTimestamp();
            ?>
            <div class="bg-gray-900 p-4 rounded flex items-center justify-between <?= $timeLeft < -20 ? 'opacity-50' : '' ?>">
                <div class="flex items-center gap-6">
                    <div class="px-3 py-1 bg-blue-500 rounded text-sm"><?= htmlspecialchars($train['line']) ?></div>
                    <div>
                        <div class="font-light"><?= htmlspecialchars($train['station']) ?></div>
                        <div class="text-sm text-gray-400">
                            <?= $arrival->format('H:i') ?> - 
                            Voie <?= htmlspecialchars($train['platform']) ?>
                        </div>
                    </div>
                </div>
                
                <div class="flex gap-3">
                    <form method="POST" class="flex gap-2">
                        <input type="hidden" name="action" value="update">
                        <input type="hidden" name="index" value="<?= $index ?>">
                        
                        <select name="status" class="bg-gray-800 px-2 py-1 rounded text-sm border border-gray-700">
                            <option value="on-time" <?= $train['status'] === 'on-time' ? 'selected' : '' ?>>À l'heure</option>
                            <option value="delayed" <?= $train['status'] === 'delayed' ? 'selected' : '' ?>>Retardé</option>
                        </select>
                        
                        <input type="number" name="platform" value="<?= htmlspecialchars($train['platform']) ?>" 
                            min="1" max="99" class="w-16 bg-gray-800 px-2 py-1 rounded text-sm border border-gray-700">
                        
                        <input type="text" name="info" value="<?= htmlspecialchars($train['info'] ?? '') ?>" 
                            placeholder="Info" class="w-48 bg-gray-800 px-2 py-1 rounded text-sm border border-gray-700">
                        
                        <button type="submit" class="bg-green-600 text-sm px-3 py-1 rounded hover:bg-green-700">
                            Ok
                        </button>
                    </form>
                    
                    <form method="POST" class="flex" onsubmit="return confirm('Supprimer ce train ?')">
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="index" value="<?= $index ?>">
                        <button type="submit" class="bg-red-600 text-sm px-3 py-1 rounded hover:bg-red-700">×</button>
                    </form>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    
    <script>
    document.querySelectorAll('input[type="datetime-local"]').forEach(input => {
        if (!input.value) {
            const now = new Date();
            now.setMinutes(now.getMinutes() - now.getTimezoneOffset());
            input.value = now.toISOString().slice(0,16);
        }
    });
    </script>
</body>
</html>