<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('stock.json'), true) ?: [];
    
    if (isset($_POST['action'])) {
        if ($_POST['action'] === 'add') {
            $data[] = [
                'line' => $_POST['line'],
                'station' => $_POST['station'],
                'arrival' => $_POST['arrival'],
                'status' => 'on-time'
            ];
        } elseif ($_POST['action'] === 'update') {
            $index = $_POST['index'];
            if (isset($data[$index])) {
                $data[$index]['status'] = $_POST['status'];
            }
        } elseif ($_POST['action'] === 'delete') {
            array_splice($data, $_POST['index'], 1);
        }
    }
    
    file_put_contents('stock.json', json_encode($data));
    header('Location: admin.php');
    exit;
}

$data = json_decode(file_get_contents('stock.json'), true) ?: [];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administration des Trains</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-white">
    <div class="container mx-auto p-8">
        <h1 class="text-4xl font-bold mb-8">Administration des Trains</h1>
        
        <form method="POST" class="bg-gray-800 p-6 rounded-lg mb-8">
            <input type="hidden" name="action" value="add">
            <div class="grid grid-cols-3 gap-4">
                <input type="text" name="line" placeholder="Ligne" class="bg-gray-700 p-2 rounded">
                <input type="text" name="station" placeholder="Gare" class="bg-gray-700 p-2 rounded">
                <input type="datetime-local" name="arrival" class="bg-gray-700 p-2 rounded">
            </div>
            <button type="submit" class="mt-4 bg-blue-600 px-4 py-2 rounded">Ajouter</button>
        </form>
        
        <div class="space-y-4">
            <?php foreach ($data as $index => $train): ?>
            <div class="bg-gray-800 p-6 rounded-lg flex items-center justify-between">
                <div>
                    <span class="font-bold">Ligne <?= htmlspecialchars($train['line']) ?></span> -
                    <?= htmlspecialchars($train['station']) ?> -
                    <?= (new DateTime($train['arrival']))->format('H:i') ?>
                </div>
                <div class="flex gap-4">
                    <form method="POST" class="flex items-center">
                        <input type="hidden" name="action" value="update">
                        <input type="hidden" name="index" value="<?= $index ?>">
                        <select name="status" class="bg-gray-700 p-2 rounded mr-2">
                            <option value="on-time" <?= $train['status'] === 'on-time' ? 'selected' : '' ?>>À l'heure</option>
                            <option value="delayed" <?= $train['status'] === 'delayed' ? 'selected' : '' ?>>Retardé</option>
                        </select>
                        <button type="submit" class="bg-green-600 px-4 py-2 rounded">Mettre à jour</button>
                    </form>
                    <form method="POST">
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="index" value="<?= $index ?>">
                        <button type="submit" class="bg-red-600 px-4 py-2 rounded">Supprimer</button>
                    </form>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</body>
</html>
