<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
require_once 'db.php';

$database = new Database();
$conn = $database->getConnection();

$stmt = $conn->prepare("SELECT * FROM feeds WHERE user_id = :user_id ORDER BY created_at DESC");
$stmt->bindParam(':user_id', $_SESSION['user_id']);
$stmt->execute();
$feeds = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Peerkinton - Tableau de bord</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; }
    </style>
</head>
<body class="bg-black text-white min-h-screen">
    <div class="container mx-auto p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl">Bienvenue, <?php echo htmlspecialchars($_SESSION['username']); ?></h1>
            <a href="create_feed.php" class="bg-white text-black px-4 py-2 rounded">Créer un Feed</a>
        </div>

        <div class="mt-6">
            <h2 class="text-xl mb-4">Vos Feeds</h2>
            <?php if(empty($feeds)): ?>
                <p>Aucun feed pour le moment.</p>
            <?php else: ?>
                <?php foreach($feeds as $feed): ?>
                    <div class="bg-gray-900 p-4 rounded mb-4">
                        <div class="flex justify-between">
                            <p><?php echo htmlspecialchars($feed['content']); ?></p>
                            <span class="text-sm">
                                Urgence: 
                                <?php 
                                switch($feed['urgency']) {
                                    case 'none': echo 'Aucun'; break;
                                    case 'low': echo 'Faible'; break;
                                    case 'high': echo 'Haut'; break;
                                }
                                ?>
                            </span>
                        </div>
                        <div class="text-xs mt-2">
                            <?php echo htmlspecialchars($feed['location']); ?> | 
                            <?php echo htmlspecialchars($feed['created_at']); ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <div class="mt-6">
            <a href="mesure.php" class="bg-white text-black px-4 py-2 rounded">Outil Mesure</a>
        </div>

        <form action="logout.php" method="post" class="mt-6">
            <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded">Déconnexion</button>
        </form>
    </div>
</body>
</html>