<?php
require_once 'functions.php';
checkLogin();

$search = $_GET['q'] ?? '';
$profiles = getProfiles($search);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton - Recherche de profils</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Montserrat', sans-serif;
            font-weight: 300;
        }
    </style>
</head>
<body class="bg-white text-gray-800">
    <div class="min-h-screen flex flex-col">
        <header class="bg-white shadow-sm">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 flex justify-between items-center">
                <div class="flex items-center">
                    <h1 class="text-2xl font-light">PEERKINTON</h1>
                </div>
                <nav class="flex space-x-8">
                    <a href="index.php" class="text-gray-600 hover:text-blue-600 font-light">Accueil</a>
                    <a href="search.php" class="text-blue-600 font-light">Recherche</a>
                    <a href="logout.php" class="text-gray-600 hover:text-red-600 font-light">Déconnexion</a>
                </nav>
            </div>
        </header>

        <main class="flex-grow max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
            <div class="mb-8 flex items-center justify-between">
                <h2 class="text-2xl font-light">Recherche de profils</h2>
                <a href="edit.php" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md text-sm font-light">
                    Nouveau profil
                </a>
            </div>

            <div class="mb-8">
                <form action="search.php" method="GET" class="flex">
                    <input 
                        type="text" 
                        name="q" 
                        value="<?php echo htmlspecialchars($search); ?>" 
                        placeholder="Rechercher par nom, email, téléphone, adresse..." 
                        class="flex-1 px-4 py-2 border border-gray-300 rounded-l-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                    >
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-r-md">
                        Rechercher
                    </button>
                </form>
            </div>

            <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                <?php if (empty($profiles)): ?>
                    <div class="p-10 text-center">
                        <p class="text-gray-500 mb-4">Aucun profil trouvé<?php echo !empty($search) ? ' pour la recherche "' . htmlspecialchars($search) . '"' : ''; ?></p>
                        <?php if (!empty($search)): ?>
                            <a href="search.php" class="text-blue-600 hover:text-blue-800">Afficher tous les profils</a>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nom</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Téléphone</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Profession</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date de mise à jour</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php foreach ($profiles as $profile): ?>
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="font-light"><?php echo htmlspecialchars($profile['full_name']); ?></div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-500"><?php echo htmlspecialchars($profile['email']); ?></div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-500"><?php echo htmlspecialchars($profile['phone']); ?></div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-500"><?php echo htmlspecialchars($profile['occupation']); ?></div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-500"><?php echo date('d/m/Y H:i', strtotime($profile['updated_at'])); ?></div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-light">
                                        <a href="profile.php?id=<?php echo $profile['id']; ?>" class="text-blue-600 hover:text-blue-800 mx-1">Voir</a>
                                        <a href="edit.php?id=<?php echo $profile['id']; ?>" class="text-green-600 hover:text-green-800 mx-1">Modifier</a>
                                        <button 
                                            onclick="if(confirm('Êtes-vous sûr de vouloir supprimer ce profil ?')) { window.location.href = 'profile.php?id=<?php echo $profile['id']; ?>&action=delete'; }" 
                                            class="text-red-600 hover:text-red-800 mx-1"
                                        >
                                            Supprimer
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        </main>

        <footer class="bg-white border-t border-gray-200 py-6">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <p class="text-center text-sm text-gray-500">
                    &copy; <?php echo date('Y'); ?> Peerkinton - Centre privé d'analyse de profils - Tous droits réservés
                </p>
            </div>
        </footer>
    </div>
</body>
</html>