<header class="fixed top-0 left-0 w-full z-50 px-4 py-4">
    <div class="max-w-7xl mx-auto">
        <div class="bg-white/90 backdrop-blur-md rounded-lg py-3 px-6 flex items-center justify-between">
            <a href="/" class="flex items-center">
                <img src="logo.png" alt="AndWeare Logo" class="h-8 w-auto">
            </a>
            
            <nav class="hidden md:flex items-center space-x-8">
                <a href="#" class="text-gray-600 hover:text-gray-900 transition-colors">Features</a>
                <a href="#" class="text-gray-600 hover:text-gray-900 transition-colors">Pricing</a>
                <a href="#" class="text-gray-600 hover:text-gray-900 transition-colors">Support</a>
                <a href="/hub" class="bg-black text-white rounded-full px-5 py-2 hover:bg-gray-800 transition-colors">Get Started</a>
            </nav>
            
            <button id="menuBtn" class="md:hidden text-gray-700 focus:outline-none">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                </svg>
            </button>
        </div>
    </div>
    
    <div id="mobileMenu" class="fixed inset-0 bg-black/50 backdrop-blur-lg z-50 hidden md:hidden">
        <div class="h-full w-full flex flex-col items-center justify-center">
            <button id="closeMenuBtn" class="absolute top-6 right-6 text-white">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
            
            <nav class="flex flex-col items-center space-y-8 py-8">
                <a href="#" class="text-white text-2xl font-medium opacity-0 transform translate-y-8 transition-all duration-300 menu-item">Features</a>
                <a href="#" class="text-white text-2xl font-medium opacity-0 transform translate-y-8 transition-all duration-300 menu-item">Pricing</a>
                <a href="#" class="text-white text-2xl font-medium opacity-0 transform translate-y-8 transition-all duration-300 menu-item">Support</a>
                <a href="/hub" class="bg-white text-black rounded-full px-8 py-3 text-xl font-medium opacity-0 transform translate-y-8 transition-all duration-300 menu-item">Get Started</a>
            </nav>
        </div>
    </div>
</header>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const menuBtn = document.getElementById('menuBtn');
        const closeMenuBtn = document.getElementById('closeMenuBtn');
        const mobileMenu = document.getElementById('mobileMenu');
        const menuItems = document.querySelectorAll('.menu-item');
        
        menuBtn.addEventListener('click', function() {
            mobileMenu.classList.remove('hidden');
            document.body.classList.add('overflow-hidden');
            
            setTimeout(() => {
                menuItems.forEach((item, index) => {
                    setTimeout(() => {
                        item.classList.remove('opacity-0', 'translate-y-8');
                    }, index * 100);
                });
            }, 300);
        });
        
        closeMenuBtn.addEventListener('click', function() {
            menuItems.forEach(item => {
                item.classList.add('opacity-0', 'translate-y-8');
            });
            
            setTimeout(() => {
                mobileMenu.classList.add('hidden');
                document.body.classList.remove('overflow-hidden');
            }, 500);
        });
    });
    
    window.addEventListener('scroll', function() {
        const header = document.querySelector('header');
        if (window.scrollY > 50) {
            header.classList.add('py-2');
            header.classList.remove('py-4');
        } else {
            header.classList.add('py-4');
            header.classList.remove('py-2');
        }
    });
</script>