<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Header - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/9.3.2/swiper-bundle.min.css" />
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #FFFFFF;
            background-color: #000000;
        }

        .header {
            background-color: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1002;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
            height: 70px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: fixed;
            width: 100%;
            top: 0;
        }

        .header.with-banner {
            top: 40px;
        }

        .desktop-menu { display: none; }

        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
            }

            .desktop-menu-item {
                position: relative;
                padding: 1rem;
                cursor: pointer;
                color: #FFFFFF;
                font-weight: 500;
                transition: all 0.3s ease;
                border-radius: 12px;
            }

            .desktop-menu-item:hover {
                color: rgba(255, 255, 255, 0.7);
                background: rgba(255, 255, 255, 0.1);
            }
        }

        .desktop-submenu {
            position: absolute;
            top: calc(100% + 5px);
            left: 50%;
            transform: translateX(-50%) translateY(10px);
            background-color: #000000;
            min-width: 220px;
            border-radius: 16px;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.1);
            padding: 8px;
        }

        .desktop-menu-item:hover .desktop-submenu {
            opacity: 1;
            visibility: visible;
            transform: translateX(-50%) translateY(0);
        }

        .desktop-submenu a {
            display: block;
            padding: 0.75rem 1rem;
            color: #FFFFFF;
            transition: all 0.2s ease;
            border-radius: 12px;
            text-align: center;
        }

        .desktop-submenu a:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        .mobile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            z-index: 1000;
        }

        .mobile-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000000;
            transform: translateY(-100%);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1001;
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
        }

        .mobile-menu.with-banner {
            top: 110px;
            height: calc(100vh - 110px);
        }

        .mobile-menu.active {
            transform: translateY(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu-header {
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }

        .menu-title {
            font-size: 1.25rem;
            font-weight: 600;
        }

        .mobile-menu-items {
            padding: 20px;
            padding-bottom: 40px;
        }

        .mobile-menu-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 16px;
            margin-bottom: 12px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            cursor: pointer;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .mobile-menu-item:active {
            transform: scale(0.98);
            background: rgba(255, 255, 255, 0.12);
        }

        .mobile-submenu-panel {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000000;
            z-index: 1002;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            transform: translateX(100%);
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
        }

        .mobile-submenu-panel.with-banner {
            top: 110px;
            height: calc(100vh - 110px);
        }

        .mobile-submenu-panel.active {
            transform: translateX(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-submenu-header {
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
            display: flex;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            gap: 15px;
            backdrop-filter: blur(10px);
        }

        .mobile-submenu-content {
            padding: 20px;
            padding-bottom: 40px;
        }

        .mobile-submenu-link {
            display: block;
            padding: 16px;
            margin-bottom: 12px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .mobile-submenu-link:active {
            transform: scale(0.98);
            background: rgba(255, 255, 255, 0.12);
        }

        .hamburger {
            width: 40px;
            height: 40px;
            position: relative;
            cursor: pointer;
            z-index: 1003;
            display: none;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        @media (max-width: 1023px) {
            .hamburger {
                display: flex;
            }
        }

        .hamburger span {
            display: block;
            position: absolute;
            height: 2px;
            width: 20px;
            background: #FFFFFF;
            border-radius: 2px;
            opacity: 1;
            left: 10px;
            transition: transform 0.3s ease-in-out;
        }

        .hamburger span:nth-child(1) {
            top: 14px;
            transform-origin: center;
        }

        .hamburger span:nth-child(2) {
            top: 24px;
            transform-origin: center;
        }

        .hamburger.active span:nth-child(1) {
            transform: translateY(5px) rotate(45deg);
        }

        .hamburger.active span:nth-child(2) {
            transform: translateY(-5px) rotate(-45deg);
        }

        .close-button {
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .featured-cards-section {
            padding: 20px;
            margin-bottom: 20px;
            opacity: 0;
            transform: translateY(20px);
            animation: fadeInUp 0.5s ease forwards;
        }

        .swiper {
            width: 100%;
            height: 200px;
            margin-left: auto;
            margin-right: auto;
            overflow: visible;
        }

        .swiper-slide {
            height: 180px;
            border-radius: 24px;
            padding: 20px;
            position: relative;
            overflow: hidden;
            transition: transform 0.3s ease;
        }

        .swiper-slide-active {
            transform: scale(1.02);
        }

        .card-content {
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            position: relative;
            z-index: 2;
        }

        .card-title {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 8px;
            opacity: 0;
            transform: translateY(-10px);
            animation: fadeInDown 0.5s ease forwards;
            animation-delay: 0.2s;
        }

        .card-description {
            font-size: 0.875rem;
            opacity: 0.9;
            max-width: 80%;
            opacity: 0;
            transform: translateY(10px);
            animation: fadeInUp 0.5s ease forwards;
            animation-delay: 0.4s;
        }

        .card-button {
            align-self: flex-end;
            padding: 8px 16px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 9999px;
            font-size: 0.875rem;
            font-weight: 500;
            transition: all 0.3s ease;
            opacity: 0;
            transform: translateY(10px);
            animation: fadeInUp 0.5s ease forwards;
            animation-delay: 0.6s;
        }

        .card-button:active {
            transform: scale(0.95);
            background: rgba(255, 255, 255, 0.3);
        }

        @keyframes fadeInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes fadeInDown {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .swiper-pagination {
            position: relative;
            margin-top: 15px;
        }

        .swiper-pagination-bullet {
            width: 6px;
            height: 6px;
            background: rgba(255, 255, 255, 0.3);
            opacity: 1;
        }

        .swiper-pagination-bullet-active {
            background: #FFFFFF;
            transform: scale(1.2);
        }

        .imators-account-btn {
            display: inline-flex;
            align-items: center;
            padding: 0.5rem 1rem;
            font-weight: 500;
            color: #000000;
            background-color: #FFFFFF;
            border-radius: 12px;
            transition: all 0.2s ease;
        }

        .imators-account-btn:hover {
            opacity: 0.9;
        }
    </style>
</head>
<body class="h-full">
    <header class="header fixed w-full">
        <nav class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 h-full">
            <div class="flex justify-between items-center h-full">
                <div class="flex-shrink-0 flex items-center">
                    <a href="/" class="flex items-center">
                        <img src="https://cdn.imators.com/logo.png" alt="Logo Imators" class="h-6 w-auto md:h-8">
                    </a>
                </div>

                <div class="desktop-menu items-center space-x-6">
                    <div class="desktop-menu-item">
                        Products
                        <div class="desktop-submenu">
                        <a href="https://academ.my">Academ</a>
                            <a href="/progm">Progm</a>
                            <a href="https://ohmypanel.com">OhMyPanel</a>
                            <a href="https://owtfitt.com">Owtfitt</a>
                        </div>
                    </div>
                    
                    <div class="desktop-menu-item">
                        Developer Tools
                        <div class="desktop-submenu">
                            <a href="https://imators.systems">Imators Systems</a>
                            <a href="https://developer.imators.com">Imators Developer</a>
                        </div>
                    </div>
                    <div class="desktop-menu-item">
                        Company
                        <div class="desktop-submenu">
                            <a href="/about-us">About Imators</a>
                            <a href="/contact-us">Customer Support</a>
                        </div>
                    </div>
                    <div class="desktop-menu-item">
                        Subsidiary site
                        <div class="desktop-submenu">
                            <a href="https://vertchasseur.com">Vert Chasseur</a>
                            <a href="https://cergies.com">Cergies</a>
                            <a href="https://peerkinton.com">Peerkinton</a>
                        </div>
                    </div>
                                    </div>

                <div class="flex items-center space-x-4">
                    <a href="https://idsma.imators.com" class="imators-account-btn lg:flex hidden">
                        Imators Account
                    </a>
                    <button id="hamburger" class="hamburger">
                        <span></span>
                        <span></span>
                    </button>
                </div>
            </div>
        </nav>
    </header>
    
    <div class="mobile-overlay lg:hidden"></div>

    <div class="mobile-menu lg:hidden">
        <div class="mobile-menu-header">
            <span class="menu-title">Nice to see you.</span>
        </div>

        <div class="featured-cards-section">
            <div class="swiper">
                <div class="swiper-wrapper">
                    <div class="swiper-slide" style="background: linear-gradient(135deg, #8B5CF6, #C4B5FD, #F3E8FF);">
                        <div class="card-content">
                            <div>
                                <h3 class="card-title">Academ</h3>
                                <p class="text-xs card-description">Saying goodbye to the overflow of homework in your life and hello to progress and time with your children</p>
                            </div>
                            <a href="https://academ.my" class="card-button">Learn more</a>
                        </div>
                    </div>
                    <div class="swiper-slide" style="background: linear-gradient(135deg, #FBBF24, #FEF3C7);">
                        <div class="card-content">
                            <div>
                                <h3 class="card-title">OhMyPanel</h3>
                                <p class="text-xs card-description">At last, make shopping quick and easy and dedicate your day to other things </p>
                            </div>
                            <a href="https://ohmypanel.com" class="card-button">Learn more</a>
                        </div>
                    </div>
                    <div class="swiper-slide" style="background: linear-gradient(135deg, #000000, #404040, #FFFFFF);">
                        <div class="card-content">
                            <div>
                                <h3 class="card-title">Imators Account</h3>
                                <p class="card-description">Open the door to a host of global benefits by creating an Imators account.</p>
                            </div>
                            <a href="https://idsma.imators.com" class="card-button">Explorer</a>
                        </div>
                    </div>
                    <div class="swiper-slide" style="background: linear-gradient(135deg, #1E3A8A, #3B82F6);">
                        <div class="card-content">
                            <div>
                                <h3 class="card-title">Support</h3>
                                <p class="text-xs card-description">Need help with a product? Our fast and efficient support team is here to help you and put an end to your problematic request.</p>
                            </div>
                            <a href="/contact-us" class="card-button">Help me</a>
                        </div>
                    </div>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
  
        <div class="mobile-menu-items">
            <div class="mobile-menu-item" data-submenu="products">
                <span>Products</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-menu-item" data-submenu="dev-tools">
                <span>Developer Tools</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-menu-item" data-submenu="company">
                <span>Company</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-menu-item" data-submenu="site">
                <span>Subsidiary site</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
        </div>
    </div>
    
    <div class="mobile-submenu-panel" id="products-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Products</span>
        </div>
        <div class="mobile-submenu-content">
         <a href="https://academ.my" class="mobile-submenu-link">Academ</a>
            <a href="/progm" class="mobile-submenu-link">Progm</a>
            <a href="https://ohmypanel.com" class="mobile-submenu-link">OhMyPanel</a>
            <a href="https://owtfitt.com" class="mobile-submenu-link">Owtfitt</a>
        </div>
    </div>

    <div class="mobile-submenu-panel" id="dev-tools-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Developer Tools</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="https://imators.systems" class="mobile-submenu-link">Imators Systems</a>
            <a href="https://developer.imators.com" class="mobile-submenu-link">Imators Developer</a>
        </div>
    </div>

    <div class="mobile-submenu-panel" id="company-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Company</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="/about-us" class="mobile-submenu-link">About Imators</a>
            <a href="/contact-us" class="mobile-submenu-link">Customer Support</a>
        </div>
    </div>
    
    <div class="mobile-submenu-panel" id="site-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Subsidiary site</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="https://vertchasseur.com" class="mobile-submenu-link">Vert Chasseur</a>
            <a href="https://cergies.com" class="mobile-submenu-link">Cergies</a>
            <a href="https://peerkinton.com" class="mobile-submenu-link">Peerkinton</a>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/9.3.2/swiper-bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.getElementById('hamburger');
            const mobileMenu = document.querySelector('.mobile-menu');
            const mobileOverlay = document.querySelector('.mobile-overlay');
            const closeButtons = document.querySelectorAll('.close-button');
            const menuItems = document.querySelectorAll('.mobile-menu-item');
            const header = document.querySelector('.header');
            const submenus = document.querySelectorAll('.mobile-submenu-panel');
            
            let isTransitioning = false;
            let lastScrollTop = 0;
            let scrollTimeout;

            const swiper = new Swiper('.swiper', {
                slidesPerView: 'auto',
                spaceBetween: 15,
                centeredSlides: true,
                loop: true,
                autoplay: {
                    delay: 3000,
                    disableOnInteraction: false,
                },
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },
                breakpoints: {
                    320: {
                        slidesPerView: 1.2,
                    },
                    480: {
                        slidesPerView: 1.5,
                    }
                }
            });

            const openMenu = () => {
                if (isTransitioning) return;
                document.body.style.overflow = 'hidden';
                mobileOverlay.classList.add('active');
                mobileMenu.classList.add('active');
                hamburger.classList.add('active');
                swiper.autoplay.start();
            };

            const closeMenu = () => {
                if (isTransitioning) return;
                document.body.style.overflow = '';
                mobileOverlay.classList.remove('active');
                mobileMenu.classList.remove('active');
                hamburger.classList.remove('active');
                submenus.forEach(submenu => {
                    submenu.classList.remove('active');
                });
                swiper.autoplay.stop();
            };

            hamburger.addEventListener('click', () => {
                mobileMenu.classList.contains('active') ? closeMenu() : openMenu();
            });

            closeButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const submenuPanel = button.closest('.mobile-submenu-panel');
                    if (submenuPanel) {
                        submenuPanel.classList.remove('active');
                    } else {
                        closeMenu();
                    }
                });
            });

            mobileOverlay.addEventListener('click', closeMenu);

            menuItems.forEach(item => {
                item.addEventListener('click', () => {
                    if (isTransitioning) return;
                    isTransitioning = true;

                    const submenuId = item.getAttribute('data-submenu') + '-submenu';
                    const submenu = document.getElementById(submenuId);

                    if (submenu) {
                        submenu.classList.add('active');
                    }

                    setTimeout(() => {
                        isTransitioning = false;
                    }, 300);
                });
            });

            window.addEventListener('scroll', () => {
                clearTimeout(scrollTimeout);
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;

                header.style.backgroundColor = scrollTop > 0 ? 
                    'rgba(0, 0, 0, 0.98)' : 'rgba(0, 0, 0, 0.95)';

                if (!mobileMenu.classList.contains('active') && Math.abs(scrollTop - lastScrollTop) > 50) {
                    header.style.transform = scrollTop > lastScrollTop && scrollTop > header.offsetHeight ? 
                        'translateY(-100%)' : 'translateY(0)';
                    lastScrollTop = scrollTop;
                }

                scrollTimeout = setTimeout(() => {
                    header.style.transform = 'translateY(0)';
                }, 1000);
            });

            let touchStartY = 0;
            mobileMenu.addEventListener('touchstart', (e) => {
                touchStartY = e.touches[0].clientY;
            }, { passive: true });

            mobileMenu.addEventListener('touchmove', (e) => {
                if (!touchStartY) return;
                const touchEndY = e.touches[0].clientY;
                const deltaY = touchEndY - touchStartY;

                if (deltaY > 70) {
                    closeMenu();
                    touchStartY = null;
                }
            }, { passive: true });
        });
    </script>
    
</body>
</html>