<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>
<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #fff;
            background: #000;
            margin: 0;
            line-height: 1.5;
        }

        .header {
            backdrop-filter: blur(10px);
            background: rgba(0, 0, 0, 0.9);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            height: 70px;
            position: fixed;
            top: 0;
            transition: all 0.3s;
            width: 100%;
            z-index: 1002;
        }

        @media (min-width: 1024px) {
            .header {
                height: 90px;
            }
        }

        .header-transparent {
            background: transparent;
            backdrop-filter: none;
            border-bottom: none;
        }

        .header-transparent.scrolled {
            background: rgba(0, 0, 0, 0.9);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .header-content {
            align-items: center;
            display: flex;
            height: 100%;
            justify-content: space-between;
        }

        .logo img {
            height: 28px;
            transition: all 0.3s;
        }

        @media (min-width: 1024px) {
            .logo img {
                height: 36px;
            }
        }

        .desktop-nav {
            display: none;
        }

        @media (min-width: 1024px) {
            .desktop-nav {
                display: flex;
                gap: 30px;
            }

            .nav-item {
                border-radius: 8px;
                cursor: pointer;
                font-weight: 400;
                padding: 10px 15px;
                position: relative;
                transition: all 0.3s;
            }

            .nav-item:hover {
                background: rgba(255, 255, 255, 0.1);
            }
        }

        .fullscreen-overlay {
            backdrop-filter: blur(20px);
            background: rgba(0, 0, 0, 0.8);
            height: 100vh;
            left: 0;
            opacity: 0;
            position: fixed;
            top: 0;
            transition: all 0.4s;
            visibility: hidden;
            width: 100%;
            z-index: 2000;
        }

        .fullscreen-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .overlay-content {
            margin: 90px auto 0;
            max-width: 1200px;
            padding: 0 30px;
            width: 100%;
        }

        .overlay-panel {
            background: rgba(15, 15, 15, 0.7);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
            overflow: hidden;
        }

        .overlay-header {
            align-items: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            display: flex;
            justify-content: space-between;
            padding: 20px 30px;
        }

        .overlay-title {
            font-size: 1.5rem;
            font-weight: 600;
        }

        .close-btn {
            align-items: center;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            display: flex;
            height: 40px;
            justify-content: center;
            transition: all 0.2s;
            width: 40px;
        }

        .close-btn:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .overlay-body {
            display: flex;
            padding: 30px;
        }

        .overlay-links {
            display: grid;
            flex: 1;
            gap: 15px;
            grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
        }

        .overlay-link {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            padding: 20px;
            transition: all 0.3s;
        }

        .overlay-link:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: translateY(-3px);
        }

        .link-title {
            font-weight: 600;
            margin-bottom: 5px;
        }

        .link-desc {
            font-size: 0.875rem;
            opacity: 0.7;
        }

        .stories-section {
            border-left: 1px solid rgba(255, 255, 255, 0.1);
            margin-left: 30px;
            padding-left: 30px;
            width: 350px;
        }

        .stories-title {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .stories-grid {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .story-item {
            background-position: center;
            background-size: cover;
            border-radius: 16px;
            cursor: pointer;
            height: 180px;
            overflow: hidden;
            position: relative;
            transition: transform 0.3s;
        }

        .story-item:hover {
            transform: scale(1.03);
        }

        .story-overlay {
            background: linear-gradient(transparent, rgba(0, 0, 0, 0.8));
            bottom: 0;
            left: 0;
            padding: 20px;
            position: absolute;
            width: 100%;
        }

        .story-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .story-desc {
            font-size: 0.875rem;
            opacity: 0.8;
        }

        .hamburger {
            align-items: center;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: none;
            height: 40px;
            justify-content: center;
            position: relative;
            transition: all 0.3s;
            width: 40px;
            z-index: 1003;
        }

        @media (max-width: 1023px) {
            .hamburger {
                display: flex;
            }
        }

        .hamburger span {
            background: #fff;
            border-radius: 2px;
            display: block;
            height: 2px;
            position: absolute;
            transition: all 0.3s;
            width: 20px;
        }

        .hamburger span:first-child {
            top: 14px;
        }

        .hamburger span:last-child {
            top: 24px;
        }

        .hamburger.active span:first-child {
            transform: translateY(5px) rotate(45deg);
        }

        .hamburger.active span:last-child {
            transform: translateY(-5px) rotate(-45deg);
        }

        .mobile-menu {
            background: #000;
            height: calc(100vh - 70px);
            left: 0;
            opacity: 0;
            overflow-y: auto;
            position: fixed;
            top: 70px;
            transform: translateY(-100%);
            transition: all 0.3s;
            visibility: hidden;
            width: 100%;
            z-index: 1001;
        }

        .mobile-menu.active {
            opacity: 1;
            transform: translateY(0);
            visibility: visible;
        }

        .mobile-header {
            align-items: center;
            background: #000;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            display: flex;
            justify-content: space-between;
            padding: 15px 20px;
            position: sticky;
            top: 0;
            z-index: 2;
        }

        .mobile-title {
            font-size: 1.2rem;
            font-weight: 600;
        }

        .nav-section {
            padding: 20px;
        }

        .nav-section-title {
            font-size: 0.875rem;
            font-weight: 500;
            margin-bottom: 15px;
            opacity: 0.7;
            text-transform: uppercase;
        }

        .nav-grid {
            display: grid;
            gap: 12px;
            grid-template-columns: repeat(1, 1fr);
        }

        .nav-card {
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.07);
            border-radius: 12px;
            display: flex;
            padding: 15px;
            transition: all 0.2s;
        }

        .nav-card:active {
            background: rgba(255, 255, 255, 0.07);
        }

        .nav-icon {
            align-items: center;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            display: flex;
            height: 40px;
            justify-content: center;
            margin-right: 15px;
            width: 40px;
        }

        .nav-content {
            flex: 1;
        }

        .nav-card-title {
            font-weight: 600;
            margin-bottom: 2px;
        }

        .nav-card-desc {
            font-size: 0.75rem;
            opacity: 0.7;
        }

        .mobile-stories {
            display: grid;
            gap: 10px;
            grid-template-columns: repeat(4, 100px);
            margin: 10px 0 20px;
            overflow-x: auto;
            padding: 0 20px 10px;
            scrollbar-width: none;
        }

        .mobile-stories::-webkit-scrollbar {
            display: none;
        }

        .story-circle {
            border-radius: 15px;
            height: 100px;
            overflow: hidden;
            position: relative;
            width: 100px;
        }

        .story-circle img {
            height: 100%;
            object-fit: cover;
            width: 100%;
        }

        .story-label {
            font-size: 0.75rem;
            margin-top: 5px;
            text-align: center;
        }

        .mobile-backdrop {
            backdrop-filter: blur(5px);
            background: rgba(0, 0, 0, 0.5);
            height: 100%;
            left: 0;
            opacity: 0;
            position: fixed;
            top: 0;
            transition: all 0.3s;
            visibility: hidden;
            width: 100%;
            z-index: 1000;
        }

        .mobile-backdrop.active {
            opacity: 1;
            visibility: visible;
        }

        .account-btn {
            background: #fff;
            border-radius: 8px;
            color: #000;
            display: none;
            font-weight: 500;
            padding: 8px 16px;
            transition: all 0.2s;
        }

        @media (min-width: 1024px) {
            .account-btn {
                display: block;
            }
        }

        .account-btn:hover {
            opacity: 0.9;
        }
    </style>
</head>
<body class="h-full">
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 header-content">
            <div class="logo">
                <a href="/">
                    <img src="https://cdn.imators.com/logo.png" alt="Imators">
                </a>
            </div>

            <div class="desktop-nav">
                <div class="nav-item" data-overlay="products">Products</div>
                <div class="nav-item" data-overlay="developer">Developer Tools</div>
                <div class="nav-item" data-overlay="company">Company</div>
            </div>

            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="account-btn">Imators Account</a>
                <button id="hamburger" class="hamburger">
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>
    </header>

    <!-- Desktop Overlays -->
    <div class="fullscreen-overlay" id="products-overlay">
        <div class="overlay-content">
            <div class="overlay-panel">
                <div class="overlay-header">
                    <h3 class="overlay-title">Products</h3>
                    <button class="close-btn" data-close="overlay">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M18 6L6 18M6 6l12 12" />
                        </svg>
                    </button>
                </div>
                <div class="overlay-body">
                    <div class="overlay-links">
                        <a href="https://academ.my" class="overlay-link">
                            <div class="link-title">Academ</div>
                            <div class="link-desc">Say goodbye to homework overflow</div>
                        </a>
                        <a href="/progm" class="overlay-link">
                            <div class="link-title">Progm</div>
                            <div class="link-desc">Program management simplified</div>
                        </a>
                        <a href="https://ohmypanel.com" class="overlay-link">
                            <div class="link-title">OhMyPanel</div>
                            <div class="link-desc">Quick & easy shopping</div>
                        </a>
                        <a href="https://owtfitt.com" class="overlay-link">
                            <div class="link-title">Owtfitt</div>
                            <div class="link-desc">Premium fashion outfits</div>
                        </a>
                        <a href="https://imators.systems/traffic" class="overlay-link">
                            <div class="link-title">TrafficLight</div>
                            <div class="link-desc">Intelligent traffic management</div>
                        </a>
                    </div>
                    
                    <div class="stories-section">
                        <h4 class="stories-title">Stories</h4>
                        <div class="stories-grid">
                            <div class="story-item" style="background-image: url('https://cdn.imators.com/story1.jpg')">
                                <div class="story-overlay">
                                    <h5 class="story-title">Academ Success</h5>
                                    <p class="story-desc">See how Academ transforms education</p>
                                </div>
                            </div>
                            <div class="story-item" style="background-image: url('https://cdn.imators.com/story2.jpg')">
                                <div class="story-overlay">
                                    <h5 class="story-title">TrafficLight Impact</h5>
                                    <p class="story-desc">Smart traffic solutions in action</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="fullscreen-overlay" id="developer-overlay">
        <div class="overlay-content">
            <div class="overlay-panel">
                <div class="overlay-header">
                    <h3 class="overlay-title">Developer Tools</h3>
                    <button class="close-btn" data-close="overlay">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M18 6L6 18M6 6l12 12" />
                        </svg>
                    </button>
                </div>
                <div class="overlay-body">
                    <div class="overlay-links">
                        <a href="https://imators.systems" class="overlay-link">
                            <div class="link-title">Imators Systems</div>
                            <div class="link-desc">Enterprise-grade systems</div>
                        </a>
                        <a href="https://developer.imators.com" class="overlay-link">
                            <div class="link-title">Imators Developer</div>
                            <div class="link-desc">Developer resources & APIs</div>
                        </a>
                        <a href="https://imators.systems/traffic" class="overlay-link">
                            <div class="link-title">TrafficLight</div>
                            <div class="link-desc">Traffic management API</div>
                        </a>
                    </div>
                    
                    <div class="stories-section">
                        <h4 class="stories-title">Stories</h4>
                        <div class="stories-grid">
                            <div class="story-item" style="background-image: url('https://cdn.imators.com/dev1.jpg')">
                                <div class="story-overlay">
                                    <h5 class="story-title">Developer Journey</h5>
                                    <p class="story-desc">Building with Imators tools</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="fullscreen-overlay" id="company-overlay">
        <div class="overlay-content">
            <div class="overlay-panel">
                <div class="overlay-header">
                    <h3 class="overlay-title">Company</h3>
                    <button class="close-btn" data-close="overlay">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M18 6L6 18M6 6l12 12" />
                        </svg>
                    </button>
                </div>
                <div class="overlay-body">
                    <div class="overlay-links">
                        <a href="/support" class="overlay-link">
                            <div class="link-title">Support</div>
                            <div class="link-desc">Get help with our products</div>
                        </a>
                        <a href="/contact-us" class="overlay-link">
                            <div class="link-title">Contact us</div>
                            <div class="link-desc">Reach out to our team</div>
                        </a>
                        <a href="/about-us" class="overlay-link">
                            <div class="link-title">About Imators</div>
                            <div class="link-desc">Our mission and vision</div>
                        </a>
                    </div>
                    
                    <div class="stories-section">
                        <h4 class="stories-title">Stories</h4>
                        <div class="stories-grid">
                            <div class="story-item" style="background-image: url('https://cdn.imators.com/company1.jpg')">
                                <div class="story-overlay">
                                    <h5 class="story-title">Our Journey</h5>
                                    <p class="story-desc">The story of Imators</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div class="mobile-backdrop"></div>

    <div class="mobile-menu">
        <div class="mobile-header">
            <h2 class="mobile-title">Imators</h2>
        </div>
        
        <div class="mobile-stories">
            <div class="story-wrapper">
                <div class="story-circle" style="background-color: #8B5CF6;">
                    <a href="https://academ.my"></a>
                </div>
                <div class="story-label">Academ</div>
            </div>
            <div class="story-wrapper">
                <div class="story-circle" style="background-color: #F59E0B;">
                    <a href="/progm"></a>
                </div>
                <div class="story-label">Progm</div>
            </div>
            <div class="story-wrapper">
                <div class="story-circle" style="background-color: #10B981;">
                    <a href="https://ohmypanel.com"></a>
                </div>
                <div class="story-label">OhMyPanel</div>
            </div>
            <div class="story-wrapper">
                <div class="story-circle" style="background-color: #EF4444;">
                    <a href="https://owtfitt.com"></a>
                </div>
                <div class="story-label">Owtfitt</div>
            </div>
            <div class="story-wrapper">
                <div class="story-circle" style="background-color: #3B82F6;">
                    <a href="https://imators.systems/traffic"></a>
                </div>
                <div class="story-label">TrafficLight</div>
            </div>
        </div>

        <div class="nav-section">
            <h3 class="nav-section-title">Products</h3>
            <div class="nav-grid">
                <a href="https://academ.my" class="nav-card">
                    <div class="nav-icon" style="background-color: rgba(139, 92, 246, 0.2);">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#8B5CF6" stroke-width="2">
                            <path d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" />
                        </svg>
                    </div>
                    <div class="nav-content">
                        <div class="nav-card-title">Academ</div>
                        <div class="nav-card-desc">Education without homework overflow</div>
                    </div>
                </a>
                
                <a href="/progm" class="nav-card">
                    <div class="nav-icon" style="background-color: rgba(245, 158, 11, 0.2);">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#F59E0B" stroke-width="2">
                            <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01" />
                        </svg>
                    </div>
                    <div class="nav-content">
                        <div class="nav-card-title">Progm</div>
                        <div class="nav-card-desc">Program management simplified</div>
                    </div>
                </a>
                
                <a href="https://ohmypanel.com" class="nav-card">
                    <div class="nav-icon" style="background-color: rgba(16, 185, 129, 0.2);">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#10B981" stroke-width="2">
                            <path d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                        </svg>
                    </div>
                    <div class="nav-content">
                        <div class="nav-card-title">OhMyPanel</div>
                        <div class="nav-card-desc">Quick & easy shopping</div>
                    </div>
                </a>
                
                <a href="https://owtfitt.com" class="nav-card">
                    <div class="nav-icon" style="background-color: rgba(239, 68, 68, 0.2);">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#EF4444" stroke-width="2">
                            <path d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                        </svg>
                    </div>
                    <div class="nav-content">
                        <div class="nav-card-title">Owtfitt</div>
                        <div class="nav-card-desc">Premium fashion outfits</div>
                    </div>
                </a>
                
                <a href="https://imators.systems/traffic" class="nav-card">
                    <div class="nav-icon" style="background-color: rgba(59, 130, 246, 0.2);">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#3B82F6" stroke-width="2">
                            <path d="M11 3.055A9.001 9.001 0 1020.945 13H11V3.055z" />
                            <path d="M20.488 9H15V3.512A9.025 9.025 0 0120.488 9z" />
                        </svg>
                    </div>
                    <div class="nav-content">
                        <div class="nav-card-title">TrafficLight</div>
                        <div class="nav-card-desc">Intelligent traffic management</div>
                    </div>
                </a>
            </div>
        </div>
        
        <div class="nav-section">
            <h3 class="nav-section-title">Developer Tools</h3>
            <div class="nav-grid">
                <a href="https://imators.systems" class="nav-card">
                    <div class="nav-icon" style="background-color: rgba(124, 58, 237, 0.2);">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#7C3AED" stroke-width="2">
                            <path d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4" />
                        </svg>
                    </div>
                    <div class="nav-content">
                        <div class="nav-card-title">Imators Systems</div>
                        <div class="nav-card-desc">Enterprise-grade systems</div>
                    </div>
                </a>
                
                <a href="https://developer.imators.com" class="nav-card">
                    <div class="nav-icon" style="background-color: rgba(37, 99, 235, 0.2);">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#2563EB" stroke-width="2">
                            <path d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4" />
                        </svg>
                    </div>
                    <div class="nav-content">
                        <div class="nav-card-title">Imators Developer</div>
                        <div class="nav-card-desc">Developer tools & APIs</div>
                    </div>
                </a>
                
                <a href="https://imators.systems/traffic" class="nav-card">
                    <div class="nav-icon" style="background-color: rgba(59, 130, 246, 0.2);">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#3B82F6" stroke-width="2">
                            <path d="M11 3.055A9.001 9.001 0 1020.945 13H11V3.055z" />
                            <path d="M20.488 9H15V3.512A9.025 9.025 0 0120.488 9z" />
                        </svg>
                    </div>
                    <div class="nav-content">
                        <div class="nav-card-title">TrafficLight</div>
                        <div class="nav-card-desc">Traffic management API</div>
                    </div>
                </a>
            </div>
        </div>
        
        <div class="nav-section">
            <h3 class="nav-section-title">Company</h3>
            <div class="nav-grid">
                <a href="/support" class="nav-card">
                    <div class="nav-icon" style="background-color: rgba(16, 185, 129, 0.2);">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#10B981" stroke-width="2">
                            <path d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                    </div>
                    <div class="nav-content">
                        <div class="nav-card-title">Support</div>
                        <div class="nav-card-desc">Get help with our products</div>
                    </div>
                </a>
                
                <a href="/contact-us" class="nav-card">
                    <div class="nav-icon" style="background-color: rgba(239, 68, 68, 0.2);">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#EF4444" stroke-width="2">
                            <path d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                        </svg>
                    </div>
                    <div class="nav-content">
                        <div class="nav-card-title">Contact us</div>
                        <div class="nav-card-desc">Reach out to our team</div>
                    </div>
                </a>
                
                <a href="/about-us" class="nav-card">
                    <div class="nav-icon" style="background-color: rgba(245, 158, 11, 0.2);">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#F59E0B" stroke-width="2">
                            <path d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                        </svg>
                    </div>
                    <div class="nav-content">
                        <div class="nav-card-title">About Imators</div>
                        <div class="nav-card-desc">Our mission and vision</div>
                    </div>
                </a>
            </div>
        </div>
        
        <div class="nav-section">
            <a href="https://idsma.imators.com" class="nav-card">
                <div class="nav-icon" style="background-color: rgba(139, 92, 246, 0.2);">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#8B5CF6" stroke-width="2">
                        <path d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                    </svg>
                </div>
                <div class="nav-content">
                    <div class="nav-card-title">Imators Account</div>
                    <div class="nav-card-desc">Manage your account and access benefits</div>
                </div>
            </a>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const header = document.querySelector('.header');
            const hamburger = document.getElementById('hamburger');
            const mobileMenu = document.querySelector('.mobile-menu');
            const mobileBackdrop = document.querySelector('.mobile-backdrop');
            const navItems = document.querySelectorAll('.nav-item');
            const overlays = document.querySelectorAll('.fullscreen-overlay');
            const closeButtons = document.querySelectorAll('[data-close="overlay"]');
            
            let lastScrollTop = 0;
            let scrollTimeout;
            let activeOverlay = null;
            
            // Scroll handling
            window.addEventListener('scroll', function() {
                clearTimeout(scrollTimeout);
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                // Handle transparent header
                if (header.classList.contains('header-transparent')) {
                    if (scrollTop > 0) {
                        header.classList.add('scrolled');
                    } else {
                        header.classList.remove('scrolled');
                    }
                }
                
                // Auto-hide header on scroll
                if (!mobileMenu.classList.contains('active') && 
                    !activeOverlay && 
                    Math.abs(scrollTop - lastScrollTop) > 50) {
                    header.style.transform = scrollTop > lastScrollTop && scrollTop > header.offsetHeight ? 
                        'translateY(-100%)' : 'translateY(0)';
                    lastScrollTop = scrollTop;
                }
                
                // Show header after scroll stops
                scrollTimeout = setTimeout(() => {
                    header.style.transform = 'translateY(0)';
                }, 1000);
            });
            
            // Mobile menu toggle
            hamburger.addEventListener('click', function() {
                if (mobileMenu.classList.contains('active')) {
                    closeMobileMenu();
                } else {
                    openMobileMenu();
                }
            });
            
            // Mobile backdrop click to close
            mobileBackdrop.addEventListener('click', closeMobileMenu);
            
            // Desktop menu overlay toggle
            navItems.forEach(item => {
                item.addEventListener('click', function(e) {
                    e.stopPropagation();
                    
                    const overlayId = this.getAttribute('data-overlay');
                    const overlay = document.getElementById(overlayId + '-overlay');
                    
                    if (overlay) {
                        // Close any active overlay
                        if (activeOverlay && activeOverlay !== overlay) {
                            closeOverlay(activeOverlay);
                        }
                        
                        // Toggle current overlay
                        if (overlay.classList.contains('active')) {
                            closeOverlay(overlay);
                        } else {
                            openOverlay(overlay);
                        }
                    }
                });
            });
            
            // Close overlay with close button
            closeButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const overlay = this.closest('.fullscreen-overlay');
                    if (overlay) {
                        closeOverlay(overlay);
                    }
                });
            });
            
            // Close overlay when clicking outside
            document.addEventListener('click', function(e) {
                if (activeOverlay && 
                    !e.target.closest('.nav-item') && 
                    !e.target.closest('.overlay-panel')) {
                    closeOverlay(activeOverlay);
                }
            });
            
            // ESC key to close overlays and menus
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    if (activeOverlay) {
                        closeOverlay(activeOverlay);
                    } else if (mobileMenu.classList.contains('active')) {
                        closeMobileMenu();
                    }
                }
            });
            
            // Mobile swipe down to close
            let touchStartY = 0;
            mobileMenu.addEventListener('touchstart', function(e) {
                touchStartY = e.touches[0].clientY;
            }, { passive: true });
            
            mobileMenu.addEventListener('touchmove', function(e) {
                const touchEndY = e.touches[0].clientY;
                const deltaY = touchEndY - touchStartY;
                
                if (deltaY > 70) {
                    closeMobileMenu();
                    touchStartY = 0;
                }
            }, { passive: true });
            
            // Story circle clicks
            const storyCircles = document.querySelectorAll('.story-circle');
            storyCircles.forEach(circle => {
                circle.addEventListener('click', function() {
                    const link = this.querySelector('a');
                    if (link) {
                        window.location.href = link.getAttribute('href');
                    }
                });
            });
            
            // Story items clicks on desktop
            const storyItems = document.querySelectorAll('.story-item');
            storyItems.forEach(item => {
                item.addEventListener('click', function() {
                    window.location.href = '#story-detail';
                });
            });
            
            // Helper functions
            function openMobileMenu() {
                document.body.style.overflow = 'hidden';
                mobileBackdrop.classList.add('active');
                mobileMenu.classList.add('active');
                hamburger.classList.add('active');
            }
            
            function closeMobileMenu() {
                document.body.style.overflow = '';
                mobileBackdrop.classList.remove('active');
                mobileMenu.classList.remove('active');
                hamburger.classList.remove('active');
            }
            
            function openOverlay(overlay) {
                document.body.style.overflow = 'hidden';
                overlay.classList.add('active');
                activeOverlay = overlay;
            }
            
            function closeOverlay(overlay) {
                document.body.style.overflow = '';
                overlay.classList.remove('active');
                activeOverlay = null;
            }
        });
    </script>
</body>
</html>