<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once __DIR__ . '/../vendor/autoload.php';

use Firebase\JWT\JWT;

$envFile = __DIR__ . '/../.env';
if (file_exists($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos($line, '=') !== false && strpos($line, '#') !== 0) {
            list($key, $value) = explode('=', $line, 2);
            $value = trim($value, '"');
            $_ENV[trim($key)] = $value;
        }
    }
}

try {
    $teamId = $_ENV['APPLE_TEAM_ID'];
    $serviceId = $_ENV['APPLE_SERVICE_ID'];
    $keyId = $_ENV['APPLE_KEY_ID'];
    $privateKey = $_ENV['APPLE_PRIVATE_KEY'];
    
    if (!$teamId || !$serviceId || !$keyId || !$privateKey) {
        throw new Exception('Variables d\'environnement manquantes');
    }
    
    $header = [
        'alg' => 'ES256',
        'kid' => $keyId,
        'id' => "$teamId.$serviceId"
    ];
    
    $payload = [
        'iss' => $teamId,
        'iat' => time(),
        'exp' => time() + 3600,
        'sub' => $serviceId
    ];
    
    $key = openssl_pkey_get_private($privateKey);
    if (!$key) {
        throw new Exception('Clé privée invalide');
    }
    
    $jwt = JWT::encode($payload, $key, 'ES256', $keyId, $header);
    
    $latitude = 50.7976;
    $longitude = 4.3447;
    $url = "https://weatherkit.apple.com/api/v1/weather/fr/$latitude/$longitude?dataSets=currentWeather&timezone=Europe/Brussels";
    
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer $jwt",
            'Content-Type: application/json'
        ],
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_USERAGENT => 'VertChasseur/1.0'
    ]);
    
    $response = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $error = curl_error($curl);
    curl_close($curl);
    
    if ($error) {
        throw new Exception("Erreur cURL: $error");
    }
    
    if ($httpCode !== 200) {
        throw new Exception("Erreur HTTP $httpCode: $response");
    }
    
    $data = json_decode($response, true);
    
    if ($data && isset($data['currentWeather']['temperature'])) {
        $temperature = round($data['currentWeather']['temperature']);
        echo json_encode(['success' => true, 'temperature' => $temperature]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Données météo non trouvées', 'response' => $data]);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>