<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        header {
            background-color: rgba(0, 0, 0, 0.8);
            transition: background-color 0.5s;
        }
        
        .support-card {
            transition: all 0.3s ease;
            border: 1px solid #333;
        }
        
        .support-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px -5px rgba(255, 255, 255, 0.1), 0 10px 10px -5px rgba(255, 255, 255, 0.04);
        }
        
        .icon-container {
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background-color: #FFFFFF;
            color: #000000;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <!-- Header would be included here -->
    <?php include 'src/header.php'; ?>

    <!-- Hero Section -->
    <section class="py-20">
        <div class="container px-4 mx-auto">
            <div class="max-w-3xl mx-auto text-center mb-16">
                <h1 class="text-4xl lg:text-5xl mt-24 text-left font-bold mb-6">Support.</h1>
                <p class="text-xl text-left text-gray-400">This page contains everything you need to contact us at the right address. </p>
            </div>
        </div>
    </section>

    <!-- Support Categories -->
    <section class="py-2">
        <div class="container px-4 mx-auto">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-5xl mx-auto">
                
                <!-- Hardware Support -->
                <div class="support-card bg-black p-8 rounded-xl text-center">
                    <div class="icon-container mx-auto">
                        <i class="fas fa-tools text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Hardware Support</h3>
                    <p class="text-gray-400 mb-6">Technical issues with any of our products purchased from a Cergies Store by Imators.</p>
                    <div class="bg-black p-4 rounded-lg border border-gray-700 mb-4">
                        <p class="text-sm text-gray-300"><i class="fas fa-info-circle mr-2"></i> Account required for this support channel</p>
                    </div>
                    <a href="/account/support" class="inline-block bg-white text-black font-medium px-6 py-3 rounded-lg hover:bg-gray-200 transition-colors w-full text-center">Access Support Portal</a>
                </div>
                
                <!-- Press Support -->
                <div class="support-card bg-black p-8 rounded-xl text-center">
                    <div class="icon-container mx-auto">
                        <i class="fas fa-newspaper text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Press Inquiries</h3>
                    <p class="text-gray-400 mb-6">For interview requests or article placement, contact our press team directly.</p>
                    <div class="bg-black p-4 rounded-lg border border-gray-700 mb-4">
                        <a href="mailto:press@imators.com" class="text-white hover:text-gray-300 transition-colors"><i class="fas fa-envelope mr-2"></i> press@imators.com</a>
                    </div>
                    <a href="mailto:press@imators.com" class="inline-block bg-white text-black font-medium px-6 py-3 rounded-lg hover:bg-gray-200 transition-colors w-full text-center">Contact Press Team</a>
                </div>
                
                <!-- Technical Support -->
                <div class="support-card bg-black p-8 rounded-xl text-center">
                    <div class="icon-container mx-auto">
                        <i class="fas fa-network-wired text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Technical Support</h3>
                    <p class="text-gray-400 mb-6">For network issues or service unavailability due to various causes.</p>
                    <div class="bg-black p-4 rounded-lg border border-gray-700 mb-4">
                        <p class="text-sm text-gray-300"><i class="fas fa-info-circle mr-2"></i> Account required for this support channel</p>
                    </div>
                    <a href="/account/support" class="inline-block bg-white text-black font-medium px-6 py-3 rounded-lg hover:bg-gray-200 transition-colors w-full text-center">Access Support Portal</a>
                </div>
                
                <!-- Community Forum -->
                <div class="support-card bg-black p-8 rounded-xl text-center md:col-span-3">
                    <div class="icon-container mx-auto">
                        <i class="fas fa-comments text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Community Forum</h3>
                    <p class="text-gray-400 mb-6">Join our community forum to find answers, share experiences, and connect with other Imators users.</p>
                    <a href="/forum" class="inline-block bg-white text-black font-medium px-6 py-3 rounded-lg hover:bg-gray-200 transition-colors w-full max-w-md mx-auto text-center">Visit Forum</a>
                </div>
                
            </div>
        </div>
    </section>

    <!-- Quick Help Section -->
    <section class="py-16">
        <div class="container px-4 mx-auto">
            <div class="max-w-3xl mx-auto bg-black border border-gray-800 rounded-xl p-8">
                <h2 class="text-2xl font-bold mb-6 text-center">Need Quick Help?</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                    <div class="border border-gray-800 p-6 rounded-xl hover:border-gray-600 transition-colors">
                        <h3 class="text-lg font-semibold mb-3"><i class="fas fa-book mr-2"></i> Knowledge Base</h3>
                        <p class="text-gray-400 mb-4">Browse our extensive knowledge base for guides and solutions to common issues.</p>
                        <a href="/kb" class="text-white font-medium hover:text-gray-300 transition-colors">Explore Knowledge Base →</a>
                    </div>
                    
                    <div class="border border-gray-800 p-6 rounded-xl hover:border-gray-600 transition-colors">
                        <h3 class="text-lg font-semibold mb-3"><i class="fas fa-download mr-2"></i> Downloads</h3>
                        <p class="text-gray-400 mb-4">Access manuals, software updates, and drivers for Imators products.</p>
                        <a href="/downloads" class="text-white font-medium hover:text-gray-300 transition-colors">Go to Downloads →</a>
                    </div>
                </div>
                
                <div class="text-center">
                    <p class="text-gray-400 mb-4">Still can't find what you're looking for?</p>
                    <a href="/contact" class="inline-block bg-white text-black font-medium px-6 py-3 rounded-lg hover:bg-gray-200 transition-colors">Contact Us</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Support Hours -->
    <section class="py-12">
        <div class="container px-4 mx-auto">
            <div class="max-w-3xl mx-auto text-center">
                <h2 class="text-2xl font-bold mb-6">Support Hours</h2>
                <div class="bg-black border border-gray-800 rounded-xl p-6">
                    <p class="mb-4"><i class="far fa-clock mr-2"></i> Everyday : 9:00 AM - 6:00 PM GMT</p>
                    <p class="text-gray-400 text-sm">Our support team is available during these hours. For urgent issues outside of these hours, please use our ticket system, and we'll respond as soon as possible.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
            <h5 class="text-xs uppercase font-medium mb-6">Follow Us</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/itsimators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
                <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Privacy Policy</a>
                <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Terms of Use</a>
                <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Home</a>
                <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">About Us</a>
                <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Contact Us</a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Possible reality</h5>
                <p class="text-sm">All images, videos, and content on this site are the property of Imators.</p>
            </div>
        </div>
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">&copy; 2025 Imators. All rights reserved.</p>
            <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.</p>
        </div>
    </footer>

    <script>
        // Mobile menu functionality
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>