<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        header {
            background-color: rgba(0, 0, 0, 0.8);
            transition: background-color 0.5s;
        }
        
        .support-card {
            transition: all 0.3s ease;
            border: 1px solid #333;
        }
        
        .support-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px -5px rgba(255, 255, 255, 0.1), 0 10px 10px -5px rgba(255, 255, 255, 0.04);
        }
        
        .icon-container {
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background-color: #FFFFFF;
            color: #000000;
            margin-bottom: 20px;
        }

        .white-separator {
            height: 1px;
            background-color: rgba(255, 255, 255, 0.1);
            margin: 40px 0;
        }
    </style>
</head>
<body>
    <?php include 'src/header.php'; ?>

    <div class="w-full h-64 md:h-80 lg:h-96 overflow-hidden">
        <img src="banner_color.png" alt="Support Banner" class="w-full h-full object-cover">
    </div>
    
    <section class="py-10">
        <div class="container px-4 mx-auto">
            <div class="max-w-6xl mx-auto">
                <h1 class="text-4xl lg:text-5xl font-light mb-6">Support.</h1>
                <p class="text-xl text-gray-400">This page contains everything you need to contact us at the right address.</p>
            </div>
        </div>
    </section>

    <div class="white-separator max-w-6xl mx-auto px-4"></div>

    <section class="py-8">
        <div class="container px-4 mx-auto">
            <div class="max-w-6xl mx-auto grid grid-cols-1 md:grid-cols-3 gap-10">
                <div class="flex flex-col">
                    <div class="flex items-center mb-6">
                        <div class="bg-white rounded-full p-3 mr-4">
                            <i class="fas fa-tools text-black text-xl"></i>
                        </div>
                        <h3 class="text-xl font-bold">Hardware Support</h3>
                    </div>
                    <p class="text-gray-400 mb-6">Technical issues with any of our products purchased from a Cergies Store by Imators.</p>
                    <p class="text-sm text-gray-300 mb-4"><i class="fas fa-info-circle mr-2"></i> Account required for this support channel</p>
                    <a href="https://idsma.imators.com" class="inline-block bg-white text-black font-medium px-6 py-3 rounded-lg hover:bg-gray-200 transition-colors text-center">Access Support Portal</a>
                </div>

                <div class="flex flex-col">
                    <div class="flex items-center mb-6">
                        <div class="bg-white rounded-full p-3 mr-4">
                            <i class="fas fa-newspaper text-black text-xl"></i>
                        </div>
                        <h3 class="text-xl font-bold">Press Inquiries</h3>
                    </div>
                    <p class="text-gray-400 mb-6">For interview requests or article placement, contact our press team directly.</p>
                    <a href="mailto:press@imators.com" class="text-white hover:text-gray-300 transition-colors mb-4"><i class="fas fa-envelope mr-2"></i> press@imators.com</a>
                    <a href="mailto:press@imators.com" class="inline-block bg-white text-black font-medium px-6 py-3 rounded-lg hover:bg-gray-200 transition-colors text-center mt-auto">Contact Press Team</a>
                </div>

                <div class="flex flex-col">
                    <div class="flex items-center mb-6">
                        <div class="bg-white rounded-full p-3 mr-4">
                            <i class="fas fa-network-wired text-black text-xl"></i>
                        </div>
                        <h3 class="text-xl font-bold">Technical Support</h3>
                    </div>
                    <p class="text-gray-400 mb-6">For network issues or service unavailability due to various causes.</p>
                    <p class="text-sm text-gray-300 mb-4"><i class="fas fa-info-circle mr-2"></i> Account required for this support channel</p>
                    <a href="https://idsma.imators.com" class="inline-block bg-white text-black font-medium px-6 py-3 rounded-lg hover:bg-gray-200 transition-colors text-center">Access Support Portal</a>
                </div>
            </div>
        </div>
    </section>

    <div class="white-separator max-w-6xl mx-auto px-4"></div>

    <section class="py-8">
        <div class="container px-4 mx-auto">
            <div class="max-w-6xl mx-auto">
                <div class="flex items-center mb-6">
                    <div class="bg-white rounded-full p-3 mr-4">
                        <i class="fas fa-comments text-black text-xl"></i>
                    </div>
                    <h3 class="text-xl font-bold">Community Forum</h3>
                </div>
                <p class="text-gray-400 mb-6 max-w-2xl">Join our community forum to find answers, share experiences, and connect with other Imators users.</p>
                <a href="/forum" class="inline-block bg-white text-black font-medium px-6 py-3 rounded-lg hover:bg-gray-200 transition-colors text-center">Visit Forum</a>
            </div>
        </div>
    </section>

    <div class="white-separator max-w-6xl mx-auto px-4"></div>

    <section class="py-8">
        <div class="container px-4 mx-auto">
            <div class="max-w-6xl mx-auto">
                <h2 class="text-2xl font-bold mb-8">Need Quick Help?</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-10 mb-10">
                    <div class="flex">
                        <div class="mr-4">
                            <i class="fas fa-book text-xl text-white"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold mb-3">Knowledge Base</h3>
                            <p class="text-gray-400 mb-4">Browse our extensive knowledge base for guides and solutions to common issues.</p>
                            <a href="/kb" class="text-white font-medium hover:text-gray-300 transition-colors">Explore Knowledge Base →</a>
                        </div>
                    </div>
                    
                    <div class="flex">
                        <div class="mr-4">
                            <i class="fas fa-download text-xl text-white"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold mb-3">Downloads</h3>
                            <p class="text-gray-400 mb-4">Access manuals, software updates, and drivers for Imators products.</p>
                            <a href="/downloads" class="text-white font-medium hover:text-gray-300 transition-colors">Go to Downloads →</a>
                        </div>
                    </div>
                </div>
                
                <div class="flex items-center">
                    <p class="text-gray-400 mr-6">Still can't find what you're looking for?</p>
                    <a href="/contact" class="inline-block bg-white text-black font-medium px-6 py-3 rounded-lg hover:bg-gray-200 transition-colors">Contact Us</a>
                </div>
            </div>
        </div>
    </section>

    <div class="white-separator max-w-6xl mx-auto px-4"></div>

    <section class="py-8">
        <div class="container px-4 mx-auto">
            <div class="max-w-6xl mx-auto">
                <h2 class="text-2xl font-bold mb-6">Support Hours</h2>
                <div class="flex items-center">
                    <i class="far fa-clock text-xl mr-4"></i>
                    <div>
                        <p class="text-white">Everyday : 9:00 AM - 6:00 PM GMT</p>
                        <p class="text-gray-400 text-sm mt-2">Our support team is available during these hours. For urgent issues outside of these hours, please use our ticket system, and we'll respond as soon as possible.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="white-separator max-w-6xl mx-auto px-4"></div>

    <footer class="bg-black text-white py-10">
        <div class="max-w-6xl mx-auto px-4 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 mb-8 md:mb-0">
                <h5 class="text-xs uppercase font-medium mb-6">Follow Us</h5>
                <div class="flex items-center">
                    <a href="https://instagram.com/itsimators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 mb-8 md:mb-0">
                <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
                <div class="flex flex-col space-y-3">
                    <a href="/privacy" class="hover:text-gray-100 text-sm font-medium duration-700">Privacy Policy</a>
                    <a href="/terms-of-use" class="hover:text-gray-100 text-sm font-medium duration-700">Terms of Use</a>
                    <a href="/" class="hover:text-gray-100 text-sm font-medium duration-700">Home</a>
                    <a href="/about-us" class="hover:text-gray-100 text-sm font-medium duration-700">About Us</a>
                    <a href="/contact-us" class="hover:text-gray-100 text-sm font-medium duration-700">Contact Us</a>
                </div>
            </div>
            <div class="w-full md:w-1/3">
                <h5 class="text-xs uppercase font-medium mb-6">Possible reality</h5>
                <p class="text-sm">All images, videos, and content on this site are the property of Imators.</p>
            </div>
        </div>
        <div class="max-w-6xl mx-auto px-4">
            <div class="white-separator"></div>
            <div class="py-4">
                <p class="text-sm mb-2">&copy; 2025 Imators. All rights reserved.</p>
                <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.</p>
            </div>
        </div>
    </footer>

    <script>
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>