<?php
require_once '../includes/db.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode([
        'success' => false,
        'message' => 'Non autorisé'
    ]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        'success' => false,
        'message' => 'Méthode non autorisée'
    ]);
    exit;
}

$mission_id = $_POST['mission_id'] ?? '';
$progress_increment = intval($_POST['progress_increment'] ?? 0);

if (empty($mission_id) || $progress_increment <= 0) {
    echo json_encode([
        'success' => false,
        'message' => 'Paramètres invalides'
    ]);
    exit;
}

// Récupérer la mission
$user_mission = db_get_one(
    "SELECT * FROM user_missions WHERE id = ? AND user_id = ? AND status = 'active'",
    [$mission_id, $_SESSION['user_id']]
);

if (!$user_mission) {
    echo json_encode([
        'success' => false,
        'message' => 'Mission non trouvée ou non active'
    ]);
    exit;
}

// Calculer la nouvelle progression
$new_progress = min(100, $user_mission['progress'] + $progress_increment);

// Mettre à jour la progression
$updated = db_update(
    'user_missions',
    ['progress' => $new_progress],
    'id = ?',
    [$mission_id]
);

if ($updated) {
    echo json_encode([
        'success' => true,
        'progress' => $new_progress,
        'completed' => $new_progress >= 100
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Erreur lors de la mise à jour de la progression'
    ]);
}
?>